/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.reader;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.paimon.data.columnar.heap.HeapIntVector;
import org.apache.paimon.data.columnar.writable.WritableBytesVector;
import org.apache.paimon.format.parquet.reader.VectorizedDeltaBinaryPackedReader;
import org.apache.paimon.format.parquet.reader.VectorizedReaderBase;
import org.apache.paimon.format.parquet.reader.VectorizedValuesReader;
import org.apache.paimon.shade.org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.paimon.shade.org.apache.parquet.io.ParquetDecodingException;

public class VectorizedDeltaLengthByteArrayReader
extends VectorizedReaderBase
implements VectorizedValuesReader {
    private final VectorizedDeltaBinaryPackedReader lengthReader = new VectorizedDeltaBinaryPackedReader();
    private ByteBufferInputStream in;
    private HeapIntVector lengthsVector;
    private int currentRow = 0;

    VectorizedDeltaLengthByteArrayReader() {
    }

    @Override
    public void initFromPage(int valueCount, ByteBufferInputStream in) throws IOException {
        this.lengthsVector = new HeapIntVector(valueCount);
        this.lengthReader.initFromPage(valueCount, in);
        this.lengthReader.readIntegers(this.lengthReader.getTotalValueCount(), this.lengthsVector, 0);
        this.in = in.remainingStream();
    }

    @Override
    public void readBinary(int total, WritableBytesVector c, int rowId) {
        VectorizedValuesReader.ByteBufferOutputWriter outputWriter = VectorizedValuesReader.ByteBufferOutputWriter::writeArrayByteBuffer;
        for (int i = 0; i < total; ++i) {
            ByteBuffer buffer;
            int length = this.lengthsVector.getInt(rowId + i);
            try {
                buffer = this.in.slice(length);
            }
            catch (EOFException e) {
                throw new ParquetDecodingException("Failed to read " + length + " bytes");
            }
            outputWriter.write(c, rowId + i, buffer, length);
        }
        this.currentRow += total;
    }

    public ByteBuffer getBytes(int rowId) {
        int length = this.lengthsVector.getInt(rowId);
        try {
            return this.in.slice(length);
        }
        catch (EOFException e) {
            throw new ParquetDecodingException("Failed to read " + length + " bytes");
        }
    }

    @Override
    public void skipBinary(int total) {
        for (int i = 0; i < total; ++i) {
            int remaining = this.lengthsVector.getInt(this.currentRow + i);
            while (remaining > 0) {
                remaining = (int)((long)remaining - this.in.skip(remaining));
            }
        }
        this.currentRow += total;
    }
}

