/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.client;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public interface ClientPool<C, E extends Exception> {
    public <R> R run(Action<R, C, E> var1) throws E, InterruptedException;

    public void execute(ExecuteAction<C, E> var1) throws E, InterruptedException;

    public static abstract class ClientPoolImpl<C, E extends Exception>
    implements Closeable,
    ClientPool<C, E> {
        private volatile LinkedBlockingDeque<C> clients = new LinkedBlockingDeque();

        protected ClientPoolImpl(int poolSize, Supplier<C> supplier) {
            for (int i = 0; i < poolSize; ++i) {
                this.clients.add(supplier.get());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <R> R run(Action<R, C, E> action) throws E, InterruptedException {
            LinkedBlockingDeque<C> clients;
            C client;
            do {
                if ((clients = this.clients) != null) continue;
                throw new IllegalStateException("Cannot get a client from a closed pool");
            } while ((client = clients.pollFirst(10L, TimeUnit.SECONDS)) == null);
            try {
                R r = action.run(client);
                return r;
            }
            finally {
                clients.addFirst(client);
            }
        }

        @Override
        public void execute(ExecuteAction<C, E> action) throws E, InterruptedException {
            this.run(client -> {
                action.run(client);
                return null;
            });
        }

        protected abstract void close(C var1);

        @Override
        public void close() {
            LinkedBlockingDeque<C> clients = this.clients;
            this.clients = null;
            if (clients != null) {
                ArrayList drain = new ArrayList();
                clients.drainTo(drain);
                drain.forEach(this::close);
            }
        }
    }

    public static interface ExecuteAction<C, E extends Exception> {
        public void run(C var1) throws E;
    }

    public static interface Action<R, C, E extends Exception> {
        public R run(C var1) throws E;
    }
}

