/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.casting;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeFamily;
import org.apache.paimon.types.DataTypeRoot;

public class CastRulePredicate {
    private final Set<DataType> targetTypes;
    private final Set<DataTypeRoot> inputTypeRoots;
    private final Set<DataTypeRoot> targetTypeRoots;
    private final Set<DataTypeFamily> inputTypeFamilies;
    private final Set<DataTypeFamily> targetTypeFamilies;

    private CastRulePredicate(Set<DataType> targetTypes, Set<DataTypeRoot> inputTypeRoots, Set<DataTypeRoot> targetTypeRoots, Set<DataTypeFamily> inputTypeFamilies, Set<DataTypeFamily> targetTypeFamilies) {
        this.targetTypes = targetTypes;
        this.inputTypeRoots = inputTypeRoots;
        this.targetTypeRoots = targetTypeRoots;
        this.inputTypeFamilies = inputTypeFamilies;
        this.targetTypeFamilies = targetTypeFamilies;
    }

    public Set<DataType> getTargetTypes() {
        return this.targetTypes;
    }

    public Set<DataTypeRoot> getInputTypeRoots() {
        return this.inputTypeRoots;
    }

    public Set<DataTypeRoot> getTargetTypeRoots() {
        return this.targetTypeRoots;
    }

    public Set<DataTypeFamily> getInputTypeFamilies() {
        return this.inputTypeFamilies;
    }

    public Set<DataTypeFamily> getTargetTypeFamilies() {
        return this.targetTypeFamilies;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Set<DataTypeRoot> inputTypeRoots = new HashSet<DataTypeRoot>();
        private final Set<DataTypeRoot> targetTypeRoots = new HashSet<DataTypeRoot>();
        private final Set<DataType> targetTypes = new HashSet<DataType>();
        private final Set<DataTypeFamily> inputTypeFamilies = new HashSet<DataTypeFamily>();
        private final Set<DataTypeFamily> targetTypeFamilies = new HashSet<DataTypeFamily>();

        public Builder input(DataTypeRoot inputTypeRoot) {
            this.inputTypeRoots.add(inputTypeRoot);
            return this;
        }

        public Builder target(DataTypeRoot outputTypeRoot) {
            this.targetTypeRoots.add(outputTypeRoot);
            return this;
        }

        public Builder target(DataType outputType) {
            this.targetTypes.add(outputType);
            return this;
        }

        public Builder input(DataTypeFamily inputTypeFamily) {
            this.inputTypeFamilies.add(inputTypeFamily);
            return this;
        }

        public Builder target(DataTypeFamily outputTypeFamily) {
            this.targetTypeFamilies.add(outputTypeFamily);
            return this;
        }

        public CastRulePredicate build() {
            return new CastRulePredicate(Collections.unmodifiableSet(this.targetTypes), Collections.unmodifiableSet(this.inputTypeRoots), Collections.unmodifiableSet(this.targetTypeRoots), Collections.unmodifiableSet(this.inputTypeFamilies), Collections.unmodifiableSet(this.targetTypeFamilies));
        }
    }
}

