/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.lake.paimon.source;

import java.io.IOException;
import java.util.Arrays;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.fluss.lake.paimon.source.PaimonSplit;
import org.apache.fluss.lake.paimon.utils.PaimonConversions;
import org.apache.fluss.lake.paimon.utils.PaimonRowAsFlussRow;
import org.apache.fluss.lake.source.RecordReader;
import org.apache.fluss.record.ChangeType;
import org.apache.fluss.record.GenericRecord;
import org.apache.fluss.record.LogRecord;
import org.apache.fluss.row.InternalRow;
import org.apache.fluss.row.ProjectedRow;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.source.ReadBuilder;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.CloseableIterator;

public class PaimonRecordReader
implements RecordReader {
    protected PaimonRowAsFlussRecordIterator iterator;
    @Nullable
    protected int[][] project;
    @Nullable
    protected Predicate predicate;
    protected RowType paimonRowType;

    public PaimonRecordReader(FileStoreTable fileStoreTable, PaimonSplit split, @Nullable int[][] project, @Nullable Predicate predicate) throws IOException {
        ReadBuilder readBuilder = fileStoreTable.newReadBuilder();
        RowType paimonFullRowType = fileStoreTable.rowType();
        if (project != null) {
            readBuilder = this.applyProject(readBuilder, project, paimonFullRowType);
        }
        if (predicate != null) {
            readBuilder.withFilter(predicate);
        }
        TableRead tableRead = readBuilder.newRead().executeFilter();
        this.paimonRowType = readBuilder.readType();
        org.apache.paimon.reader.RecordReader<org.apache.paimon.data.InternalRow> recordReader = tableRead.createReader(split.dataSplit());
        this.iterator = new PaimonRowAsFlussRecordIterator(recordReader.toCloseableIterator(), this.paimonRowType);
    }

    public org.apache.fluss.utils.CloseableIterator<LogRecord> read() throws IOException {
        return this.iterator;
    }

    private ReadBuilder applyProject(ReadBuilder readBuilder, int[][] projects, RowType paimonFullRowType) {
        int[] projectIds = Arrays.stream(projects).mapToInt(project -> project[0]).toArray();
        int offsetFieldPos = paimonFullRowType.getFieldIndex("__offset");
        int timestampFieldPos = paimonFullRowType.getFieldIndex("__timestamp");
        int[] paimonProject = IntStream.concat(IntStream.of(projectIds), IntStream.of(offsetFieldPos, timestampFieldPos)).toArray();
        return readBuilder.withProjection(paimonProject);
    }

    public static class PaimonRowAsFlussRecordIterator
    implements org.apache.fluss.utils.CloseableIterator<LogRecord> {
        private final CloseableIterator<org.apache.paimon.data.InternalRow> paimonRowIterator;
        private final ProjectedRow projectedRow;
        private final PaimonRowAsFlussRow paimonRowAsFlussRow;
        private final int logOffsetColIndex;
        private final int timestampColIndex;

        public PaimonRowAsFlussRecordIterator(CloseableIterator<org.apache.paimon.data.InternalRow> paimonRowIterator, RowType paimonRowType) {
            this.paimonRowIterator = paimonRowIterator;
            this.logOffsetColIndex = paimonRowType.getFieldIndex("__offset");
            this.timestampColIndex = paimonRowType.getFieldIndex("__timestamp");
            int[] project = IntStream.range(0, paimonRowType.getFieldCount() - 2).toArray();
            this.projectedRow = ProjectedRow.from((int[])project);
            this.paimonRowAsFlussRow = new PaimonRowAsFlussRow();
        }

        public void close() {
            try {
                this.paimonRowIterator.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Fail to close iterator.", e);
            }
        }

        public boolean hasNext() {
            return this.paimonRowIterator.hasNext();
        }

        public LogRecord next() {
            org.apache.paimon.data.InternalRow paimonRow = (org.apache.paimon.data.InternalRow)this.paimonRowIterator.next();
            ChangeType changeType = PaimonConversions.toChangeType(paimonRow.getRowKind());
            long offset = paimonRow.getLong(this.logOffsetColIndex);
            long timestamp = paimonRow.getTimestamp(this.timestampColIndex, 6).getMillisecond();
            return new GenericRecord(offset, timestamp, changeType, (InternalRow)this.projectedRow.replaceRow((InternalRow)this.paimonRowAsFlussRow.replaceRow(paimonRow)));
        }
    }
}

