package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * No property names are defined but any property name they should be described by JSON Schema. So &#39;additionalProperties&#39; implements &#39;name&#39;.
 **/
@ApiModel(description = "No property names are defined but any property name they should be described by JSON Schema. So 'additionalProperties' implements 'name'.")
@JsonTypeName("propertiesSchema_properties_value")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-10-02T21:29:12.775428718Z[Etc/UTC]")
public class PropertiesSchemaPropertiesValue   {
  private @Valid String title;
  private @Valid String description;
  public enum TypeEnum {

    ARRAY(String.valueOf("array")), BOOLEAN(String.valueOf("boolean")), INTEGER(String.valueOf("integer")), NULL(String.valueOf("null")), NUMBER(String.valueOf("number")), OBJECT(String.valueOf("object")), STRING(String.valueOf("string"));


    private String value;

    TypeEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Convert a String into String, as specified in the
     * <a href="https://download.oracle.com/otndocs/jcp/jaxrs-2_0-fr-eval-spec/index.html">See JAX RS 2.0 Specification, section 3.2, p. 12</a>
     */
	public static TypeEnum fromString(String s) {
        for (TypeEnum b : TypeEnum.values()) {
            // using Objects.toString() to be safe if value type non-object type
            // because types like 'int' etc. will be auto-boxed
            if (java.util.Objects.toString(b.value).equals(s)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected string value '" + s + "'");
	}
	
    @JsonCreator
    public static TypeEnum fromValue(String value) {
        for (TypeEnum b : TypeEnum.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
}

  private @Valid TypeEnum type;
  private @Valid Set<Object> _enum = null;
  private @Valid String format;
  private @Valid String contentMediaType;
  private @Valid BigDecimal maximum;
  private @Valid BigDecimal exclusiveMaximum;
  private @Valid BigDecimal minimum;
  private @Valid BigDecimal exclusiveMinimum;
  private @Valid String pattern;
  private @Valid Integer maxItems;
  private @Valid Integer minItems = 0;
  private @Valid String observedProperty;
  private @Valid URI observedPropertyURI;
  private @Valid String uom;
  private @Valid URI uomURI;

  /**
   **/
  public PropertiesSchemaPropertiesValue title(String title) {
    this.title = title;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("title")
  public String getTitle() {
    return title;
  }

  @JsonProperty("title")
  public void setTitle(String title) {
    this.title = title;
  }

  /**
   * Implements &#39;description&#39;
   **/
  public PropertiesSchemaPropertiesValue description(String description) {
    this.description = description;
    return this;
  }

  
  @ApiModelProperty(value = "Implements 'description'")
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  @JsonProperty("description")
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   **/
  public PropertiesSchemaPropertiesValue type(TypeEnum type) {
    this.type = type;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("type")
  public TypeEnum getType() {
    return type;
  }

  @JsonProperty("type")
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   * Implements &#39;acceptedValues&#39;
   **/
  public PropertiesSchemaPropertiesValue _enum(Set<Object> _enum) {
    this._enum = _enum;
    return this;
  }

  
  @ApiModelProperty(value = "Implements 'acceptedValues'")
  @JsonProperty("enum")
 @Size(min=1)  public Set<Object> getEnum() {
    return _enum;
  }

  @JsonProperty("enum")
  @JsonDeserialize(as = LinkedHashSet.class)
  public void setEnum(Set<Object> _enum) {
    this._enum = _enum;
  }

  public PropertiesSchemaPropertiesValue addEnumItem(Object _enumItem) {
    if (this._enum == null) {
      this._enum = new LinkedHashSet<>();
    }

    this._enum.add(_enumItem);
    return this;
  }

  public PropertiesSchemaPropertiesValue removeEnumItem(Object _enumItem) {
    if (_enumItem != null && this._enum != null) {
      this._enum.remove(_enumItem);
    }

    return this;
  }
  /**
   * Complements implementation of &#39;type&#39;
   **/
  public PropertiesSchemaPropertiesValue format(String format) {
    this.format = format;
    return this;
  }

  
  @ApiModelProperty(value = "Complements implementation of 'type'")
  @JsonProperty("format")
  public String getFormat() {
    return format;
  }

  @JsonProperty("format")
  public void setFormat(String format) {
    this.format = format;
  }

  /**
   * Implements &#39;mediaType&#39;
   **/
  public PropertiesSchemaPropertiesValue contentMediaType(String contentMediaType) {
    this.contentMediaType = contentMediaType;
    return this;
  }

  
  @ApiModelProperty(value = "Implements 'mediaType'")
  @JsonProperty("contentMediaType")
  public String getContentMediaType() {
    return contentMediaType;
  }

  @JsonProperty("contentMediaType")
  public void setContentMediaType(String contentMediaType) {
    this.contentMediaType = contentMediaType;
  }

  /**
   * Implements &#39;range&#39;
   **/
  public PropertiesSchemaPropertiesValue maximum(BigDecimal maximum) {
    this.maximum = maximum;
    return this;
  }

  
  @ApiModelProperty(value = "Implements 'range'")
  @JsonProperty("maximum")
  public BigDecimal getMaximum() {
    return maximum;
  }

  @JsonProperty("maximum")
  public void setMaximum(BigDecimal maximum) {
    this.maximum = maximum;
  }

  /**
   * Implements &#39;range&#39;
   **/
  public PropertiesSchemaPropertiesValue exclusiveMaximum(BigDecimal exclusiveMaximum) {
    this.exclusiveMaximum = exclusiveMaximum;
    return this;
  }

  
  @ApiModelProperty(value = "Implements 'range'")
  @JsonProperty("exclusiveMaximum")
  public BigDecimal getExclusiveMaximum() {
    return exclusiveMaximum;
  }

  @JsonProperty("exclusiveMaximum")
  public void setExclusiveMaximum(BigDecimal exclusiveMaximum) {
    this.exclusiveMaximum = exclusiveMaximum;
  }

  /**
   * Implements &#39;range&#39;
   **/
  public PropertiesSchemaPropertiesValue minimum(BigDecimal minimum) {
    this.minimum = minimum;
    return this;
  }

  
  @ApiModelProperty(value = "Implements 'range'")
  @JsonProperty("minimum")
  public BigDecimal getMinimum() {
    return minimum;
  }

  @JsonProperty("minimum")
  public void setMinimum(BigDecimal minimum) {
    this.minimum = minimum;
  }

  /**
   * Implements &#39;range&#39;
   **/
  public PropertiesSchemaPropertiesValue exclusiveMinimum(BigDecimal exclusiveMinimum) {
    this.exclusiveMinimum = exclusiveMinimum;
    return this;
  }

  
  @ApiModelProperty(value = "Implements 'range'")
  @JsonProperty("exclusiveMinimum")
  public BigDecimal getExclusiveMinimum() {
    return exclusiveMinimum;
  }

  @JsonProperty("exclusiveMinimum")
  public void setExclusiveMinimum(BigDecimal exclusiveMinimum) {
    this.exclusiveMinimum = exclusiveMinimum;
  }

  /**
   **/
  public PropertiesSchemaPropertiesValue pattern(String pattern) {
    this.pattern = pattern;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("pattern")
  public String getPattern() {
    return pattern;
  }

  @JsonProperty("pattern")
  public void setPattern(String pattern) {
    this.pattern = pattern;
  }

  /**
   * Implements &#39;upperMultiplicity&#39;
   * minimum: 0
   **/
  public PropertiesSchemaPropertiesValue maxItems(Integer maxItems) {
    this.maxItems = maxItems;
    return this;
  }

  
  @ApiModelProperty(value = "Implements 'upperMultiplicity'")
  @JsonProperty("maxItems")
 @Min(0)  public Integer getMaxItems() {
    return maxItems;
  }

  @JsonProperty("maxItems")
  public void setMaxItems(Integer maxItems) {
    this.maxItems = maxItems;
  }

  /**
   * Implements &#39;lowerMultiplicity&#39;
   * minimum: 0
   **/
  public PropertiesSchemaPropertiesValue minItems(Integer minItems) {
    this.minItems = minItems;
    return this;
  }

  
  @ApiModelProperty(value = "Implements 'lowerMultiplicity'")
  @JsonProperty("minItems")
 @Min(0)  public Integer getMinItems() {
    return minItems;
  }

  @JsonProperty("minItems")
  public void setMinItems(Integer minItems) {
    this.minItems = minItems;
  }

  /**
   **/
  public PropertiesSchemaPropertiesValue observedProperty(String observedProperty) {
    this.observedProperty = observedProperty;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("observedProperty")
  public String getObservedProperty() {
    return observedProperty;
  }

  @JsonProperty("observedProperty")
  public void setObservedProperty(String observedProperty) {
    this.observedProperty = observedProperty;
  }

  /**
   **/
  public PropertiesSchemaPropertiesValue observedPropertyURI(URI observedPropertyURI) {
    this.observedPropertyURI = observedPropertyURI;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("observedPropertyURI")
  public URI getObservedPropertyURI() {
    return observedPropertyURI;
  }

  @JsonProperty("observedPropertyURI")
  public void setObservedPropertyURI(URI observedPropertyURI) {
    this.observedPropertyURI = observedPropertyURI;
  }

  /**
   **/
  public PropertiesSchemaPropertiesValue uom(String uom) {
    this.uom = uom;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("uom")
  public String getUom() {
    return uom;
  }

  @JsonProperty("uom")
  public void setUom(String uom) {
    this.uom = uom;
  }

  /**
   **/
  public PropertiesSchemaPropertiesValue uomURI(URI uomURI) {
    this.uomURI = uomURI;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("uomURI")
  public URI getUomURI() {
    return uomURI;
  }

  @JsonProperty("uomURI")
  public void setUomURI(URI uomURI) {
    this.uomURI = uomURI;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PropertiesSchemaPropertiesValue propertiesSchemaPropertiesValue = (PropertiesSchemaPropertiesValue) o;
    return Objects.equals(this.title, propertiesSchemaPropertiesValue.title) &&
        Objects.equals(this.description, propertiesSchemaPropertiesValue.description) &&
        Objects.equals(this.type, propertiesSchemaPropertiesValue.type) &&
        Objects.equals(this._enum, propertiesSchemaPropertiesValue._enum) &&
        Objects.equals(this.format, propertiesSchemaPropertiesValue.format) &&
        Objects.equals(this.contentMediaType, propertiesSchemaPropertiesValue.contentMediaType) &&
        Objects.equals(this.maximum, propertiesSchemaPropertiesValue.maximum) &&
        Objects.equals(this.exclusiveMaximum, propertiesSchemaPropertiesValue.exclusiveMaximum) &&
        Objects.equals(this.minimum, propertiesSchemaPropertiesValue.minimum) &&
        Objects.equals(this.exclusiveMinimum, propertiesSchemaPropertiesValue.exclusiveMinimum) &&
        Objects.equals(this.pattern, propertiesSchemaPropertiesValue.pattern) &&
        Objects.equals(this.maxItems, propertiesSchemaPropertiesValue.maxItems) &&
        Objects.equals(this.minItems, propertiesSchemaPropertiesValue.minItems) &&
        Objects.equals(this.observedProperty, propertiesSchemaPropertiesValue.observedProperty) &&
        Objects.equals(this.observedPropertyURI, propertiesSchemaPropertiesValue.observedPropertyURI) &&
        Objects.equals(this.uom, propertiesSchemaPropertiesValue.uom) &&
        Objects.equals(this.uomURI, propertiesSchemaPropertiesValue.uomURI);
  }

  @Override
  public int hashCode() {
    return Objects.hash(title, description, type, _enum, format, contentMediaType, maximum, exclusiveMaximum, minimum, exclusiveMinimum, pattern, maxItems, minItems, observedProperty, observedPropertyURI, uom, uomURI);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PropertiesSchemaPropertiesValue {\n");
    
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    _enum: ").append(toIndentedString(_enum)).append("\n");
    sb.append("    format: ").append(toIndentedString(format)).append("\n");
    sb.append("    contentMediaType: ").append(toIndentedString(contentMediaType)).append("\n");
    sb.append("    maximum: ").append(toIndentedString(maximum)).append("\n");
    sb.append("    exclusiveMaximum: ").append(toIndentedString(exclusiveMaximum)).append("\n");
    sb.append("    minimum: ").append(toIndentedString(minimum)).append("\n");
    sb.append("    exclusiveMinimum: ").append(toIndentedString(exclusiveMinimum)).append("\n");
    sb.append("    pattern: ").append(toIndentedString(pattern)).append("\n");
    sb.append("    maxItems: ").append(toIndentedString(maxItems)).append("\n");
    sb.append("    minItems: ").append(toIndentedString(minItems)).append("\n");
    sb.append("    observedProperty: ").append(toIndentedString(observedProperty)).append("\n");
    sb.append("    observedPropertyURI: ").append(toIndentedString(observedPropertyURI)).append("\n");
    sb.append("    uom: ").append(toIndentedString(uom)).append("\n");
    sb.append("    uomURI: ").append(toIndentedString(uomURI)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

