/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.http.api.UriComponentType;
import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;

final class UriUtils {
    private static final long DIGIT_LMASK = UriUtils.lowMask('0', '9');
    private static final long DIGIT_HMASK = UriUtils.highMask('0', '9');
    private static final long ALPHA_LMASK = UriUtils.lowMask('a', 'z') | UriUtils.lowMask('A', 'Z');
    private static final long ALPHA_HMASK = UriUtils.highMask('a', 'z') | UriUtils.highMask('A', 'Z');
    private static final long HEXDIG_LMASK = DIGIT_LMASK | UriUtils.lowMask('a', 'f') | UriUtils.lowMask('A', 'F');
    private static final long HEXDIG_HMASK = DIGIT_HMASK | UriUtils.highMask('a', 'f') | UriUtils.highMask('A', 'F');
    private static final long UNRESERVED_LMASK = ALPHA_LMASK | DIGIT_LMASK | UriUtils.lowMask("-._~");
    private static final long UNRESERVED_HMASK = ALPHA_HMASK | DIGIT_HMASK | UriUtils.highMask("-._~");
    private static final long SUBDELIM_LMASK = UriUtils.lowMask("!$&'()*+,;=");
    private static final long SUBDELIM_HMASK = UriUtils.highMask("!$&'()*+,;=");
    private static final long PCHAR_NOSUBDELIM_LMASK = UNRESERVED_LMASK | UriUtils.lowMask(":@");
    private static final long PCHAR_NOSUBDELIM_HMASK = UNRESERVED_HMASK | UriUtils.highMask(":@");
    private static final long PCHAR_LMASK = PCHAR_NOSUBDELIM_LMASK | SUBDELIM_LMASK;
    private static final long PCHAR_HMASK = PCHAR_NOSUBDELIM_HMASK | SUBDELIM_HMASK;
    static final long USERINFO_LMASK = UNRESERVED_LMASK | SUBDELIM_LMASK | UriUtils.lowMask(":");
    static final long USERINFO_HMASK = UNRESERVED_HMASK | SUBDELIM_HMASK | UriUtils.highMask(":");
    static final long PATH_LMASK = PCHAR_LMASK | UriUtils.lowMask("/");
    static final long PATH_HMASK = PCHAR_HMASK | UriUtils.highMask("/");
    static final long PATH_SEGMENT_LMASK = PCHAR_LMASK;
    static final long PATH_SEGMENT_HMASK = PCHAR_HMASK;
    static final long QUERY_LMASK = PCHAR_LMASK | UriUtils.lowMask("/?");
    static final long QUERY_HMASK = PCHAR_HMASK | UriUtils.highMask("/?");
    static final long QUERY_VALUE_LMASK = PCHAR_NOSUBDELIM_LMASK | UriUtils.lowMask("/?");
    static final long QUERY_VALUE_HMASK = PCHAR_NOSUBDELIM_HMASK | UriUtils.highMask("/?");
    static final long FRAGMENT_LMASK = QUERY_LMASK;
    static final long FRAGMENT_HMASK = QUERY_HMASK;
    static final long HOST_NON_IP_LMASK = UNRESERVED_LMASK | SUBDELIM_LMASK;
    static final long HOST_NON_IP_HMASK = UNRESERVED_HMASK | SUBDELIM_HMASK;
    static final long TCHAR_LMASK = UNRESERVED_LMASK | UriUtils.lowMask("!#$%&'*+^`|");
    static final long TCHAR_HMASK = UNRESERVED_HMASK | UriUtils.highMask("!#$%&'*+^`|");

    private UriUtils() {
    }

    static Map<String, List<String>> decodeQueryParams(@Nullable String rawQuery, Charset charset, int maxParams) {
        return UriUtils.decodeQueryParams(rawQuery, charset, maxParams, UriUtils::decodeComponent);
    }

    /*
     * Enabled aggressive block sorting
     */
    static Map<String, List<String>> decodeQueryParams(@Nullable String rawQuery, Charset charset, int maxParams, BiFunction<String, Charset, String> decoder) {
        int i;
        if (maxParams <= 0) {
            throw new IllegalArgumentException("maxParams: " + maxParams + " (expected: > 0)");
        }
        if (rawQuery == null || rawQuery.isEmpty()) {
            return new LinkedHashMap<String, List<String>>(8);
        }
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        int paramCountDown = maxParams;
        int from = rawQuery.charAt(0) == '?' ? 1 : 0;
        int len = rawQuery.length();
        int nameStart = from;
        int valueStart = -1;
        block5: for (i = from; i < len; ++i) {
            switch (rawQuery.charAt(i)) {
                case '=': {
                    if (nameStart == i) {
                        nameStart = i + 1;
                        break;
                    }
                    if (valueStart >= nameStart) break;
                    valueStart = i + 1;
                    break;
                }
                case '&': 
                case ';': {
                    if (nameStart < i) {
                        if (paramCountDown-- == 0) {
                            throw new IllegalStateException("maxParams[" + maxParams + "] exceeded");
                        }
                        UriUtils.addQueryParam(rawQuery, nameStart, valueStart, i, charset, params, decoder);
                    }
                    nameStart = i + 1;
                    break;
                }
                case '#': {
                    break block5;
                }
            }
        }
        if (nameStart < i) {
            if (paramCountDown <= 1) {
                throw new IllegalStateException("maxParams[" + maxParams + "] exceeded");
            }
            UriUtils.addQueryParam(rawQuery, nameStart, valueStart, i, charset, params, decoder);
        }
        return params;
    }

    static String encodeComponent(UriComponentType type, String component, Charset charset, boolean preservePctEncoded) {
        byte[] bytes = component.getBytes(charset);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if (type.isValid(b)) continue;
            if (preservePctEncoded && bytes.length - 3 >= i && UriUtils.isPctEncoded(bytes, b, i)) {
                i += 2;
                continue;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(bytes.length + 16);
            baos.write(bytes, 0, i);
            UriUtils.encodeHexDigits(baos, b);
            for (int j = i + 1; j < bytes.length; ++j) {
                b = bytes[j];
                if (type.isValid(b)) {
                    baos.write(b);
                    continue;
                }
                if (preservePctEncoded && bytes.length - 3 >= j && UriUtils.isPctEncoded(bytes, b, j)) {
                    baos.write(bytes, j, 3);
                    j += 2;
                    continue;
                }
                UriUtils.encodeHexDigits(baos, b);
            }
            return new String(baos.toByteArray(), charset);
        }
        return component;
    }

    static String decodeComponent(String s, Charset charset) {
        if (s.indexOf(37) < 0) {
            return s;
        }
        byte[] bytes = s.getBytes(charset);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if (b != 37) continue;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(bytes.length);
            baos.write(bytes, 0, i);
            baos.write(UriUtils.decodeHexDigits(bytes, i));
            for (int j = i + 3; j < bytes.length; ++j) {
                b = bytes[j];
                if (b == 37) {
                    baos.write(UriUtils.decodeHexDigits(bytes, j));
                    j += 2;
                    continue;
                }
                baos.write(b);
            }
            return new String(baos.toByteArray(), charset);
        }
        return s;
    }

    static int parsePort(String uri, int begin, int end) {
        int len = end - begin;
        if (len == 4) {
            return 1000 * UriUtils.toDecimal(uri.charAt(begin)) + 100 * UriUtils.toDecimal(uri.charAt(begin + 1)) + 10 * UriUtils.toDecimal(uri.charAt(begin + 2)) + UriUtils.toDecimal(uri.charAt(begin + 3));
        }
        if (len == 3) {
            return 100 * UriUtils.toDecimal(uri.charAt(begin)) + 10 * UriUtils.toDecimal(uri.charAt(begin + 1)) + UriUtils.toDecimal(uri.charAt(begin + 2));
        }
        if (len == 2) {
            return 10 * UriUtils.toDecimal(uri.charAt(begin)) + UriUtils.toDecimal(uri.charAt(begin + 1));
        }
        if (len == 5) {
            int port = 10000 * UriUtils.toDecimal(uri.charAt(begin)) + 1000 * UriUtils.toDecimal(uri.charAt(begin + 1)) + 100 * UriUtils.toDecimal(uri.charAt(begin + 2)) + 10 * UriUtils.toDecimal(uri.charAt(begin + 3)) + UriUtils.toDecimal(uri.charAt(begin + 4));
            if (port > 65535) {
                throw new IllegalArgumentException("port out of bounds: " + port);
            }
            return port;
        }
        if (len == 1) {
            return UriUtils.toDecimal(uri.charAt(begin));
        }
        throw new IllegalArgumentException("invalid port length: " + len);
    }

    private static void addQueryParam(String s, int nameStart, int valueStart, int valueEnd, Charset charset, Map<String, List<String>> params, BiFunction<String, Charset, String> decoder) {
        String value;
        String name;
        if (valueStart <= nameStart) {
            name = decoder.apply(s.substring(nameStart, valueEnd), charset);
            value = null;
        } else {
            name = decoder.apply(s.substring(nameStart, valueStart - 1), charset);
            value = decoder.apply(s.substring(valueStart, valueEnd), charset);
        }
        List values = params.computeIfAbsent(name, k -> new ArrayList(1));
        values.add(value);
    }

    private static void encodeHexDigits(ByteArrayOutputStream baos, byte b) {
        baos.write(37);
        baos.write(UriUtils.encodeHexNibble(b >>> 4 & 0xF));
        baos.write(UriUtils.encodeHexNibble(b & 0xF));
    }

    private static byte decodeHexDigits(byte[] bytes, int i) {
        if (bytes.length - 2 <= i) {
            throw new IllegalArgumentException("Invalid pct-encoded at index " + i);
        }
        int hi = UriUtils.decodeHexNibble(bytes[i + 1]);
        int lo = UriUtils.decodeHexNibble(bytes[i + 2]);
        if (hi == -1 || lo == -1) {
            throw new IllegalArgumentException("Invalid HEXDIG at index " + i);
        }
        return (byte)((hi << 4) + lo);
    }

    private static byte encodeHexNibble(int b) {
        if (b < 0 || b >= 16) {
            return 0;
        }
        if (b < 10) {
            return (byte)(48 + b);
        }
        return (byte)(55 + b);
    }

    private static int decodeHexNibble(byte b) {
        if (b >= 48 && b <= 57) {
            return b - 48;
        }
        if (b >= 65 && b <= 70) {
            return b - 55;
        }
        if (b >= 97 && b <= 102) {
            return b - 87;
        }
        return -1;
    }

    private static int toDecimal(char c) {
        if (c < '0' || c > '9') {
            throw new IllegalArgumentException("invalid decimal character: " + c);
        }
        return c - 48;
    }

    private static boolean isPctEncoded(byte[] bytes, byte b, int bIndex) {
        return b == 37 && UriUtils.isHexDig(bytes[bIndex + 1]) && UriUtils.isHexDig(bytes[bIndex + 2]);
    }

    private static boolean isHexDig(byte b) {
        return UriUtils.isBitSet(b, HEXDIG_LMASK, HEXDIG_HMASK);
    }

    private static long lowMask(String asciiChars) {
        long mask = 0L;
        for (int i = 0; i < asciiChars.length(); ++i) {
            char c = asciiChars.charAt(i);
            if (c >= '@') continue;
            mask |= 1L << c;
        }
        return mask;
    }

    private static long lowMask(char first, char last) {
        assert (first <= 127 && last <= '\u007f');
        if (first > 63) {
            return 0L;
        }
        long mask = 0L;
        int end = Math.min(last, 63);
        for (int i = first; i <= end; ++i) {
            mask |= 1L << i;
        }
        return mask;
    }

    private static long highMask(String asciiChars) {
        long mask = 0L;
        for (int i = 0; i < asciiChars.length(); ++i) {
            char c = asciiChars.charAt(i);
            if (c < '@' || c >= '\u0080') continue;
            mask |= 1L << c - 64;
        }
        return mask;
    }

    private static long highMask(char first, char last) {
        assert (first <= '\u007f' && last <= '\u007f');
        if (last < '@') {
            return 0L;
        }
        long mask = 0L;
        int begin = Math.max(first, 64) - 64;
        int end = last - 64;
        for (int i = begin; i <= end; ++i) {
            mask |= 1L << i;
        }
        return mask;
    }

    static boolean isBitSet(byte b, long lowMask, long highMask) {
        return b > 0 && (b < 64 ? (1L << b & lowMask) != 0L : (1L << b - 64 & highMask) != 0L);
    }
}

