/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow.tasks;

import java.nio.file.Files;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.apache.baremaps.workflow.WorkflowException;

public record ExecuteSqlScript(Object database, Path file) implements Task
{
    @Override
    public void execute(WorkflowContext context) throws Exception {
        String script = Files.readString(this.file);
        DataSource dataSource = context.getDataSource(this.database);
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute(script);
        }
        catch (SQLException e) {
            throw new WorkflowException(e);
        }
    }
}

