/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tilestore.postgres;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.apache.baremaps.tilestore.TileCoord;
import org.apache.baremaps.tilestore.TileStore;
import org.apache.baremaps.tilestore.TileStoreException;
import org.apache.baremaps.tilestore.VariableUtils;
import org.apache.baremaps.tilestore.postgres.PostgresGroup;
import org.apache.baremaps.tilestore.postgres.PostgresQuery;
import org.apache.baremaps.vectortile.tileset.Tileset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresTileStore
implements TileStore {
    private static final Logger logger = LoggerFactory.getLogger(PostgresTileStore.class);
    private static final String TILE_ENVELOPE = "st_tileenvelope(%1$s, %2$s, %3$s)";
    private static final String WITH_QUERY = "with %1$s %2$s";
    private static final String CTE_QUERY = "%1$s as (select * from %3$s%4$s where %5$s st_intersects(%2$s, $envelope))";
    private static final String CTE_WHERE = "(%s) and";
    private static final String STATEMENT_QUERY = "select st_asmvt(target, '%1$s', 4096, 'geom', 'id') from (%2$s) as target";
    private static final String STATEMENT_LAYER_QUERY = "select %1$s as id, (%2$s ||  jsonb_build_object('geometry', lower(replace(st_geometrytype(%3$s), 'ST_', '')))) as tags, st_asmvtgeom(%3$s, $envelope, 4096, 256, true) as geom from %4$s %5$s";
    private static final String STATEMENT_WHERE = "where %s";
    private static final String UNION = " union all ";
    private static final String COMMA = ", ";
    private static final String SPACE = " ";
    private static final String EMPTY = "";
    public static final String CONTENT_ENCODING = "gzip";
    public static final String CONTENT_TYPE = "application/vnd.mapbox-vector-tile";
    private final DataSource datasource;
    private final List<PostgresQuery> queries;

    public PostgresTileStore(DataSource datasource, List<PostgresQuery> queries) {
        this.datasource = datasource;
        this.queries = queries;
    }

    public PostgresTileStore(DataSource datasource, Tileset tileset) {
        this.datasource = datasource;
        this.queries = tileset.getVectorLayers().stream().flatMap(layer -> layer.getQueries().stream().map(query -> new PostgresQuery(layer.getId(), query.getMinzoom(), query.getMaxzoom(), query.getSql()))).toList();
    }

    /*
     * Exception decompiling
     */
    @Override
    public ByteBuffer read(TileCoord tileCoord) throws TileStoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String withQuery(TileCoord tileCoord) {
        int zoom = tileCoord.z();
        String sourceQueries = this.ctes(this.queries, zoom);
        String targetQueries = this.statements(this.queries, zoom);
        String withQuery = String.format(WITH_QUERY, sourceQueries, targetQueries);
        Map<String, String> variables = Map.of("envelope", this.tileEnvelope(tileCoord), "zoom", String.valueOf(zoom));
        return VariableUtils.interpolate(variables, withQuery);
    }

    protected String ctes(List<PostgresQuery> queries, int zoom) {
        return queries.stream().filter(query -> this.zoomPredicate((PostgresQuery)query, zoom)).collect(Collectors.groupingBy(this::commonTableExpression, LinkedHashMap::new, Collectors.toList())).entrySet().stream().map(entry -> this.cte((PostgresGroup)entry.getKey(), (List)entry.getValue())).distinct().collect(Collectors.joining(COMMA));
    }

    protected String cte(PostgresGroup group, List<PostgresQuery> queries) {
        String alias = group.getAlias();
        String geom = group.getSelectItems().get(2).toString();
        String from = group.getFromItem().toString();
        String joins = Optional.ofNullable(group.getJoins()).stream().flatMap(Collection::stream).map(Join::toString).collect(Collectors.joining(SPACE));
        String where = queries.stream().map(query -> query.getAst().getWhere()).map(Optional::ofNullable).map(o -> (Expression)o.orElse(new Column("true"))).map(Parenthesis::new).map(Expression.class::cast).reduce(OrExpression::new).map(expression -> String.format(CTE_WHERE, expression)).orElse(EMPTY);
        return String.format(CTE_QUERY, alias, geom, from, joins, where);
    }

    protected String statements(List<PostgresQuery> queries, int zoom) {
        return queries.stream().filter(query -> this.zoomPredicate((PostgresQuery)query, zoom)).collect(Collectors.groupingBy(PostgresQuery::getLayer, LinkedHashMap::new, Collectors.toList())).entrySet().stream().map(entry -> this.layerStatements((List)entry.getValue(), (String)entry.getKey())).collect(Collectors.joining(UNION));
    }

    protected String layerStatements(List<PostgresQuery> queries, String layer) {
        return String.format(STATEMENT_QUERY, layer, queries.stream().map(queryValue -> this.layerStatement((PostgresQuery)queryValue)).collect(Collectors.joining(UNION)));
    }

    protected String layerStatement(PostgresQuery query) {
        String alias = this.commonTableExpression(query).getAlias();
        PlainSelect ast = query.getAst();
        String id = ((SelectItem)ast.getSelectItems().get(0)).toString();
        String tags = ((SelectItem)ast.getSelectItems().get(1)).toString();
        String geom = ((SelectItem)ast.getSelectItems().get(2)).toString();
        String where = Optional.ofNullable(query.getAst().getWhere()).map(expression -> String.format(STATEMENT_WHERE, expression)).orElse(EMPTY);
        return String.format(STATEMENT_LAYER_QUERY, id, tags, geom, alias, where);
    }

    protected boolean zoomPredicate(PostgresQuery query, int zoom) {
        return query.getMinzoom() <= zoom && zoom < query.getMaxzoom();
    }

    protected PostgresGroup commonTableExpression(PostgresQuery query) {
        return new PostgresGroup(query.getAst().getSelectItems(), query.getAst().getFromItem(), query.getAst().getJoins());
    }

    protected String tileEnvelope(TileCoord tileCoord) {
        return String.format(TILE_ENVELOPE, tileCoord.z(), tileCoord.x(), tileCoord.y());
    }

    @Override
    public void write(TileCoord tileCoord, ByteBuffer blob) {
        throw new UnsupportedOperationException("The postgis tile store is read only");
    }

    @Override
    public void delete(TileCoord tileCoord) {
        throw new UnsupportedOperationException("The postgis tile store is read only");
    }

    private /* synthetic */ boolean lambda$read$2(TileCoord tileCoord, PostgresQuery query) {
        return this.zoomPredicate(query, tileCoord.z());
    }
}

