/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.baremaps.ogcapi.model.TilePointCrs;

@JsonTypeName(value="tilePoint")
public class TilePoint {
    @Valid
    private List<BigDecimal> coordinates = new ArrayList<BigDecimal>();
    @Valid
    private TilePointCrs crs;
    @Valid
    private String tileMatrix;
    @Valid
    private BigDecimal scaleDenominator;
    @Valid
    private BigDecimal cellSize;

    public TilePoint coordinates(List<BigDecimal> coordinates) {
        this.coordinates = coordinates;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="coordinates")
    @NotNull
    @Size(min=2, max=2)
    public @NotNull @Size(min=2, max=2) List<BigDecimal> getCoordinates() {
        return this.coordinates;
    }

    @JsonProperty(value="coordinates")
    public void setCoordinates(List<BigDecimal> coordinates) {
        this.coordinates = coordinates;
    }

    public TilePoint addCoordinatesItem(BigDecimal coordinatesItem) {
        if (this.coordinates == null) {
            this.coordinates = new ArrayList<BigDecimal>();
        }
        this.coordinates.add(coordinatesItem);
        return this;
    }

    public TilePoint removeCoordinatesItem(BigDecimal coordinatesItem) {
        if (coordinatesItem != null && this.coordinates != null) {
            this.coordinates.remove(coordinatesItem);
        }
        return this;
    }

    public TilePoint crs(TilePointCrs crs) {
        this.crs = crs;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="crs")
    public TilePointCrs getCrs() {
        return this.crs;
    }

    @JsonProperty(value="crs")
    public void setCrs(TilePointCrs crs) {
        this.crs = crs;
    }

    public TilePoint tileMatrix(String tileMatrix) {
        this.tileMatrix = tileMatrix;
        return this;
    }

    @ApiModelProperty(value="TileMatrix identifier associated with the scaleDenominator")
    @JsonProperty(value="tileMatrix")
    public String getTileMatrix() {
        return this.tileMatrix;
    }

    @JsonProperty(value="tileMatrix")
    public void setTileMatrix(String tileMatrix) {
        this.tileMatrix = tileMatrix;
    }

    public TilePoint scaleDenominator(BigDecimal scaleDenominator) {
        this.scaleDenominator = scaleDenominator;
        return this;
    }

    @ApiModelProperty(value="Scale denominator of the tile matrix selected")
    @JsonProperty(value="scaleDenominator")
    public BigDecimal getScaleDenominator() {
        return this.scaleDenominator;
    }

    @JsonProperty(value="scaleDenominator")
    public void setScaleDenominator(BigDecimal scaleDenominator) {
        this.scaleDenominator = scaleDenominator;
    }

    public TilePoint cellSize(BigDecimal cellSize) {
        this.cellSize = cellSize;
        return this;
    }

    @ApiModelProperty(value="Cell size of the tile matrix selected")
    @JsonProperty(value="cellSize")
    public BigDecimal getCellSize() {
        return this.cellSize;
    }

    @JsonProperty(value="cellSize")
    public void setCellSize(BigDecimal cellSize) {
        this.cellSize = cellSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TilePoint tilePoint = (TilePoint)o;
        return Objects.equals(this.coordinates, tilePoint.coordinates) && Objects.equals(this.crs, tilePoint.crs) && Objects.equals(this.tileMatrix, tilePoint.tileMatrix) && Objects.equals(this.scaleDenominator, tilePoint.scaleDenominator) && Objects.equals(this.cellSize, tilePoint.cellSize);
    }

    public int hashCode() {
        return Objects.hash(this.coordinates, this.crs, this.tileMatrix, this.scaleDenominator, this.cellSize);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TilePoint {\n");
        sb.append("    coordinates: ").append(this.toIndentedString(this.coordinates)).append("\n");
        sb.append("    crs: ").append(this.toIndentedString(this.crs)).append("\n");
        sb.append("    tileMatrix: ").append(this.toIndentedString(this.tileMatrix)).append("\n");
        sb.append("    scaleDenominator: ").append(this.toIndentedString(this.scaleDenominator)).append("\n");
        sb.append("    cellSize: ").append(this.toIndentedString(this.cellSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

