/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.cli.database;

import java.nio.file.Path;
import java.util.concurrent.Callable;
import org.apache.baremaps.cli.Options;
import org.apache.baremaps.workflow.WorkflowContext;
import picocli.CommandLine;

@CommandLine.Command(name="import-osm", description={"Import OpenStreetMap data in Postgres."})
public class ImportOpenStreetMap
implements Callable<Integer> {
    @CommandLine.Mixin
    private Options options;
    @CommandLine.Option(names={"--file"}, paramLabel="FILE", description={"The PBF file to import in the database."}, required=true)
    private Path file;
    @CommandLine.Option(names={"--database"}, paramLabel="DATABASE", description={"The JDBC url of Postgres."}, required=true)
    private String database;
    @CommandLine.Option(names={"--srid"}, paramLabel="SRID", description={"The projection used by the database."})
    private int srid = 3857;

    @Override
    public Integer call() throws Exception {
        new org.apache.baremaps.workflow.tasks.ImportOpenStreetMap(this.file.toAbsolutePath(), (Object)this.database, Integer.valueOf(this.srid)).execute(new WorkflowContext());
        return 0;
    }
}

