/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Singleton;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasBusinessMetadataDef;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasEnumDef;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.type.AtlasArrayType;
import org.apache.atlas.type.AtlasBuiltInTypes;
import org.apache.atlas.type.AtlasBusinessMetadataType;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasEnumType;
import org.apache.atlas.type.AtlasMapType;
import org.apache.atlas.type.AtlasRelationshipType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.TypeCache;
import org.apache.atlas.type.TypeDefCache;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Singleton
@Component
public class AtlasTypeRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasTypeRegistry.class);
    private static final int DEFAULT_LOCK_MAX_WAIT_TIME_IN_SECONDS = 15;
    protected RegistryData registryData = new RegistryData();
    private final TypeRegistryUpdateSynchronizer updateSynchronizer;
    private final Set<String> missingRelationshipDefs;
    private final Map<String, String> commonIndexFieldNameCache;

    public AtlasTypeRegistry() {
        this.updateSynchronizer = new TypeRegistryUpdateSynchronizer(this);
        this.missingRelationshipDefs = new HashSet<String>();
        this.commonIndexFieldNameCache = new LinkedHashMap<String, String>();
        this.resolveReferencesForRootTypes();
        this.resolveIndexFieldNamesForRootTypes();
    }

    protected AtlasTypeRegistry(AtlasTypeRegistry other) {
        this.updateSynchronizer = other.updateSynchronizer;
        this.missingRelationshipDefs = other.missingRelationshipDefs;
        this.commonIndexFieldNameCache = other.commonIndexFieldNameCache;
        this.resolveReferencesForRootTypes();
        this.resolveIndexFieldNamesForRootTypes();
    }

    public Collection<String> getAllTypeNames() {
        return this.registryData.allTypes.getAllTypeNames();
    }

    public Collection<AtlasType> getAllTypes() {
        return this.registryData.allTypes.getAllTypes();
    }

    public Set<String> getAllServiceTypes() {
        return this.registryData.allTypes.getAllServiceTypes();
    }

    public boolean isRegisteredType(String typeName) {
        return this.registryData.allTypes.isKnownType(typeName);
    }

    public AtlasType getType(String typeName) throws AtlasBaseException {
        AtlasType ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasTypeRegistry.getType({})", (Object)typeName);
        }
        if ((ret = this.registryData.allTypes.getTypeByName(typeName)) == null) {
            if (typeName.startsWith("array<") && typeName.endsWith(">")) {
                int startIdx = "array<".length();
                int endIdx = typeName.length() - ">".length();
                String elementTypeName = typeName.substring(startIdx, endIdx);
                ret = new AtlasArrayType(elementTypeName, this);
            } else if (typeName.startsWith("map<") && typeName.endsWith(">")) {
                int endIdx;
                int startIdx = "map<".length();
                String[] keyValueTypes = typeName.substring(startIdx, endIdx = typeName.length() - ">".length()).split(",", 2);
                String keyTypeName = keyValueTypes.length > 0 ? keyValueTypes[0] : null;
                String valueTypeName = keyValueTypes.length > 1 ? keyValueTypes[1] : null;
                ret = new AtlasMapType(keyTypeName, valueTypeName, this);
            } else {
                throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, typeName);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasTypeRegistry.getType({}): {}", (Object)typeName, (Object)ret);
        }
        return ret;
    }

    public AtlasType getTypeByGuid(String guid) throws AtlasBaseException {
        AtlasType ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasTypeRegistry.getTypeByGuid({})", (Object)guid);
        }
        if ((ret = this.registryData.allTypes.getTypeByGuid(guid)) == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_GUID_NOT_FOUND, guid);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasTypeRegistry.getTypeByGuid({}): {}", (Object)guid, (Object)ret);
        }
        return ret;
    }

    public AtlasBaseTypeDef getTypeDefByName(String name) {
        return this.registryData.getTypeDefByName(name);
    }

    public AtlasBaseTypeDef getTypeDefByGuid(String guid) {
        return this.registryData.getTypeDefByGuid(guid);
    }

    public Collection<AtlasEnumDef> getAllEnumDefs() {
        return this.registryData.enumDefs.getAll();
    }

    public AtlasEnumDef getEnumDefByGuid(String guid) {
        return this.registryData.enumDefs.getTypeDefByGuid(guid);
    }

    public AtlasEnumDef getEnumDefByName(String name) {
        return this.registryData.enumDefs.getTypeDefByName(name);
    }

    public Collection<String> getAllEnumDefNames() {
        return this.registryData.enumDefs.getAllNames();
    }

    public Collection<AtlasEnumType> getAllEnumTypes() {
        return this.registryData.enumDefs.getAllTypes();
    }

    public AtlasEnumType getEnumTypeByName(String name) {
        return this.registryData.enumDefs.getTypeByName(name);
    }

    public Collection<AtlasStructDef> getAllStructDefs() {
        return this.registryData.structDefs.getAll();
    }

    public AtlasStructDef getStructDefByGuid(String guid) {
        return this.registryData.structDefs.getTypeDefByGuid(guid);
    }

    public AtlasStructDef getStructDefByName(String name) {
        return this.registryData.structDefs.getTypeDefByName(name);
    }

    public Collection<String> getAllStructDefNames() {
        return this.registryData.structDefs.getAllNames();
    }

    public Collection<AtlasStructType> getAllStructTypes() {
        return this.registryData.structDefs.getAllTypes();
    }

    public AtlasStructType getStructTypeByName(String name) {
        return this.registryData.structDefs.getTypeByName(name);
    }

    public Collection<AtlasClassificationDef> getAllClassificationDefs() {
        return this.registryData.classificationDefs.getAll();
    }

    public AtlasClassificationDef getClassificationDefByGuid(String guid) {
        return this.registryData.classificationDefs.getTypeDefByGuid(guid);
    }

    public AtlasClassificationDef getClassificationDefByName(String name) {
        return this.registryData.classificationDefs.getTypeDefByName(name);
    }

    public Collection<String> getAllClassificationDefNames() {
        return this.registryData.classificationDefs.getAllNames();
    }

    public Collection<AtlasClassificationType> getAllClassificationTypes() {
        return this.registryData.classificationDefs.getAllTypes();
    }

    public AtlasClassificationType getClassificationTypeByName(String name) {
        return this.registryData.classificationDefs.getTypeByName(name);
    }

    public Collection<AtlasBusinessMetadataType> getAllBusinessMetadataTypes() {
        return this.registryData.businessMetadataDefs.getAllTypes();
    }

    public Collection<AtlasBusinessMetadataDef> getAllBusinessMetadataDefs() {
        return this.registryData.businessMetadataDefs.getAll();
    }

    public AtlasBusinessMetadataType getBusinessMetadataTypeByName(String name) {
        return this.registryData.businessMetadataDefs.getTypeByName(name);
    }

    public Collection<AtlasRelationshipDef> getAllRelationshipDefs() {
        return this.registryData.relationshipDefs.getAll();
    }

    public Collection<AtlasEntityDef> getAllEntityDefs() {
        return this.registryData.entityDefs.getAll();
    }

    public AtlasEntityDef getEntityDefByGuid(String guid) {
        return this.registryData.entityDefs.getTypeDefByGuid(guid);
    }

    public AtlasEntityDef getEntityDefByName(String name) {
        return this.registryData.entityDefs.getTypeDefByName(name);
    }

    public Collection<String> getAllEntityDefNames() {
        return this.registryData.entityDefs.getAllNames();
    }

    public Collection<AtlasEntityType> getAllEntityTypes() {
        return this.registryData.entityDefs.getAllTypes();
    }

    public AtlasEntityType getEntityTypeByName(String name) {
        return this.registryData.entityDefs.getTypeByName(name);
    }

    public Collection<AtlasRelationshipType> getAllRelationshipTypes() {
        return this.registryData.relationshipDefs.getAllTypes();
    }

    public AtlasRelationshipDef getRelationshipDefByGuid(String guid) {
        return this.registryData.relationshipDefs.getTypeDefByGuid(guid);
    }

    public AtlasRelationshipDef getRelationshipDefByName(String name) {
        return this.registryData.relationshipDefs.getTypeDefByName(name);
    }

    public AtlasBusinessMetadataDef getBusinessMetadataDefByGuid(String guid) {
        return this.registryData.businessMetadataDefs.getTypeDefByGuid(guid);
    }

    public AtlasBusinessMetadataDef getBusinessMetadataDefByName(String name) {
        return this.registryData.businessMetadataDefs.getTypeDefByName(name);
    }

    public AtlasRelationshipType getRelationshipTypeByName(String name) {
        return this.registryData.relationshipDefs.getTypeByName(name);
    }

    public AtlasTransientTypeRegistry lockTypeRegistryForUpdate() throws AtlasBaseException {
        return this.lockTypeRegistryForUpdate(15);
    }

    public AtlasTransientTypeRegistry lockTypeRegistryForUpdate(int lockMaxWaitTimeInSeconds) throws AtlasBaseException {
        return this.updateSynchronizer.lockTypeRegistryForUpdate(lockMaxWaitTimeInSeconds);
    }

    public void releaseTypeRegistryForUpdate(AtlasTransientTypeRegistry transientTypeRegistry, boolean commitUpdates) {
        this.updateSynchronizer.releaseTypeRegistryForUpdate(transientTypeRegistry, commitUpdates);
    }

    public void reportMissingRelationshipDef(String entityType1, String entityType2, String attributeName) {
        String key = entityType1 + "->" + entityType2 + ":" + attributeName;
        if (!this.missingRelationshipDefs.contains(key)) {
            LOG.warn("No RelationshipDef defined between {} and {} on attribute: {}.{}", new Object[]{entityType1, entityType2, entityType1, attributeName});
            this.missingRelationshipDefs.add(key);
        }
    }

    public void addIndexFieldName(String propertyName, String indexFieldName) {
        this.commonIndexFieldNameCache.put(propertyName, indexFieldName);
    }

    private void resolveReferencesForRootTypes() {
        try {
            AtlasEntityType.ENTITY_ROOT.resolveReferences(this);
            AtlasClassificationType.CLASSIFICATION_ROOT.resolveReferences(this);
        }
        catch (AtlasBaseException e) {
            LOG.error("Failed to initialize root types", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void resolveIndexFieldNamesForRootTypes() {
        for (AtlasStructType structType : Arrays.asList(AtlasEntityType.ENTITY_ROOT, AtlasClassificationType.CLASSIFICATION_ROOT)) {
            for (AtlasStructType.AtlasAttribute attribute : structType.getAllAttributes().values()) {
                String indexFieldName = this.getIndexFieldName(attribute.getVertexPropertyName());
                if (StringUtils.isNotEmpty((String)indexFieldName)) {
                    attribute.setIndexFieldName(indexFieldName);
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Attribute {} with index name {} is added", (Object)attribute.getVertexPropertyName(), (Object)attribute.getIndexFieldName());
            }
        }
    }

    public String getIndexFieldName(String propertyName) {
        return this.commonIndexFieldNameCache.get(propertyName);
    }

    static class TypeRegistryUpdateSynchronizer {
        private final AtlasTypeRegistry typeRegistry;
        private final ReentrantLock typeRegistryUpdateLock;
        private AtlasTransientTypeRegistry typeRegistryUnderUpdate = null;
        private String lockedByThread = null;

        TypeRegistryUpdateSynchronizer(AtlasTypeRegistry typeRegistry) {
            this.typeRegistry = typeRegistry;
            this.typeRegistryUpdateLock = new ReentrantLock();
        }

        AtlasTransientTypeRegistry lockTypeRegistryForUpdate(int lockMaxWaitTimeInSeconds) throws AtlasBaseException {
            LOG.debug("==> lockTypeRegistryForUpdate()");
            boolean alreadyLockedByCurrentThread = this.typeRegistryUpdateLock.isHeldByCurrentThread();
            if (!alreadyLockedByCurrentThread) {
                if (this.lockedByThread != null) {
                    LOG.info("lockTypeRegistryForUpdate(): waiting for lock to be released by thread {}", (Object)this.lockedByThread);
                }
            } else {
                LOG.warn("lockTypeRegistryForUpdate(): already locked. currentLockCount={}", (Object)this.typeRegistryUpdateLock.getHoldCount());
            }
            try {
                boolean isLocked = this.typeRegistryUpdateLock.tryLock(lockMaxWaitTimeInSeconds, TimeUnit.SECONDS);
                if (!isLocked) {
                    throw new AtlasBaseException(AtlasErrorCode.FAILED_TO_OBTAIN_TYPE_UPDATE_LOCK, new String[0]);
                }
            }
            catch (InterruptedException excp) {
                throw new AtlasBaseException(AtlasErrorCode.FAILED_TO_OBTAIN_TYPE_UPDATE_LOCK, (Throwable)excp, new String[0]);
            }
            if (!alreadyLockedByCurrentThread) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("lockTypeRegistryForUpdate(): wait over..got the lock");
                }
                this.typeRegistryUnderUpdate = new AtlasTransientTypeRegistry(this.typeRegistry);
                this.lockedByThread = Thread.currentThread().getName();
            }
            LOG.debug("<== lockTypeRegistryForUpdate()");
            return this.typeRegistryUnderUpdate;
        }

        void releaseTypeRegistryForUpdate(AtlasTransientTypeRegistry ttr, boolean commitUpdates) {
            LOG.debug("==> releaseTypeRegistryForUpdate()");
            if (this.typeRegistryUpdateLock.isHeldByCurrentThread()) {
                try {
                    if (this.typeRegistryUnderUpdate != ttr) {
                        LOG.error("releaseTypeRegistryForUpdate(): incorrect typeRegistry returned for release: found=" + ttr + "; expected=" + this.typeRegistryUnderUpdate, new Exception().fillInStackTrace());
                    } else if (this.typeRegistryUpdateLock.getHoldCount() == 1 && ttr != null && commitUpdates) {
                        this.copyIndexNameFromCurrent(ttr.getAllEntityTypes());
                        this.copyIndexNameFromCurrent(ttr.getAllBusinessMetadataTypes());
                        this.typeRegistry.registryData = ttr.registryData;
                    }
                    if (this.typeRegistryUpdateLock.getHoldCount() == 1) {
                        this.lockedByThread = null;
                        this.typeRegistryUnderUpdate = null;
                    }
                    LOG.warn("releaseTypeRegistryForUpdate(): pendingReleaseCount={}", (Object)(this.typeRegistryUpdateLock.getHoldCount() - 1));
                }
                finally {
                    this.typeRegistryUpdateLock.unlock();
                }
            } else {
                LOG.error("releaseTypeRegistryForUpdate(): current thread does not hold the lock", new Exception().fillInStackTrace());
            }
            LOG.debug("<== releaseTypeRegistryForUpdate()");
        }

        private void copyIndexNameFromCurrent(Collection<? extends AtlasStructType> ttrTypes) {
            for (AtlasStructType atlasStructType : ttrTypes) {
                AtlasStructType currType = atlasStructType instanceof AtlasEntityType ? this.typeRegistry.getEntityTypeByName(atlasStructType.getTypeName()) : (atlasStructType instanceof AtlasBusinessMetadataType ? this.typeRegistry.getBusinessMetadataTypeByName(atlasStructType.getTypeName()) : null);
                if (currType == null) continue;
                for (AtlasStructType.AtlasAttribute ttrAttribute : atlasStructType.getAllAttributes().values()) {
                    AtlasStructType.AtlasAttribute currAttribute;
                    if (!StringUtils.isEmpty((String)ttrAttribute.getIndexFieldName()) || (currAttribute = currType.getAttribute(ttrAttribute.getName())) == null) continue;
                    ttrAttribute.setIndexFieldName(currAttribute.getIndexFieldName());
                }
            }
        }
    }

    public static class AtlasTransientTypeRegistry
    extends AtlasTypeRegistry {
        private List<AtlasBaseTypeDef> addedTypes = new ArrayList<AtlasBaseTypeDef>();
        private List<AtlasBaseTypeDef> updatedTypes = new ArrayList<AtlasBaseTypeDef>();
        private List<AtlasBaseTypeDef> deletedTypes = new ArrayList<AtlasBaseTypeDef>();

        private AtlasTransientTypeRegistry(AtlasTypeRegistry parent) throws AtlasBaseException {
            super(parent);
            this.addTypesWithNoRefResolve(parent.getAllEnumDefs());
            this.addTypesWithNoRefResolve(parent.getAllStructDefs());
            this.addTypesWithNoRefResolve(parent.getAllClassificationDefs());
            this.addTypesWithNoRefResolve(parent.getAllEntityDefs());
            this.addTypesWithNoRefResolve(parent.getAllRelationshipDefs());
            this.addTypesWithNoRefResolve(parent.getAllBusinessMetadataDefs());
            this.addedTypes.clear();
            this.updatedTypes.clear();
            this.deletedTypes.clear();
        }

        private void resolveReferences() throws AtlasBaseException {
            for (AtlasType type : this.registryData.allTypes.getAllTypes()) {
                type.resolveReferences(this);
            }
            for (AtlasType type : this.registryData.allTypes.getAllTypes()) {
                type.resolveReferencesPhase2(this);
            }
            for (AtlasType type : this.registryData.allTypes.getAllTypes()) {
                type.resolveReferencesPhase3(this);
            }
        }

        public void clear() {
            this.registryData.clear();
        }

        public void addType(AtlasBaseTypeDef typeDef) throws AtlasBaseException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> AtlasTypeRegistry.addType({})", (Object)typeDef);
            }
            if (typeDef != null) {
                this.addTypeWithNoRefResolve(typeDef);
            }
            this.resolveReferences();
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== AtlasTypeRegistry.addType({})", (Object)typeDef);
            }
        }

        public void updateGuid(String typeName, String guid) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> AtlasTypeRegistry.updateGuid({}, {})", (Object)typeName, (Object)guid);
            }
            this.registryData.updateGuid(typeName, guid);
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== AtlasTypeRegistry.updateGuid({}, {})", (Object)typeName, (Object)guid);
            }
        }

        public void addTypes(Collection<? extends AtlasBaseTypeDef> typeDefs) throws AtlasBaseException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> AtlasTypeRegistry.addTypes(length={})", (Object)(typeDefs == null ? 0 : typeDefs.size()));
            }
            if (CollectionUtils.isNotEmpty(typeDefs)) {
                this.addTypesWithNoRefResolve(typeDefs);
            }
            this.resolveReferences();
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== AtlasTypeRegistry.addTypes(length={})", (Object)(typeDefs == null ? 0 : typeDefs.size()));
            }
        }

        public void addTypes(AtlasTypesDef typesDef) throws AtlasBaseException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> AtlasTypeRegistry.addTypes({})", (Object)typesDef);
            }
            if (typesDef != null) {
                this.addTypesWithNoRefResolve(typesDef.getEnumDefs());
                this.addTypesWithNoRefResolve(typesDef.getStructDefs());
                this.addTypesWithNoRefResolve(typesDef.getClassificationDefs());
                this.addTypesWithNoRefResolve(typesDef.getEntityDefs());
                this.addTypesWithNoRefResolve(typesDef.getRelationshipDefs());
                this.addTypesWithNoRefResolve(typesDef.getBusinessMetadataDefs());
            }
            this.resolveReferences();
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== AtlasTypeRegistry.addTypes({})", (Object)typesDef);
            }
        }

        public void updateType(AtlasBaseTypeDef typeDef) throws AtlasBaseException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> AtlasTypeRegistry.updateType({})", (Object)typeDef);
            }
            if (typeDef != null) {
                this.updateTypeWithNoRefResolve(typeDef);
            }
            this.resolveReferences();
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== AtlasTypeRegistry.updateType({})", (Object)typeDef);
            }
        }

        public void updateTypeByGuid(String guid, AtlasBaseTypeDef typeDef) throws AtlasBaseException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> AtlasTypeRegistry.updateTypeByGuid({})", (Object)guid);
            }
            if (guid != null && typeDef != null) {
                this.updateTypeByGuidWithNoRefResolve(guid, typeDef);
            }
            this.resolveReferences();
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== AtlasTypeRegistry.updateTypeByGuid({})", (Object)guid);
            }
        }

        public void updateTypeByName(String name, AtlasBaseTypeDef typeDef) throws AtlasBaseException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> AtlasTypeRegistry.updateEnumDefByName({})", (Object)name);
            }
            if (name != null && typeDef != null) {
                this.updateTypeByNameWithNoRefResolve(name, typeDef);
            }
            this.resolveReferences();
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== AtlasTypeRegistry.updateEnumDefByName({})", (Object)name);
            }
        }

        public void updateTypes(Collection<? extends AtlasBaseTypeDef> typeDefs) throws AtlasBaseException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> AtlasTypeRegistry.updateTypes(length={})", (Object)(typeDefs == null ? 0 : typeDefs.size()));
            }
            if (CollectionUtils.isNotEmpty(typeDefs)) {
                this.updateTypesWithNoRefResolve(typeDefs);
            }
            this.resolveReferences();
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== AtlasTypeRegistry.updateTypes(length={})", (Object)(typeDefs == null ? 0 : typeDefs.size()));
            }
        }

        public void updateTypes(AtlasTypesDef typesDef) throws AtlasBaseException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> AtlasTypeRegistry.updateTypes({})", (Object)typesDef);
            }
            if (typesDef != null) {
                this.updateTypesWithNoRefResolve(typesDef);
            }
            this.resolveReferences();
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== AtlasTypeRegistry.updateTypes({})", (Object)typesDef);
            }
        }

        public void updateTypesWithNoRefResolve(AtlasTypesDef typesDef) throws AtlasBaseException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> AtlasTypeRegistry.updateTypesWithNoRefResolve({})", (Object)typesDef);
            }
            if (typesDef != null) {
                this.updateTypesWithNoRefResolve(typesDef.getEnumDefs());
                this.updateTypesWithNoRefResolve(typesDef.getStructDefs());
                this.updateTypesWithNoRefResolve(typesDef.getClassificationDefs());
                this.updateTypesWithNoRefResolve(typesDef.getEntityDefs());
                this.updateTypesWithNoRefResolve(typesDef.getRelationshipDefs());
                this.updateTypesWithNoRefResolve(typesDef.getBusinessMetadataDefs());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== AtlasTypeRegistry.updateTypesWithNoRefResolve({})", (Object)typesDef);
            }
        }

        public void removeTypesDef(AtlasTypesDef typesDef) throws AtlasBaseException {
            if (null != typesDef && !typesDef.isEmpty()) {
                this.removeTypesWithNoRefResolve(typesDef.getEnumDefs());
                this.removeTypesWithNoRefResolve(typesDef.getStructDefs());
                this.removeTypesWithNoRefResolve(typesDef.getClassificationDefs());
                this.removeTypesWithNoRefResolve(typesDef.getEntityDefs());
                this.removeTypesWithNoRefResolve(typesDef.getRelationshipDefs());
                this.removeTypesWithNoRefResolve(typesDef.getBusinessMetadataDefs());
            }
            this.resolveReferences();
        }

        private void removeTypesWithNoRefResolve(Collection<? extends AtlasBaseTypeDef> typeDefs) {
            if (CollectionUtils.isNotEmpty(typeDefs)) {
                for (AtlasBaseTypeDef atlasBaseTypeDef : typeDefs) {
                    if (StringUtils.isNotEmpty((String)atlasBaseTypeDef.getGuid())) {
                        this.removeTypeByGuidWithNoRefResolve(atlasBaseTypeDef);
                        continue;
                    }
                    this.removeTypeByNameWithNoRefResolve(atlasBaseTypeDef);
                }
            }
        }

        private void removeTypeByNameWithNoRefResolve(AtlasBaseTypeDef typeDef) {
            switch (typeDef.getCategory()) {
                case ENUM: {
                    this.registryData.enumDefs.removeTypeDefByName(typeDef.getName());
                    break;
                }
                case STRUCT: {
                    this.registryData.structDefs.removeTypeDefByName(typeDef.getName());
                    break;
                }
                case CLASSIFICATION: {
                    this.registryData.classificationDefs.removeTypeDefByName(typeDef.getName());
                    break;
                }
                case ENTITY: {
                    this.registryData.entityDefs.removeTypeDefByName(typeDef.getName());
                    break;
                }
                case RELATIONSHIP: {
                    this.registryData.relationshipDefs.removeTypeDefByName(typeDef.getName());
                    break;
                }
                case BUSINESS_METADATA: {
                    this.registryData.businessMetadataDefs.removeTypeDefByName(typeDef.getName());
                }
            }
            this.deletedTypes.add(typeDef);
        }

        private void removeTypeByGuidWithNoRefResolve(AtlasBaseTypeDef typeDef) {
            switch (typeDef.getCategory()) {
                case ENUM: {
                    this.registryData.enumDefs.removeTypeDefByGuid(typeDef.getGuid());
                    break;
                }
                case STRUCT: {
                    this.registryData.structDefs.removeTypeDefByGuid(typeDef.getGuid());
                    break;
                }
                case CLASSIFICATION: {
                    this.registryData.classificationDefs.removeTypeDefByGuid(typeDef.getGuid());
                    break;
                }
                case ENTITY: {
                    this.registryData.entityDefs.removeTypeDefByGuid(typeDef.getGuid());
                    break;
                }
                case RELATIONSHIP: {
                    this.registryData.relationshipDefs.removeTypeDefByGuid(typeDef.getGuid());
                    break;
                }
                case BUSINESS_METADATA: {
                    this.registryData.businessMetadataDefs.removeTypeDefByGuid(typeDef.getGuid());
                }
            }
            this.deletedTypes.add(typeDef);
        }

        public void removeTypeByGuid(String guid) throws AtlasBaseException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> AtlasTypeRegistry.removeTypeByGuid({})", (Object)guid);
            }
            AtlasBaseTypeDef typeDef = this.getTypeDefByGuid(guid);
            if (guid != null) {
                this.registryData.removeByGuid(guid);
            }
            this.resolveReferences();
            if (typeDef != null) {
                this.deletedTypes.add(typeDef);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== AtlasTypeRegistry.removeTypeByGuid({})", (Object)guid);
            }
        }

        public void removeTypeByName(String name) throws AtlasBaseException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> AtlasTypeRegistry.removeTypeByName({})", (Object)name);
            }
            AtlasBaseTypeDef typeDef = this.getTypeDefByName(name);
            if (name != null) {
                this.registryData.removeByName(name);
            }
            this.resolveReferences();
            if (typeDef != null) {
                this.deletedTypes.add(typeDef);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== AtlasTypeRegistry.removeEnumDefByName({})", (Object)name);
            }
        }

        public List<AtlasBaseTypeDef> getAddedTypes() {
            return this.addedTypes;
        }

        public List<AtlasBaseTypeDef> getUpdatedTypes() {
            return this.updatedTypes;
        }

        public List<AtlasBaseTypeDef> getDeleteedTypes() {
            return this.deletedTypes;
        }

        private void addTypeWithNoRefResolve(AtlasBaseTypeDef typeDef) throws AtlasBaseException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> AtlasTypeRegistry.addTypeWithNoRefResolve({})", (Object)typeDef);
            }
            if (typeDef != null) {
                if (typeDef.getClass().equals(AtlasEnumDef.class)) {
                    AtlasEnumDef enumDef = (AtlasEnumDef)typeDef;
                    this.registryData.enumDefs.addType(enumDef, new AtlasEnumType(enumDef));
                } else if (typeDef.getClass().equals(AtlasStructDef.class)) {
                    AtlasStructDef structDef = (AtlasStructDef)typeDef;
                    this.registryData.structDefs.addType(structDef, new AtlasStructType(structDef));
                } else if (typeDef.getClass().equals(AtlasClassificationDef.class)) {
                    AtlasClassificationDef classificationDef = (AtlasClassificationDef)typeDef;
                    this.registryData.classificationDefs.addType(classificationDef, new AtlasClassificationType(classificationDef));
                } else if (typeDef.getClass().equals(AtlasEntityDef.class)) {
                    AtlasEntityDef entityDef = (AtlasEntityDef)typeDef;
                    this.registryData.entityDefs.addType(entityDef, new AtlasEntityType(entityDef));
                } else if (typeDef.getClass().equals(AtlasRelationshipDef.class)) {
                    AtlasRelationshipDef relationshipDef = (AtlasRelationshipDef)typeDef;
                    this.registryData.relationshipDefs.addType(relationshipDef, new AtlasRelationshipType(relationshipDef));
                } else if (typeDef.getClass().equals(AtlasBusinessMetadataDef.class)) {
                    AtlasBusinessMetadataDef businessMetadataDef = (AtlasBusinessMetadataDef)typeDef;
                    this.registryData.businessMetadataDefs.addType(businessMetadataDef, new AtlasBusinessMetadataType(businessMetadataDef));
                }
                this.addedTypes.add(typeDef);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== AtlasTypeRegistry.addTypeWithNoRefResolve({})", (Object)typeDef);
            }
        }

        private void addTypesWithNoRefResolve(Collection<? extends AtlasBaseTypeDef> typeDefs) throws AtlasBaseException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> AtlasTypeRegistry.addTypesWithNoRefResolve(length={})", (Object)(typeDefs == null ? 0 : typeDefs.size()));
            }
            if (CollectionUtils.isNotEmpty(typeDefs)) {
                for (AtlasBaseTypeDef atlasBaseTypeDef : typeDefs) {
                    this.addTypeWithNoRefResolve(atlasBaseTypeDef);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== AtlasTypeRegistry.addTypesWithNoRefResolve(length={})", (Object)(typeDefs == null ? 0 : typeDefs.size()));
            }
        }

        private void updateTypeWithNoRefResolve(AtlasBaseTypeDef typeDef) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> AtlasTypeRegistry.updateType({})", (Object)typeDef);
            }
            if (typeDef != null) {
                if (StringUtils.isNotBlank((String)typeDef.getGuid())) {
                    this.updateTypeByGuidWithNoRefResolve(typeDef.getGuid(), typeDef);
                } else if (StringUtils.isNotBlank((String)typeDef.getName())) {
                    this.updateTypeByNameWithNoRefResolve(typeDef.getName(), typeDef);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== AtlasTypeRegistry.updateType({})", (Object)typeDef);
            }
        }

        private void updateTypeByGuidWithNoRefResolve(String guid, AtlasBaseTypeDef typeDef) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> AtlasTypeRegistry.updateTypeByGuidWithNoRefResolve({})", (Object)guid);
            }
            if (guid != null && typeDef != null) {
                if (typeDef.getClass().equals(AtlasEnumDef.class)) {
                    AtlasEnumDef enumDef = (AtlasEnumDef)typeDef;
                    this.registryData.enumDefs.removeTypeDefByGuid(guid);
                    this.registryData.enumDefs.addType(enumDef, new AtlasEnumType(enumDef));
                } else if (typeDef.getClass().equals(AtlasStructDef.class)) {
                    AtlasStructDef structDef = (AtlasStructDef)typeDef;
                    this.registryData.structDefs.removeTypeDefByGuid(guid);
                    this.registryData.structDefs.addType(structDef, new AtlasStructType(structDef));
                } else if (typeDef.getClass().equals(AtlasClassificationDef.class)) {
                    AtlasClassificationDef classificationDef = (AtlasClassificationDef)typeDef;
                    this.registryData.classificationDefs.removeTypeDefByGuid(guid);
                    this.registryData.classificationDefs.addType(classificationDef, new AtlasClassificationType(classificationDef));
                } else if (typeDef.getClass().equals(AtlasEntityDef.class)) {
                    AtlasEntityDef entityDef = (AtlasEntityDef)typeDef;
                    this.registryData.entityDefs.removeTypeDefByGuid(guid);
                    this.registryData.entityDefs.addType(entityDef, new AtlasEntityType(entityDef));
                } else if (typeDef.getClass().equals(AtlasRelationshipDef.class)) {
                    AtlasRelationshipDef relationshipDef = (AtlasRelationshipDef)typeDef;
                    this.registryData.relationshipDefs.removeTypeDefByGuid(guid);
                    this.registryData.relationshipDefs.addType(relationshipDef, new AtlasRelationshipType(relationshipDef));
                } else if (typeDef.getClass().equals(AtlasBusinessMetadataDef.class)) {
                    AtlasBusinessMetadataDef businessMetadataDef = (AtlasBusinessMetadataDef)typeDef;
                    this.registryData.businessMetadataDefs.removeTypeDefByGuid(guid);
                    this.registryData.businessMetadataDefs.addType(businessMetadataDef, new AtlasBusinessMetadataType(businessMetadataDef));
                }
                this.updatedTypes.add(typeDef);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== AtlasTypeRegistry.updateTypeByGuidWithNoRefResolve({})", (Object)guid);
            }
        }

        private void updateTypeByNameWithNoRefResolve(String name, AtlasBaseTypeDef typeDef) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> AtlasTypeRegistry.updateTypeByNameWithNoRefResolve({})", (Object)name);
            }
            if (name != null && typeDef != null) {
                if (typeDef.getClass().equals(AtlasEnumDef.class)) {
                    AtlasEnumDef enumDef = (AtlasEnumDef)typeDef;
                    this.registryData.enumDefs.removeTypeDefByName(name);
                    this.registryData.enumDefs.addType(enumDef, new AtlasEnumType(enumDef));
                } else if (typeDef.getClass().equals(AtlasStructDef.class)) {
                    AtlasStructDef structDef = (AtlasStructDef)typeDef;
                    this.registryData.structDefs.removeTypeDefByName(name);
                    this.registryData.structDefs.addType(structDef, new AtlasStructType(structDef));
                } else if (typeDef.getClass().equals(AtlasClassificationDef.class)) {
                    AtlasClassificationDef classificationDef = (AtlasClassificationDef)typeDef;
                    this.registryData.classificationDefs.removeTypeDefByName(name);
                    this.registryData.classificationDefs.addType(classificationDef, new AtlasClassificationType(classificationDef));
                } else if (typeDef.getClass().equals(AtlasEntityDef.class)) {
                    AtlasEntityDef entityDef = (AtlasEntityDef)typeDef;
                    this.registryData.entityDefs.removeTypeDefByName(name);
                    this.registryData.entityDefs.addType(entityDef, new AtlasEntityType(entityDef));
                } else if (typeDef.getClass().equals(AtlasRelationshipDef.class)) {
                    AtlasRelationshipDef relationshipDef = (AtlasRelationshipDef)typeDef;
                    this.registryData.relationshipDefs.removeTypeDefByName(name);
                    this.registryData.relationshipDefs.addType(relationshipDef, new AtlasRelationshipType(relationshipDef));
                } else if (typeDef.getClass().equals(AtlasBusinessMetadataDef.class)) {
                    AtlasBusinessMetadataDef businessMetadataDef = (AtlasBusinessMetadataDef)typeDef;
                    this.registryData.businessMetadataDefs.removeTypeDefByName(name);
                    this.registryData.businessMetadataDefs.addType(businessMetadataDef, new AtlasBusinessMetadataType(businessMetadataDef));
                }
                this.updatedTypes.add(typeDef);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== AtlasTypeRegistry.updateTypeByNameWithNoRefResolve({})", (Object)name);
            }
        }

        private void updateTypesWithNoRefResolve(Collection<? extends AtlasBaseTypeDef> typeDefs) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> AtlasTypeRegistry.updateTypesWithNoRefResolve(length={})", (Object)(typeDefs == null ? 0 : typeDefs.size()));
            }
            if (CollectionUtils.isNotEmpty(typeDefs)) {
                for (AtlasBaseTypeDef atlasBaseTypeDef : typeDefs) {
                    this.updateTypeWithNoRefResolve(atlasBaseTypeDef);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== AtlasTypeRegistry.updateTypesWithNoRefResolve(length={})", (Object)(typeDefs == null ? 0 : typeDefs.size()));
            }
        }
    }

    static class RegistryData {
        final TypeCache allTypes = new TypeCache();
        final TypeDefCache<AtlasEnumDef, AtlasEnumType> enumDefs = new TypeDefCache(this.allTypes);
        final TypeDefCache<AtlasStructDef, AtlasStructType> structDefs = new TypeDefCache(this.allTypes);
        final TypeDefCache<AtlasClassificationDef, AtlasClassificationType> classificationDefs = new TypeDefCache(this.allTypes);
        final TypeDefCache<AtlasEntityDef, AtlasEntityType> entityDefs = new TypeDefCache(this.allTypes);
        final TypeDefCache<AtlasRelationshipDef, AtlasRelationshipType> relationshipDefs = new TypeDefCache(this.allTypes);
        final TypeDefCache<AtlasBusinessMetadataDef, AtlasBusinessMetadataType> businessMetadataDefs = new TypeDefCache(this.allTypes);
        final TypeDefCache<? extends AtlasBaseTypeDef, ? extends AtlasType>[] allDefCaches = new TypeDefCache[]{this.enumDefs, this.structDefs, this.classificationDefs, this.entityDefs, this.relationshipDefs, this.businessMetadataDefs};

        RegistryData() {
            this.init();
        }

        void init() {
            this.allTypes.addType(new AtlasBuiltInTypes.AtlasBooleanType());
            this.allTypes.addType(new AtlasBuiltInTypes.AtlasByteType());
            this.allTypes.addType(new AtlasBuiltInTypes.AtlasShortType());
            this.allTypes.addType(new AtlasBuiltInTypes.AtlasIntType());
            this.allTypes.addType(new AtlasBuiltInTypes.AtlasLongType());
            this.allTypes.addType(new AtlasBuiltInTypes.AtlasFloatType());
            this.allTypes.addType(new AtlasBuiltInTypes.AtlasDoubleType());
            this.allTypes.addType(new AtlasBuiltInTypes.AtlasBigIntegerType());
            this.allTypes.addType(new AtlasBuiltInTypes.AtlasBigDecimalType());
            this.allTypes.addType(new AtlasBuiltInTypes.AtlasDateType());
            this.allTypes.addType(new AtlasBuiltInTypes.AtlasStringType());
            this.allTypes.addType(new AtlasBuiltInTypes.AtlasObjectIdType());
        }

        AtlasBaseTypeDef getTypeDefByName(String name) {
            AtlasBaseTypeDef ret = null;
            if (name != null) {
                TypeDefCache<? extends AtlasBaseTypeDef, ? extends AtlasType> typeDefCache;
                TypeDefCache<? extends AtlasBaseTypeDef, ? extends AtlasType>[] typeDefCacheArray = this.allDefCaches;
                int n = typeDefCacheArray.length;
                for (int i = 0; i < n && (ret = (typeDefCache = typeDefCacheArray[i]).getTypeDefByName(name)) == null; ++i) {
                }
            }
            return ret;
        }

        AtlasBaseTypeDef getTypeDefByGuid(String guid) {
            AtlasBaseTypeDef ret = null;
            if (guid != null) {
                TypeDefCache<? extends AtlasBaseTypeDef, ? extends AtlasType> typeDefCache;
                TypeDefCache<? extends AtlasBaseTypeDef, ? extends AtlasType>[] typeDefCacheArray = this.allDefCaches;
                int n = typeDefCacheArray.length;
                for (int i = 0; i < n && (ret = (typeDefCache = typeDefCacheArray[i]).getTypeDefByGuid(guid)) == null; ++i) {
                }
            }
            return ret;
        }

        void updateGuid(String typeName, String guid) {
            if (typeName != null) {
                this.enumDefs.updateGuid(typeName, guid);
                this.structDefs.updateGuid(typeName, guid);
                this.classificationDefs.updateGuid(typeName, guid);
                this.entityDefs.updateGuid(typeName, guid);
                this.relationshipDefs.updateGuid(typeName, guid);
                this.businessMetadataDefs.updateGuid(typeName, guid);
            }
        }

        void removeByGuid(String guid) {
            if (guid != null) {
                this.enumDefs.removeTypeDefByGuid(guid);
                this.structDefs.removeTypeDefByGuid(guid);
                this.classificationDefs.removeTypeDefByGuid(guid);
                this.entityDefs.removeTypeDefByGuid(guid);
                this.relationshipDefs.removeTypeDefByGuid(guid);
                this.businessMetadataDefs.removeTypeDefByGuid(guid);
            }
        }

        void removeByName(String typeName) {
            if (typeName != null) {
                this.enumDefs.removeTypeDefByName(typeName);
                this.structDefs.removeTypeDefByName(typeName);
                this.classificationDefs.removeTypeDefByName(typeName);
                this.entityDefs.removeTypeDefByName(typeName);
                this.relationshipDefs.removeTypeDefByName(typeName);
                this.businessMetadataDefs.removeTypeDefByName(typeName);
            }
        }

        void clear() {
            this.allTypes.clear();
            this.enumDefs.clear();
            this.structDefs.clear();
            this.classificationDefs.clear();
            this.entityDefs.clear();
            this.relationshipDefs.clear();
            this.businessMetadataDefs.clear();
            this.init();
        }
    }
}

