/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.rewrite;

import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.rewrite.Rewriter;
import org.apache.hadoop.hive.ql.parse.rewrite.UpdateStatement;
import org.apache.hadoop.hive.ql.parse.rewrite.sql.MultiInsertSqlGenerator;
import org.apache.hadoop.hive.ql.parse.rewrite.sql.SetClausePatcher;
import org.apache.hadoop.hive.ql.parse.rewrite.sql.SqlGeneratorFactory;
import org.apache.hadoop.hive.ql.parse.rewrite.sql.WhereClausePatcher;

public class UpdateRewriter
implements Rewriter<UpdateStatement> {
    public static final Context.Operation OPERATION = Context.Operation.UPDATE;
    protected final HiveConf conf;
    protected final SqlGeneratorFactory sqlGeneratorFactory;
    private final WhereClausePatcher whereClausePatcher;
    private final SetClausePatcher setClausePatcher;

    public UpdateRewriter(HiveConf conf, SqlGeneratorFactory sqlGeneratorFactory) {
        this.conf = conf;
        this.sqlGeneratorFactory = sqlGeneratorFactory;
        this.whereClausePatcher = new WhereClausePatcher();
        this.setClausePatcher = new SetClausePatcher();
    }

    @Override
    public ParseUtils.ReparseResult rewrite(Context context, UpdateStatement updateBlock) throws SemanticException {
        MultiInsertSqlGenerator sqlGenerator = this.sqlGeneratorFactory.createSqlGenerator();
        sqlGenerator.append("insert into table ");
        sqlGenerator.appendTargetTableName();
        sqlGenerator.appendPartitionColsOfTarget();
        int columnOffset = sqlGenerator.getDeleteValues(OPERATION).size();
        sqlGenerator.append(" select ");
        sqlGenerator.appendAcidSelectColumns(OPERATION);
        sqlGenerator.removeLastChar();
        HashMap<Integer, ASTNode> setColExprs = new HashMap<Integer, ASTNode>(updateBlock.getSetCols().size());
        List<FieldSchema> nonPartCols = updateBlock.getTargetTable().getCols();
        for (int i = 0; i < nonPartCols.size(); ++i) {
            sqlGenerator.append(",");
            String name = nonPartCols.get(i).getName();
            ASTNode setCol = updateBlock.getSetCols().get(name);
            sqlGenerator.append(HiveUtils.unparseIdentifier(name, (Configuration)this.conf));
            if (setCol == null) continue;
            setColExprs.put(columnOffset + i, setCol);
        }
        sqlGenerator.append(" from ");
        sqlGenerator.appendTargetTableName();
        sqlGenerator.appendSortKeys();
        ParseUtils.ReparseResult rr = ParseUtils.parseRewrittenQuery(context, sqlGenerator.toString());
        Context rewrittenCtx = rr.rewrittenCtx;
        ASTNode rewrittenTree = rr.rewrittenTree;
        ASTNode rewrittenInsert = (ASTNode)rewrittenTree.getChildren().get(1);
        rewrittenCtx.setOperation(OPERATION);
        rewrittenCtx.addDestNamePrefix(1, Context.DestClausePrefix.UPDATE);
        if (updateBlock.getWhereTree() != null) {
            this.whereClausePatcher.patch(rewrittenInsert, updateBlock.getWhereTree());
        }
        this.setClausePatcher.patchProjectionForUpdate(rewrittenInsert, setColExprs);
        rewrittenCtx.setEnableUnparse(false);
        return rr;
    }
}

