/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.paimon.data.AbstractPagedInputView;
import org.apache.paimon.data.AbstractPagedOutputView;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.RandomAccessInputView;
import org.apache.paimon.data.Segments;
import org.apache.paimon.data.SimpleCollectingOutputView;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.memory.MemorySegmentSource;
import org.apache.paimon.operation.metrics.CacheMetrics;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.BiFunctionWithIOE;
import org.apache.paimon.utils.CloseableIterator;
import org.apache.paimon.utils.Filter;
import org.apache.paimon.utils.FunctionWithIOException;
import org.apache.paimon.utils.ObjectSerializer;
import org.apache.paimon.utils.ObjectsFile;
import org.apache.paimon.utils.SegmentsCache;

@ThreadSafe
public class ObjectsCache<K, V> {
    private final SegmentsCache<K> cache;
    private final ObjectSerializer<V> projectedSerializer;
    private final ThreadLocal<InternalRowSerializer> formatSerializer;
    private final FunctionWithIOException<K, Long> fileSizeFunction;
    private final BiFunctionWithIOE<K, Long, CloseableIterator<InternalRow>> reader;
    @Nullable
    private CacheMetrics cacheMetrics;

    public ObjectsCache(SegmentsCache<K> cache, ObjectSerializer<V> projectedSerializer, RowType formatSchema, FunctionWithIOException<K, Long> fileSizeFunction, BiFunctionWithIOE<K, Long, CloseableIterator<InternalRow>> reader) {
        this.cache = cache;
        this.projectedSerializer = projectedSerializer;
        this.formatSerializer = ThreadLocal.withInitial(() -> new InternalRowSerializer(formatSchema));
        this.fileSizeFunction = fileSizeFunction;
        this.reader = reader;
    }

    public void withCacheMetrics(@Nullable CacheMetrics cacheMetrics) {
        this.cacheMetrics = cacheMetrics;
    }

    public List<V> read(K key, @Nullable Long fileSize, Filter<InternalRow> loadFilter, Filter<InternalRow> readFilter, Filter<V> readVFilter) throws IOException {
        Segments segments = this.cache.getIfPresents(key);
        if (segments != null) {
            if (this.cacheMetrics != null) {
                this.cacheMetrics.increaseHitObject();
            }
            return this.readFromSegments(segments, readFilter, readVFilter);
        }
        if (this.cacheMetrics != null) {
            this.cacheMetrics.increaseMissedObject();
        }
        if (fileSize == null) {
            fileSize = (Long)this.fileSizeFunction.apply(key);
        }
        if (fileSize <= this.cache.maxElementSize()) {
            segments = this.readSegments(key, fileSize, loadFilter);
            this.cache.put(key, segments);
            return this.readFromSegments(segments, readFilter, readVFilter);
        }
        return ObjectsFile.readFromIterator((CloseableIterator<InternalRow>)((CloseableIterator)this.reader.apply(key, (Object)fileSize)), this.projectedSerializer, readFilter, readVFilter);
    }

    private List<V> readFromSegments(Segments segments, Filter<InternalRow> readFilter, Filter<V> readVFilter) throws IOException {
        InternalRowSerializer formatSerializer = this.formatSerializer.get();
        ArrayList<V> entries = new ArrayList<V>();
        RandomAccessInputView view = new RandomAccessInputView(segments.segments(), this.cache.pageSize(), segments.limitInLastSegment());
        BinaryRow binaryRow = new BinaryRow(formatSerializer.getArity());
        try {
            while (true) {
                V v;
                formatSerializer.mapFromPages((InternalRow)binaryRow, (AbstractPagedInputView)view);
                if (!readFilter.test((Object)binaryRow) || !readVFilter.test(v = this.projectedSerializer.fromRow((InternalRow)binaryRow))) continue;
                entries.add(v);
            }
        }
        catch (EOFException e) {
            return entries;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Segments readSegments(K key, @Nullable Long fileSize, Filter<InternalRow> loadFilter) {
        InternalRowSerializer formatSerializer = this.formatSerializer.get();
        try (CloseableIterator iterator = (CloseableIterator)this.reader.apply(key, (Object)fileSize);){
            ArrayList segments = new ArrayList();
            MemorySegmentSource segmentSource = () -> MemorySegment.allocateHeapMemory((int)this.cache.pageSize());
            SimpleCollectingOutputView output = new SimpleCollectingOutputView(segments, segmentSource, this.cache.pageSize());
            while (iterator.hasNext()) {
                InternalRow row = (InternalRow)iterator.next();
                if (!loadFilter.test((Object)row)) continue;
                formatSerializer.serializeToPages(row, (AbstractPagedOutputView)output);
            }
            Segments segments2 = new Segments(segments, output.getCurrentPositionInSegment());
            return segments2;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

