/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.tag;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;

public interface TagTimeExtractor {
    public Optional<LocalDateTime> extract(long var1, @Nullable Long var3);

    @Nullable
    public static TagTimeExtractor createForAutoTag(CoreOptions options) {
        return TagTimeExtractor.create(options.tagCreationMode(), options);
    }

    @Nullable
    public static TagTimeExtractor createForTagPreview(CoreOptions options) {
        return TagTimeExtractor.create(options.tagToPartitionPreview(), options);
    }

    @Nullable
    public static TagTimeExtractor create(CoreOptions.TagCreationMode mode, CoreOptions options) {
        switch (mode) {
            case NONE: 
            case BATCH: {
                return null;
            }
            case PROCESS_TIME: {
                return new ProcessTimeExtractor();
            }
            case WATERMARK: {
                return new WatermarkExtractor(ZoneId.of(options.sinkWatermarkTimeZone()));
            }
        }
        throw new UnsupportedOperationException("Unsupported " + options.tagCreationMode());
    }

    public static class WatermarkExtractor
    implements TagTimeExtractor {
        private final ZoneId watermarkZoneId;

        private WatermarkExtractor(ZoneId watermarkZoneId) {
            this.watermarkZoneId = watermarkZoneId;
        }

        @Override
        public Optional<LocalDateTime> extract(long timeMilli, @Nullable Long watermark) {
            if (watermark == null || watermark == Long.MIN_VALUE) {
                return Optional.empty();
            }
            return Optional.of(Instant.ofEpochMilli(watermark).atZone(this.watermarkZoneId).toLocalDateTime());
        }
    }

    public static class ProcessTimeExtractor
    implements TagTimeExtractor {
        @Override
        public Optional<LocalDateTime> extract(long timeMilli, @Nullable Long watermark) {
            return Optional.of(Instant.ofEpochMilli(timeMilli).atZone(ZoneId.systemDefault()).toLocalDateTime());
        }
    }
}

