/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.catalog;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.paimon.shade.guava30.com.google.common.collect.Maps;
import org.apache.paimon.shade.guava30.com.google.common.collect.Sets;
import org.apache.paimon.utils.Pair;

public interface PropertyChange {
    public static PropertyChange setProperty(String property, String value) {
        return new SetProperty(property, value);
    }

    public static PropertyChange removeProperty(String property) {
        return new RemoveProperty(property);
    }

    public static Pair<Map<String, String>, Set<String>> getSetPropertiesToRemoveKeys(List<PropertyChange> changes) {
        HashMap setProperties = Maps.newHashMap();
        HashSet removeKeys = Sets.newHashSet();
        changes.forEach(change -> {
            if (change instanceof SetProperty) {
                SetProperty setProperty = (SetProperty)change;
                setProperties.put(setProperty.property(), setProperty.value());
            } else {
                removeKeys.add(((RemoveProperty)change).property());
            }
        });
        return Pair.of((Object)setProperties, (Object)removeKeys);
    }

    public static final class RemoveProperty
    implements PropertyChange {
        private final String property;

        private RemoveProperty(String property) {
            this.property = property;
        }

        public String property() {
            return this.property;
        }
    }

    public static final class SetProperty
    implements PropertyChange {
        private final String property;
        private final String value;

        private SetProperty(String property, String value) {
            this.property = property;
            this.value = value;
        }

        public String property() {
            return this.property;
        }

        public String value() {
            return this.value;
        }
    }
}

