/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.14.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;

/**
 * LoanProductGuaranteeData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class LoanProductGuaranteeData {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public static final String SERIALIZED_NAME_MANDATORY_GUARANTEE = "mandatoryGuarantee";
  @SerializedName(SERIALIZED_NAME_MANDATORY_GUARANTEE)
  private BigDecimal mandatoryGuarantee;

  public static final String SERIALIZED_NAME_MINIMUM_GUARANTEE_FROM_GUARANTOR = "minimumGuaranteeFromGuarantor";
  @SerializedName(SERIALIZED_NAME_MINIMUM_GUARANTEE_FROM_GUARANTOR)
  private BigDecimal minimumGuaranteeFromGuarantor;

  public static final String SERIALIZED_NAME_MINIMUM_GUARANTEE_FROM_OWN_FUNDS = "minimumGuaranteeFromOwnFunds";
  @SerializedName(SERIALIZED_NAME_MINIMUM_GUARANTEE_FROM_OWN_FUNDS)
  private BigDecimal minimumGuaranteeFromOwnFunds;

  public static final String SERIALIZED_NAME_PRODUCT_ID = "productId";
  @SerializedName(SERIALIZED_NAME_PRODUCT_ID)
  private Long productId;

  public LoanProductGuaranteeData() {
  }

  public LoanProductGuaranteeData id(Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  @javax.annotation.Nullable

  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  public LoanProductGuaranteeData mandatoryGuarantee(BigDecimal mandatoryGuarantee) {
    
    this.mandatoryGuarantee = mandatoryGuarantee;
    return this;
  }

  /**
   * Get mandatoryGuarantee
   * @return mandatoryGuarantee
   */
  @javax.annotation.Nullable

  public BigDecimal getMandatoryGuarantee() {
    return mandatoryGuarantee;
  }


  public void setMandatoryGuarantee(BigDecimal mandatoryGuarantee) {
    this.mandatoryGuarantee = mandatoryGuarantee;
  }

  public LoanProductGuaranteeData minimumGuaranteeFromGuarantor(BigDecimal minimumGuaranteeFromGuarantor) {
    
    this.minimumGuaranteeFromGuarantor = minimumGuaranteeFromGuarantor;
    return this;
  }

  /**
   * Get minimumGuaranteeFromGuarantor
   * @return minimumGuaranteeFromGuarantor
   */
  @javax.annotation.Nullable

  public BigDecimal getMinimumGuaranteeFromGuarantor() {
    return minimumGuaranteeFromGuarantor;
  }


  public void setMinimumGuaranteeFromGuarantor(BigDecimal minimumGuaranteeFromGuarantor) {
    this.minimumGuaranteeFromGuarantor = minimumGuaranteeFromGuarantor;
  }

  public LoanProductGuaranteeData minimumGuaranteeFromOwnFunds(BigDecimal minimumGuaranteeFromOwnFunds) {
    
    this.minimumGuaranteeFromOwnFunds = minimumGuaranteeFromOwnFunds;
    return this;
  }

  /**
   * Get minimumGuaranteeFromOwnFunds
   * @return minimumGuaranteeFromOwnFunds
   */
  @javax.annotation.Nullable

  public BigDecimal getMinimumGuaranteeFromOwnFunds() {
    return minimumGuaranteeFromOwnFunds;
  }


  public void setMinimumGuaranteeFromOwnFunds(BigDecimal minimumGuaranteeFromOwnFunds) {
    this.minimumGuaranteeFromOwnFunds = minimumGuaranteeFromOwnFunds;
  }

  public LoanProductGuaranteeData productId(Long productId) {
    
    this.productId = productId;
    return this;
  }

  /**
   * Get productId
   * @return productId
   */
  @javax.annotation.Nullable

  public Long getProductId() {
    return productId;
  }


  public void setProductId(Long productId) {
    this.productId = productId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LoanProductGuaranteeData loanProductGuaranteeData = (LoanProductGuaranteeData) o;
    return Objects.equals(this.id, loanProductGuaranteeData.id) &&
        Objects.equals(this.mandatoryGuarantee, loanProductGuaranteeData.mandatoryGuarantee) &&
        Objects.equals(this.minimumGuaranteeFromGuarantor, loanProductGuaranteeData.minimumGuaranteeFromGuarantor) &&
        Objects.equals(this.minimumGuaranteeFromOwnFunds, loanProductGuaranteeData.minimumGuaranteeFromOwnFunds) &&
        Objects.equals(this.productId, loanProductGuaranteeData.productId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, mandatoryGuarantee, minimumGuaranteeFromGuarantor, minimumGuaranteeFromOwnFunds, productId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LoanProductGuaranteeData {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    mandatoryGuarantee: ").append(toIndentedString(mandatoryGuarantee)).append("\n");
    sb.append("    minimumGuaranteeFromGuarantor: ").append(toIndentedString(minimumGuaranteeFromGuarantor)).append("\n");
    sb.append("    minimumGuaranteeFromOwnFunds: ").append(toIndentedString(minimumGuaranteeFromOwnFunds)).append("\n");
    sb.append("    productId: ").append(toIndentedString(productId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

