/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.tax.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.accounting.glaccount.domain.GLAccountType;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.portfolio.tax.domain.TaxComponent;
import org.apache.fineract.portfolio.tax.domain.TaxGroup;
import org.apache.fineract.portfolio.tax.domain.TaxGroupMappings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaxValidator {
    public static final String DATE_FORMAT = "dateFormat";
    public static final String LOCALE = "locale";
    public static final String TAX_COMPONENT = "tax.component";
    public static final String TAX_GROUP = "tax.group";
    public static final String TOTAL_PERCENTAGE = "total.percentage";
    public static final String GROUP_TOTAL = "group.total.";
    public static final String COMPONENT = "component";
    public static final String DATES_ARE_OVERLAPPING = "dates.are.overlapping";
    public static final String COMPONENT_START_DATE = "component.start.date";
    private static final Set<String> SUPPORTED_TAX_COMPONENT_CREATE_PARAMETERS = new HashSet<String>(Arrays.asList("dateFormat", "locale", "name", "percentage", "startDate", "debitAccountType", "debitAcountId", "creditAccountType", "creditAcountId"));
    private static final Set<String> SUPPORTED_TAX_COMPONENT_UPDATE_PARAMETERS = new HashSet<String>(Arrays.asList("dateFormat", "locale", "name", "percentage", "startDate"));
    private static final Set<String> SUPPORTED_TAX_GROUP_PARAMETERS = new HashSet<String>(Arrays.asList("dateFormat", "locale", "name", "taxComponents"));
    private static final Set<String> SUPPORTED_TAX_GROUP_TAX_COMPONENTS_CREATE_PARAMETERS = new HashSet<String>(Arrays.asList("taxComponentId", "startDate"));
    private static final Set<String> SUPPORTED_TAX_GROUP_TAX_COMPONENTS_UPDATE_PARAMETERS = new HashSet<String>(Arrays.asList("id", "taxComponentId", "startDate", "endDate"));
    public static final String DOT = ".";
    public static final String AT_INDEX = ".at.index.";
    private final FromJsonHelper fromApiJsonHelper;

    @Autowired
    public TaxValidator(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public void validateForTaxComponentCreate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_TAX_COMPONENT_CREATE_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(TAX_COMPONENT);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        String name = this.fromApiJsonHelper.extractStringNamed("name", element);
        baseDataValidator.reset().parameter("name").value((Object)name).notBlank();
        BigDecimal percentage = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("percentage", element);
        baseDataValidator.reset().parameter("percentage").value((Object)percentage).notBlank().positiveAmount().notGreaterThanMax(BigDecimal.valueOf(100L));
        Integer debitAccountType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("debitAccountType", element);
        baseDataValidator.reset().parameter("debitAccountType").value((Object)debitAccountType).ignoreIfNull().isOneOfTheseValues(new Object[]{GLAccountType.ASSET.getValue(), GLAccountType.LIABILITY.getValue(), GLAccountType.EQUITY.getValue(), GLAccountType.INCOME.getValue(), GLAccountType.EXPENSE.getValue()});
        Long debitAccountId = this.fromApiJsonHelper.extractLongNamed("debitAcountId", element);
        baseDataValidator.reset().parameter("debitAcountId").value((Object)debitAccountId).longGreaterThanZero();
        if (debitAccountType != null || debitAccountId != null) {
            baseDataValidator.reset().parameter("debitAccountType").value((Object)debitAccountType).notBlank();
            baseDataValidator.reset().parameter("debitAcountId").value((Object)debitAccountId).notBlank();
        }
        Integer creditAccountType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("creditAccountType", element);
        baseDataValidator.reset().parameter("creditAccountType").value((Object)creditAccountType).ignoreIfNull().isOneOfTheseValues(new Object[]{GLAccountType.ASSET.getValue(), GLAccountType.LIABILITY.getValue(), GLAccountType.EQUITY.getValue(), GLAccountType.INCOME.getValue(), GLAccountType.EXPENSE.getValue()});
        Long creditAccountId = this.fromApiJsonHelper.extractLongNamed("creditAcountId", element);
        baseDataValidator.reset().parameter("creditAcountId").value((Object)creditAccountId).longGreaterThanZero();
        if (creditAccountType != null || creditAccountId != null) {
            baseDataValidator.reset().parameter("creditAcountId").value((Object)creditAccountId).notBlank();
            baseDataValidator.reset().parameter("creditAccountType").value((Object)creditAccountType).notBlank();
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForTaxComponentUpdate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_TAX_COMPONENT_UPDATE_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(TAX_COMPONENT);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        if (this.fromApiJsonHelper.parameterExists("name", element)) {
            String name = this.fromApiJsonHelper.extractStringNamed("name", element);
            baseDataValidator.reset().parameter("name").value((Object)name).notBlank();
        }
        if (this.fromApiJsonHelper.parameterExists("percentage", element)) {
            BigDecimal percentage = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("percentage", element);
            baseDataValidator.reset().parameter("percentage").value((Object)percentage).notBlank().positiveAmount().notGreaterThanMax(BigDecimal.valueOf(100L));
        }
        if (this.fromApiJsonHelper.parameterExists("startDate", element)) {
            LocalDate startDate = this.fromApiJsonHelper.extractLocalDateNamed("startDate", element);
            baseDataValidator.reset().parameter("startDate").value((Object)startDate).validateDateAfter(DateUtils.getBusinessLocalDate());
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForTaxGroupCreate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_TAX_GROUP_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(TAX_GROUP);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        String name = this.fromApiJsonHelper.extractStringNamed("name", element);
        baseDataValidator.reset().parameter("name").value((Object)name).notBlank();
        JsonArray taxComponents = this.fromApiJsonHelper.extractJsonArrayNamed("taxComponents", element);
        baseDataValidator.reset().parameter("taxComponents").value((Object)taxComponents).notBlank();
        JsonObject topLevelJsonElement = element.getAsJsonObject();
        if (topLevelJsonElement.get("taxComponents").isJsonArray()) {
            JsonArray array = topLevelJsonElement.get("taxComponents").getAsJsonArray();
            baseDataValidator.reset().parameter("taxComponents").value((Object)array.size()).integerGreaterThanZero();
            for (int i = 1; i <= array.size(); ++i) {
                JsonObject taxComponent = array.get(i - 1).getAsJsonObject();
                String arrayObjectJson = this.fromApiJsonHelper.toJson((JsonElement)taxComponent);
                this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, arrayObjectJson, (Collection)SUPPORTED_TAX_GROUP_TAX_COMPONENTS_CREATE_PARAMETERS);
                Long taxComponentId = this.fromApiJsonHelper.extractLongNamed("taxComponentId", (JsonElement)taxComponent);
                baseDataValidator.reset().parameter("taxComponents").parameterAtIndexArray("taxComponentId", Integer.valueOf(i)).value((Object)taxComponentId).notNull().longGreaterThanZero();
            }
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForTaxGroupUpdate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_TAX_GROUP_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(TAX_GROUP);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        if (this.fromApiJsonHelper.parameterExists("name", element)) {
            String name = this.fromApiJsonHelper.extractStringNamed("name", element);
            baseDataValidator.reset().parameter("name").value((Object)name).notBlank();
        }
        if (this.fromApiJsonHelper.parameterExists("taxComponents", element)) {
            JsonArray taxComponents = this.fromApiJsonHelper.extractJsonArrayNamed("taxComponents", element);
            baseDataValidator.reset().parameter("taxComponents").value((Object)taxComponents).notBlank();
            JsonObject topLevelJsonElement = element.getAsJsonObject();
            String dateFormat = this.fromApiJsonHelper.extractDateFormatParameter(topLevelJsonElement);
            Locale locale = this.fromApiJsonHelper.extractLocaleParameter(topLevelJsonElement);
            if (topLevelJsonElement.get("taxComponents").isJsonArray()) {
                JsonArray array = topLevelJsonElement.get("taxComponents").getAsJsonArray();
                for (int i = 1; i <= array.size(); ++i) {
                    JsonObject taxComponent = array.get(i - 1).getAsJsonObject();
                    String arrayObjectJson = this.fromApiJsonHelper.toJson((JsonElement)taxComponent);
                    this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, arrayObjectJson, (Collection)SUPPORTED_TAX_GROUP_TAX_COMPONENTS_UPDATE_PARAMETERS);
                    Long taxComponentId = this.fromApiJsonHelper.extractLongNamed("taxComponentId", (JsonElement)taxComponent);
                    Long taxMappingId = this.fromApiJsonHelper.extractLongNamed("taxComponentId", (JsonElement)taxComponent);
                    if (taxMappingId == null) {
                        baseDataValidator.reset().parameter("taxComponents.taxComponentId.at.index." + i).value((Object)taxComponentId).notNull().longGreaterThanZero();
                    } else {
                        baseDataValidator.reset().parameter("taxComponents.taxComponentId.at.index." + i).value((Object)taxComponentId).longGreaterThanZero();
                        baseDataValidator.reset().parameter("taxComponents.id.at.index." + i).value((Object)taxMappingId).longGreaterThanZero();
                    }
                    LocalDate endDate = this.fromApiJsonHelper.extractLocalDateNamed("endDate", (JsonElement)taxComponent, dateFormat, locale);
                    baseDataValidator.reset().parameter("taxComponents.endDate.at.index." + i).value((Object)endDate).ignoreIfNull().validateDateAfter(DateUtils.getBusinessLocalDate());
                    LocalDate startDate = this.fromApiJsonHelper.extractLocalDateNamed("startDate", (JsonElement)taxComponent, dateFormat, locale);
                    if (endDate == null || startDate == null) continue;
                    baseDataValidator.reset().parameter("taxComponents.at.index." + i).failWithCode("start.date.end.date.both.should.not.be.present", new Object[]{startDate, endDate});
                }
            }
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateTaxGroupEndDateAndTaxComponent(TaxGroup taxGroup, Set<TaxGroupMappings> groupMappings) {
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(TAX_GROUP);
        for (TaxGroupMappings mapping : groupMappings) {
            if (mapping.getId() != null) {
                TaxGroupMappings existing = taxGroup.findOneBy(mapping);
                if (existing.endDate() != null && mapping.endDate() != null && !DateUtils.isEqual((LocalDate)existing.endDate(), (LocalDate)mapping.endDate())) {
                    baseDataValidator.reset().parameter("endDate").failWithCode("can.not.modify.end.date.once.updated", new Object[0]);
                } else {
                    baseDataValidator.reset().parameter("endDate").value((Object)mapping.endDate()).ignoreIfNull().validateDateAfter(existing.startDate());
                }
                if (mapping.getTaxComponent() == null || ((Long)existing.getTaxComponent().getId()).equals(mapping.getTaxComponent().getId())) continue;
                baseDataValidator.reset().parameter("taxComponentId").failWithCode("update.not.supported", new Object[0]);
                continue;
            }
            if (mapping.endDate() == null) continue;
            baseDataValidator.reset().parameter("endDate").failWithCode("not.supported.for.new.association", new Object[0]);
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateTaxGroup(TaxGroup taxGroup) {
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(TAX_GROUP);
        Set groupMappings = taxGroup.getTaxGroupMappings();
        this.validateGroupTotal(groupMappings, baseDataValidator, TOTAL_PERCENTAGE);
        this.validateOverlappingComponents(groupMappings, baseDataValidator);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateTaxComponentForUpdate(TaxComponent taxComponent) {
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(TAX_COMPONENT);
        this.validateGroupTotal(taxComponent.getTaxGroupMappings(), baseDataValidator, "group.total.percentage");
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateStartDate(LocalDate existingStartDate, JsonCommand command) {
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(TAX_COMPONENT);
        this.validateStartDate(existingStartDate, command.localDateValueOfParameterNamed("startDate"), baseDataValidator);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void validateStartDate(LocalDate existingStartDate, LocalDate startDate, DataValidatorBuilder baseDataValidator) {
        baseDataValidator.reset().parameter("startDate").value((Object)startDate).validateDateAfter(existingStartDate);
    }

    private void validateOverlappingComponents(Set<TaxGroupMappings> taxMappings, DataValidatorBuilder baseDataValidator) {
        for (TaxGroupMappings groupMappingsOne : taxMappings) {
            ArrayList<TaxGroupMappings> mappings = new ArrayList<TaxGroupMappings>(taxMappings);
            mappings.remove(groupMappingsOne);
            for (TaxGroupMappings groupMappings : mappings) {
                if (!groupMappingsOne.getTaxComponent().equals(groupMappings.getTaxComponent())) continue;
                if (groupMappingsOne.endDate() == null && groupMappings.endDate() == null) {
                    baseDataValidator.reset().parameter(COMPONENT).failWithCode(DATES_ARE_OVERLAPPING, new Object[0]);
                    continue;
                }
                if (DateUtils.isAfter((LocalDate)groupMappingsOne.startDate(), (LocalDate)groupMappings.startDate())) {
                    baseDataValidator.reset().parameter(COMPONENT_START_DATE).value((Object)groupMappingsOne.startDate()).validateDateAfter(groupMappings.endDate());
                    continue;
                }
                baseDataValidator.reset().parameter(COMPONENT_START_DATE).value((Object)groupMappings.startDate()).validateDateAfter(groupMappingsOne.endDate());
            }
        }
    }

    private void validateGroupTotal(Set<TaxGroupMappings> taxMappings, DataValidatorBuilder baseDataValidator, String paramenter) {
        for (TaxGroupMappings groupMappingsOne : taxMappings) {
            Collection dates = groupMappingsOne.getTaxComponent().allStartDates();
            for (LocalDate date : dates) {
                LocalDate applicableDate = date.plusDays(1L);
                BigDecimal total = BigDecimal.ZERO;
                for (TaxGroupMappings groupMappings : taxMappings) {
                    BigDecimal applicablePercentage;
                    if (!groupMappings.occursOnDayFromAndUpToAndIncluding(applicableDate) || (applicablePercentage = groupMappings.getTaxComponent().getApplicablePercentage(applicableDate)) == null) continue;
                    total = total.add(applicablePercentage);
                }
                baseDataValidator.reset().parameter(paramenter).value((Object)total).notGreaterThanMax(BigDecimal.valueOf(100L));
            }
        }
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }
}

