/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.shareproducts.domain;

import org.apache.fineract.portfolio.products.exception.ProductNotFoundException;
import org.apache.fineract.portfolio.shareproducts.domain.ShareProduct;
import org.apache.fineract.portfolio.shareproducts.domain.ShareProductRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShareProductRepositoryWrapper {
    private final ShareProductRepository shareProductRepository;

    @Autowired
    public ShareProductRepositoryWrapper(ShareProductRepository shareProductRepository) {
        this.shareProductRepository = shareProductRepository;
    }

    public ShareProduct findOneWithNotFoundDetection(Long productId) {
        return (ShareProduct)this.shareProductRepository.findById((Object)productId).orElseThrow(() -> new ProductNotFoundException(productId, "share"));
    }

    public void save(ShareProduct product) {
        this.shareProductRepository.save((Object)product);
    }

    public void saveAndFlush(ShareProduct product) {
        this.shareProductRepository.saveAndFlush((Object)product);
    }
}

