/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.api.pointintime;

import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.DateParam;
import org.apache.fineract.infrastructure.core.data.DateFormat;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.loanaccount.api.pointintime.LoansPointInTimeApi;
import org.apache.fineract.portfolio.loanaccount.api.pointintime.data.RetrieveLoansPointInTimeExternalIdsRequest;
import org.apache.fineract.portfolio.loanaccount.api.pointintime.data.RetrieveLoansPointInTimeRequest;
import org.apache.fineract.portfolio.loanaccount.data.LoanPointInTimeData;
import org.apache.fineract.portfolio.loanaccount.service.LoanPointInTimeService;
import org.apache.fineract.portfolio.loanaccount.service.LoanReadPlatformService;
import org.springframework.stereotype.Component;

@Component
public class LoansPointInTimeApiDelegate
implements LoansPointInTimeApi {
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "LOAN";
    private final LoanPointInTimeService loanPointInTimeService;
    private final LoanReadPlatformService loanReadPlatformService;
    private final PlatformSecurityContext context;

    public LoanPointInTimeData retrieveLoanPointInTime(Long loanId, DateParam dateParam, String dateFormat, String locale) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        return this.getLoanPointInTime(loanId, dateParam, dateFormat, locale);
    }

    public LoanPointInTimeData retrieveLoanPointInTimeByExternalId(String loanExternalIdStr, DateParam dateParam, String dateFormat, String locale) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        ExternalId loanExternalId = ExternalIdFactory.produce((String)loanExternalIdStr);
        Long resolvedLoanId = this.loanReadPlatformService.getResolvedLoanId(loanExternalId);
        return this.getLoanPointInTime(resolvedLoanId, dateParam, dateFormat, locale);
    }

    public List<LoanPointInTimeData> retrieveLoansPointInTime(RetrieveLoansPointInTimeRequest request) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        List loanIds = request.getLoanIds();
        DateParam dateParam = request.getDate();
        String dateFormat = request.getDateFormat();
        String locale = request.getLocale();
        return this.getLoansPointInTime(loanIds, dateParam, dateFormat, locale);
    }

    public List<LoanPointInTimeData> retrieveLoansPointInTimeByExternalIds(RetrieveLoansPointInTimeExternalIdsRequest request) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        List loanExternalIds = request.getExternalIds();
        DateParam dateParam = request.getDate();
        String dateFormat = request.getDateFormat();
        String locale = request.getLocale();
        List externalIds = ExternalIdFactory.produce((List)loanExternalIds);
        List loanIds = this.resolveExternalIds(externalIds);
        return this.getLoansPointInTime(loanIds, dateParam, dateFormat, locale);
    }

    private List<LoanPointInTimeData> getLoansPointInTime(List<Long> loanIds, DateParam dateParam, String dateFormat, String locale) {
        DateFormat df = StringUtils.isBlank((CharSequence)dateFormat) ? null : new DateFormat(dateFormat);
        LocalDate date = dateParam.getDate("date", df, locale);
        return this.loanPointInTimeService.retrieveAt(loanIds, date);
    }

    private LoanPointInTimeData getLoanPointInTime(Long loanId, DateParam dateParam, String dateFormat, String locale) {
        DateFormat df = StringUtils.isBlank((CharSequence)dateFormat) ? null : new DateFormat(dateFormat);
        LocalDate date = dateParam.getDate("date", df, locale);
        return this.loanPointInTimeService.retrieveAt(loanId, date);
    }

    private List<Long> resolveExternalIds(List<ExternalId> loanExternalIds) {
        loanExternalIds.forEach(ExternalId::throwExceptionIfEmpty);
        return this.loanReadPlatformService.retrieveLoanIdsByExternalIds(loanExternalIds);
    }

    @Generated
    public LoansPointInTimeApiDelegate(LoanPointInTimeService loanPointInTimeService, LoanReadPlatformService loanReadPlatformService, PlatformSecurityContext context) {
        this.loanPointInTimeService = loanPointInTimeService;
        this.loanReadPlatformService = loanReadPlatformService;
        this.context = context;
    }
}

