/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.api;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.ToApiJsonSerializer;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Profile(value={"test"})
@Component
@Path(value="/v1/internal/client")
public class InternalClientInformationApiResource
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InternalClientInformationApiResource.class);
    private final ClientRepositoryWrapper clientRepositoryWrapper;
    private final ToApiJsonSerializer<Map> toApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;

    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    public void afterPropertiesSet() {
        log.warn("------------------------------------------------------------");
        log.warn("                                                            ");
        log.warn("DO NOT USE THIS IN PRODUCTION!");
        log.warn("Internal client services mode is enabled");
        log.warn("DO NOT USE THIS IN PRODUCTION!");
        log.warn("                                                            ");
        log.warn("------------------------------------------------------------");
    }

    @GET
    @Path(value="{clientId}/audit")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    public String getClientAuditFields(@Context UriInfo uriInfo, @PathParam(value="clientId") Long clientId) {
        log.warn("------------------------------------------------------------");
        log.warn("                                                            ");
        log.warn("Fetching client with {}", (Object)clientId);
        log.warn("                                                            ");
        log.warn("------------------------------------------------------------");
        Client client = this.clientRepositoryWrapper.findOneWithNotFoundDetection(clientId);
        HashMap<String, Serializable> auditFields = new HashMap<String, Serializable>(Map.of("createdBy", client.getCreatedBy().orElse(null), "createdDate", client.getCreatedDate().orElse(null), "lastModifiedBy", client.getLastModifiedBy().orElse(null), "lastModifiedDate", client.getLastModifiedDate().orElse(null)));
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, auditFields);
    }

    @Generated
    public InternalClientInformationApiResource(ClientRepositoryWrapper clientRepositoryWrapper, ToApiJsonSerializer<Map> toApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper) {
        this.clientRepositoryWrapper = clientRepositoryWrapper;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
    }
}

