/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.workingdays.domain;

import java.time.LocalDate;
import java.util.List;
import org.apache.fineract.organisation.workingdays.domain.WorkingDays;
import org.apache.fineract.organisation.workingdays.domain.WorkingDaysRepository;
import org.apache.fineract.organisation.workingdays.exception.WorkingDaysNotFoundException;
import org.apache.fineract.organisation.workingdays.service.WorkingDaysUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkingDaysRepositoryWrapper {
    private final WorkingDaysRepository repository;

    @Autowired
    public WorkingDaysRepositoryWrapper(WorkingDaysRepository repository) {
        this.repository = repository;
    }

    public WorkingDays findOne() {
        List workingDaysList = this.repository.findAll();
        if (workingDaysList == null || workingDaysList.isEmpty()) {
            throw new WorkingDaysNotFoundException();
        }
        return (WorkingDays)workingDaysList.get(0);
    }

    public void save(WorkingDays workingDays) {
        this.repository.save((Object)workingDays);
    }

    public void saveAndFlush(WorkingDays workingDays) {
        this.repository.saveAndFlush((Object)workingDays);
    }

    public void delete(WorkingDays workingDays) {
        this.repository.delete((Object)workingDays);
    }

    public boolean isWorkingDay(LocalDate transactionDate) {
        WorkingDays workingDays = this.findOne();
        return WorkingDaysUtil.isWorkingDay((WorkingDays)workingDays, (LocalDate)transactionDate);
    }
}

