/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.provisioning.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.accounting.glaccount.domain.GLAccount;
import org.apache.fineract.accounting.glaccount.domain.GLAccountRepository;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.provisioning.domain.LoanProductProvisionCriteria;
import org.apache.fineract.organisation.provisioning.domain.ProvisioningCategory;
import org.apache.fineract.organisation.provisioning.domain.ProvisioningCategoryRepository;
import org.apache.fineract.organisation.provisioning.domain.ProvisioningCriteria;
import org.apache.fineract.organisation.provisioning.domain.ProvisioningCriteriaDefinition;
import org.apache.fineract.organisation.provisioning.exception.ProvisioningCriteriaOverlappingDefinitionException;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProduct;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProductRepository;

public class ProvisioningCriteriaAssembler {
    private final FromJsonHelper fromApiJsonHelper;
    private final ProvisioningCategoryRepository provisioningCategoryRepository;
    private final LoanProductRepository loanProductRepository;
    private final GLAccountRepository glAccountRepository;
    private final PlatformSecurityContext platformSecurityContext;

    public List<LoanProduct> parseLoanProducts(JsonElement jsonElement) {
        ArrayList<LoanProduct> loanProducts = new ArrayList();
        if (this.fromApiJsonHelper.parameterExists("loanProducts", jsonElement)) {
            JsonArray jsonloanProducts = this.fromApiJsonHelper.extractJsonArrayNamed("loanProducts", jsonElement);
            for (JsonElement element : jsonloanProducts) {
                Long productId = this.fromApiJsonHelper.extractLongNamed("id", (JsonElement)element.getAsJsonObject());
                loanProducts.add(this.loanProductRepository.findById((Object)productId).orElse(null));
            }
        } else {
            loanProducts = this.loanProductRepository.findAll();
        }
        return loanProducts;
    }

    private void validateRange(Set<ProvisioningCriteriaDefinition> criteriaDefinitions) {
        ArrayList<ProvisioningCriteriaDefinition> def = new ArrayList<ProvisioningCriteriaDefinition>();
        def.addAll(criteriaDefinitions);
        for (int i = 0; i < def.size(); ++i) {
            for (int j = i + 1; j < def.size(); ++j) {
                if (!((ProvisioningCriteriaDefinition)def.get(i)).isOverlapping((ProvisioningCriteriaDefinition)def.get(j))) continue;
                throw new ProvisioningCriteriaOverlappingDefinitionException();
            }
        }
    }

    public ProvisioningCriteria fromParsedJson(JsonElement jsonElement) {
        ProvisioningCriteria provisioningCriteria = this.createCriteria(jsonElement);
        Locale locale = this.fromApiJsonHelper.extractLocaleParameter(jsonElement.getAsJsonObject());
        List loanProducts = this.parseLoanProducts(jsonElement);
        HashSet<ProvisioningCriteriaDefinition> criteriaDefinitions = new HashSet<ProvisioningCriteriaDefinition>();
        JsonArray jsonProvisioningCriteria = this.fromApiJsonHelper.extractJsonArrayNamed("definitions", jsonElement);
        for (JsonElement element : jsonProvisioningCriteria) {
            JsonObject jsonObject = element.getAsJsonObject();
            ProvisioningCriteriaDefinition provisioningCriteriaData = this.createProvisioningCriteriaDefinitions(jsonObject, locale, provisioningCriteria);
            criteriaDefinitions.add(provisioningCriteriaData);
        }
        this.validateRange(criteriaDefinitions);
        HashSet<LoanProductProvisionCriteria> mapping = new HashSet<LoanProductProvisionCriteria>();
        for (LoanProduct loanProduct : loanProducts) {
            mapping.add(new LoanProductProvisionCriteria(provisioningCriteria, loanProduct));
        }
        provisioningCriteria.setProvisioningCriteriaDefinitions(criteriaDefinitions);
        provisioningCriteria.setLoanProductProvisioningCriteria(mapping);
        return provisioningCriteria;
    }

    private ProvisioningCriteria createCriteria(JsonElement jsonElement) {
        String criteriaName = this.fromApiJsonHelper.extractStringNamed("criteriaName", jsonElement);
        ProvisioningCriteria criteria = new ProvisioningCriteria(criteriaName, this.platformSecurityContext.authenticatedUser(), DateUtils.getLocalDateTimeOfSystem(), this.platformSecurityContext.authenticatedUser(), DateUtils.getLocalDateTimeOfSystem());
        return criteria;
    }

    private ProvisioningCriteriaDefinition createProvisioningCriteriaDefinitions(JsonObject jsonObject, Locale locale, ProvisioningCriteria criteria) {
        Long categoryId = this.fromApiJsonHelper.extractLongNamed("categoryId", (JsonElement)jsonObject);
        Long minimumAge = this.fromApiJsonHelper.extractLongNamed("minAge", (JsonElement)jsonObject);
        Long maximumAge = this.fromApiJsonHelper.extractLongNamed("maxAge", (JsonElement)jsonObject);
        BigDecimal provisioningpercentage = this.fromApiJsonHelper.extractBigDecimalNamed("provisioningPercentage", (JsonElement)jsonObject, locale);
        Long liabilityAccountId = this.fromApiJsonHelper.extractLongNamed("liabilityAccount", (JsonElement)jsonObject);
        Long expenseAccountId = this.fromApiJsonHelper.extractLongNamed("expenseAccount", (JsonElement)jsonObject);
        ProvisioningCategory provisioningCategory = this.provisioningCategoryRepository.findById((Object)categoryId).orElse(null);
        GLAccount liabilityAccount = this.glAccountRepository.findById((Object)liabilityAccountId).orElse(null);
        GLAccount expenseAccount = this.glAccountRepository.findById((Object)expenseAccountId).orElse(null);
        return ProvisioningCriteriaDefinition.newPrivisioningCriteria((ProvisioningCriteria)criteria, (ProvisioningCategory)provisioningCategory, (Long)minimumAge, (Long)maximumAge, (BigDecimal)provisioningpercentage, (GLAccount)liabilityAccount, (GLAccount)expenseAccount);
    }

    @Generated
    public ProvisioningCriteriaAssembler(FromJsonHelper fromApiJsonHelper, ProvisioningCategoryRepository provisioningCategoryRepository, LoanProductRepository loanProductRepository, GLAccountRepository glAccountRepository, PlatformSecurityContext platformSecurityContext) {
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.provisioningCategoryRepository = provisioningCategoryRepository;
        this.loanProductRepository = loanProductRepository;
        this.glAccountRepository = glAccountRepository;
        this.platformSecurityContext = platformSecurityContext;
    }
}

