/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.security.filter;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.domain.FineractPlatformTenant;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.infrastructure.security.service.AuthTenantDetailsService;
import org.springframework.lang.NonNull;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;
import org.springframework.web.filter.OncePerRequestFilter;

public class TenantAwareAuthenticationFilter
extends OncePerRequestFilter {
    private final BearerTokenResolver resolver;
    private final AuthTenantDetailsService tenantDetailsService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) throws ServletException, IOException {
        try {
            String tenantId;
            String token = this.resolver.resolve(request);
            if (token != null) {
                JWT jwt = JWTParser.parse((String)token);
                JWTClaimsSet claims = jwt.getJWTClaimsSet();
                tenantId = (String)claims.getClaim("tenant");
            } else {
                tenantId = request.getParameter("tenantId");
            }
            ThreadLocalContextUtil.setTenant((FineractPlatformTenant)this.tenantDetailsService.loadTenantById(tenantId, false));
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            ThreadLocalContextUtil.reset();
        }
    }

    @Generated
    public TenantAwareAuthenticationFilter(BearerTokenResolver resolver, AuthTenantDetailsService tenantDetailsService) {
        this.resolver = resolver;
        this.tenantDetailsService = tenantDetailsService;
    }
}

