/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.commands.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.commands.api.MakercheckersApiResourceSwagger;
import org.apache.fineract.commands.data.AuditData;
import org.apache.fineract.commands.data.AuditSearchData;
import org.apache.fineract.commands.data.request.MakerCheckerRequest;
import org.apache.fineract.commands.service.AuditReadPlatformService;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.exception.UnrecognizedQueryParamException;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.security.utils.SQLBuilder;
import org.springframework.stereotype.Component;

@Path(value="/v1/makercheckers")
@Component
@Tag(name="Maker Checker (or 4-eye) functionality")
public class MakercheckersApiResource {
    private static final String COMMAND_APPROVE = "approve";
    private static final String COMMAND_REJECT = "reject";
    private final AuditReadPlatformService readPlatformService;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService writePlatformService;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Maker Checker Entries", description="Get a list of entries that can be checked by the requestor that match the criteria supplied.\n\nExample Requests:\n\nmakercheckers\n\nmakercheckers?fields=madeOnDate,maker,processingResult\n\nmakercheckers?makerDateTimeFrom=2013-03-25 08:00:00&makerDateTimeTo=2013-04-04 18:00:00\n\nmakercheckers?officeId=1\n\nmakercheckers?officeId=1&includeJson=true")
    public List<AuditData> retrieveCommands(@Context UriInfo uriInfo, @BeanParam MakerCheckerRequest makerCheckerRequest) {
        SQLBuilder extraCriteria = this.getExtraCriteria(makerCheckerRequest);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.readPlatformService.retrieveAllEntriesToBeChecked(extraCriteria, settings.isIncludeJson());
    }

    @GET
    @Path(value="/searchtemplate")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Maker Checker Search Template", description="This is a convenience resource. It can be useful when building a Checker Inbox UI. \"appUsers\" are data scoped to the office/branch the requestor is associated with. \"actionNames\" and \"entityNames\" returned are those that the requestor has Checker approval permissions for.\n\nExample Requests:\n\nmakercheckers/searchtemplate\nmakercheckers/searchtemplate?fields=entityNames")
    public AuditSearchData retrieveAuditSearchTemplate() {
        return this.readPlatformService.retrieveSearchTemplate("makerchecker");
    }

    @POST
    @Path(value="{auditId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Approve Maker Checker Entry | Reject Maker Checker Entry")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=MakercheckersApiResourceSwagger.PostMakerCheckersResponse.class))})})
    public CommandProcessingResult approveMakerCheckerEntry(@PathParam(value="auditId") @Parameter(description="auditId") Long auditId, @QueryParam(value="command") @Parameter(description="command") String commandParam) {
        CommandProcessingResult result = null;
        if (this.is(commandParam, COMMAND_APPROVE)) {
            result = this.writePlatformService.approveEntry(auditId);
        } else if (this.is(commandParam, COMMAND_REJECT)) {
            Long id = this.writePlatformService.rejectEntry(auditId);
            result = CommandProcessingResult.commandOnlyResult((Long)id);
        } else {
            throw new UnrecognizedQueryParamException("command", commandParam, new Object[0]);
        }
        return result;
    }

    private boolean is(String commandParam, String commandValue) {
        return StringUtils.isNotBlank((CharSequence)commandParam) && commandParam.trim().equalsIgnoreCase(commandValue);
    }

    @DELETE
    @Path(value="{auditId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete Maker Checker Entry")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=MakercheckersApiResourceSwagger.PostMakerCheckersResponse.class))})})
    public CommandProcessingResult deleteMakerCheckerEntry(@PathParam(value="auditId") @Parameter(description="auditId") Long auditId) {
        Long id = this.writePlatformService.deleteEntry(auditId);
        return CommandProcessingResult.commandOnlyResult((Long)id);
    }

    private SQLBuilder getExtraCriteria(MakerCheckerRequest makerCheckerRequest) {
        SQLBuilder extraCriteria = new SQLBuilder();
        extraCriteria.addNonNullCriteria("aud.action_name = ", (Object)makerCheckerRequest.getActionName());
        if (makerCheckerRequest.getEntityName() != null) {
            extraCriteria.addCriteria("aud.entity_name like ", (Object)(makerCheckerRequest.getEntityName() + "%"));
        }
        extraCriteria.addNonNullCriteria("aud.resource_id = ", (Object)makerCheckerRequest.getResourceId());
        extraCriteria.addNonNullCriteria("aud.maker_id = ", (Object)makerCheckerRequest.getMakerId());
        extraCriteria.addNonNullCriteria("aud.made_on_date >= ", (Object)makerCheckerRequest.getMakerDateTimeFrom());
        extraCriteria.addNonNullCriteria("aud.made_on_date <= ", (Object)makerCheckerRequest.getMakerDateTimeTo());
        extraCriteria.addNonNullCriteria("aud.office_id = ", (Object)makerCheckerRequest.getOfficeId());
        extraCriteria.addNonNullCriteria("aud.group_id = ", (Object)makerCheckerRequest.getGroupId());
        extraCriteria.addNonNullCriteria("aud.client_id = ", (Object)makerCheckerRequest.getClientId());
        extraCriteria.addNonNullCriteria("aud.loan_id = ", (Object)makerCheckerRequest.getLoanId());
        extraCriteria.addNonNullCriteria("aud.savings_account_id = ", (Object)makerCheckerRequest.getSavingsAccountId());
        return extraCriteria;
    }

    @Generated
    public MakercheckersApiResource(AuditReadPlatformService readPlatformService, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService writePlatformService) {
        this.readPlatformService = readPlatformService;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.writePlatformService = writePlatformService;
    }
}

