/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.loan;

import org.apache.fineract.cob.COBBusinessStepService;
import org.apache.fineract.cob.common.CustomJobParameterResolver;
import org.apache.fineract.cob.common.InitialisationTasklet;
import org.apache.fineract.cob.common.ResetContextTasklet;
import org.apache.fineract.cob.conditions.BatchWorkerCondition;
import org.apache.fineract.cob.listener.ChunkProcessingLoanItemListener;
import org.apache.fineract.cob.loan.ApplyLoanLockTasklet;
import org.apache.fineract.cob.loan.ContextAwareTaskDecorator;
import org.apache.fineract.cob.loan.LoanItemProcessor;
import org.apache.fineract.cob.loan.LoanItemReader;
import org.apache.fineract.cob.loan.LoanItemWriter;
import org.apache.fineract.cob.loan.LoanLockingService;
import org.apache.fineract.cob.loan.RetrieveLoanIdService;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.jobs.service.JobName;
import org.apache.fineract.infrastructure.springbatch.PropertyService;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepository;
import org.apache.fineract.useradministration.domain.AppUserRepositoryWrapper;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.core.job.builder.FlowBuilder;
import org.springframework.batch.core.job.flow.Flow;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.builder.SimpleStepBuilder;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.integration.partition.RemotePartitioningWorkerStepBuilderFactory;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskDecorator;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.repository.CrudRepository;
import org.springframework.integration.channel.QueueChannel;
import org.springframework.messaging.MessageChannel;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Configuration
@Conditional(value={BatchWorkerCondition.class})
public class LoanCOBWorkerConfiguration {
    @Autowired
    private JobRepository jobRepository;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private RemotePartitioningWorkerStepBuilderFactory stepBuilderFactory;
    @Autowired
    private PropertyService propertyService;
    @Autowired
    private LoanRepository loanRepository;
    @Autowired
    private QueueChannel inboundRequests;
    @Autowired
    private COBBusinessStepService cobBusinessStepService;
    @Autowired
    private AppUserRepositoryWrapper userRepository;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private RetrieveLoanIdService retrieveLoanIdService;
    @Autowired
    private FineractProperties fineractProperties;
    @Autowired
    private LoanLockingService loanLockingService;
    @Autowired
    private CustomJobParameterResolver customJobParameterResolver;

    @Bean(name={"loanCOBWorkerStep"})
    public Step loanCOBWorkerStep() {
        return this.stepBuilderFactory.get("Loan COB worker - Step").inputChannel((MessageChannel)this.inboundRequests).flow(this.flow()).build();
    }

    @Bean
    public Flow flow() {
        return (Flow)new FlowBuilder("cobFlow").start(this.initialisationStep(null)).next(this.applyLockStep(null)).next(this.loanBusinessStep(null, null)).next(this.resetContextStep(null)).build();
    }

    @Bean
    @StepScope
    public Step initialisationStep(@Value(value="#{stepExecutionContext['partition']}") String partitionName) {
        return new StepBuilder("Initialisation - Step:" + partitionName, this.jobRepository).tasklet((Tasklet)this.initialiseContext(), this.transactionManager).build();
    }

    @Bean
    public TaskExecutor cobTaskExecutor() {
        if (this.propertyService.getThreadPoolMaxPoolSize("LOAN_COB") == 1) {
            return new SyncTaskExecutor();
        }
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setThreadNamePrefix("COB-Thread-");
        taskExecutor.setThreadGroupName("COB-Thread");
        taskExecutor.setCorePoolSize(this.propertyService.getThreadPoolCorePoolSize(JobName.LOAN_COB.name()).intValue());
        taskExecutor.setMaxPoolSize(this.propertyService.getThreadPoolMaxPoolSize(JobName.LOAN_COB.name()).intValue());
        taskExecutor.setQueueCapacity(this.propertyService.getThreadPoolQueueCapacity(JobName.LOAN_COB.name()).intValue());
        taskExecutor.setAllowCoreThreadTimeOut(true);
        taskExecutor.setTaskDecorator((TaskDecorator)new ContextAwareTaskDecorator());
        return taskExecutor;
    }

    @Bean
    @StepScope
    public Step loanBusinessStep(@Value(value="#{stepExecutionContext['partition']}") String partitionName, TaskExecutor cobTaskExecutor) {
        SimpleStepBuilder stepBuilder = (SimpleStepBuilder)new StepBuilder("Loan Business - Step:" + partitionName, this.jobRepository).chunk(this.propertyService.getChunkSize(JobName.LOAN_COB.name()).intValue(), this.transactionManager).reader((ItemReader)this.cobWorkerItemReader()).processor((ItemProcessor)this.cobWorkerItemProcessor()).writer((ItemWriter)this.cobWorkerItemWriter()).faultTolerant().retry(Exception.class).retryLimit(this.propertyService.getRetryLimit("LOAN_COB").intValue()).skip(Exception.class).skipLimit(this.propertyService.getChunkSize("LOAN_COB") + 1).listener((Object)this.loanItemListener()).transactionManager(this.transactionManager);
        if (this.propertyService.getThreadPoolMaxPoolSize("LOAN_COB") > 1) {
            stepBuilder.taskExecutor(cobTaskExecutor);
        }
        return stepBuilder.build();
    }

    @Bean
    @StepScope
    public Step applyLockStep(@Value(value="#{stepExecutionContext['partition']}") String partitionName) {
        return new StepBuilder("Apply lock - Step:" + partitionName, this.jobRepository).tasklet((Tasklet)this.applyLock(), this.transactionManager).build();
    }

    @Bean
    @StepScope
    public Step resetContextStep(@Value(value="#{stepExecutionContext['partition']}") String partitionName) {
        return new StepBuilder("Reset context - Step:" + partitionName, this.jobRepository).tasklet((Tasklet)this.resetContext(), this.transactionManager).build();
    }

    @Bean
    public InitialisationTasklet initialiseContext() {
        return new InitialisationTasklet(this.userRepository);
    }

    @Bean
    public ChunkProcessingLoanItemListener loanItemListener() {
        return new ChunkProcessingLoanItemListener(this.loanLockingService, this.transactionTemplate);
    }

    @Bean
    public ApplyLoanLockTasklet applyLock() {
        return new ApplyLoanLockTasklet(this.fineractProperties, this.loanLockingService, this.retrieveLoanIdService, this.customJobParameterResolver, this.transactionTemplate);
    }

    @Bean
    public ResetContextTasklet resetContext() {
        return new ResetContextTasklet();
    }

    @Bean
    @StepScope
    public LoanItemReader cobWorkerItemReader() {
        return new LoanItemReader(this.loanRepository, this.retrieveLoanIdService, this.customJobParameterResolver, this.loanLockingService);
    }

    @Bean
    @StepScope
    public LoanItemProcessor cobWorkerItemProcessor() {
        return new LoanItemProcessor(this.cobBusinessStepService);
    }

    @Bean
    @StepScope
    public LoanItemWriter cobWorkerItemWriter() {
        LoanItemWriter repositoryItemWriter = new LoanItemWriter(this.loanLockingService);
        repositoryItemWriter.setRepository((CrudRepository)this.loanRepository);
        return repositoryItemWriter;
    }
}

