/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.storage;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import javax.inject.Inject;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.metadata.MetadataStorageConnector;
import org.apache.druid.metadata.MetadataStorageConnectorConfig;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;

public class MetadataStorageManager {
    private final ObjectMapper jsonMapper;
    private final MetadataStorageConnector connector;
    private final MetadataStorageConnectorConfig config;
    private final MetadataStorageTablesConfig tablesConfig;

    @Inject
    public MetadataStorageManager(@Json ObjectMapper jsonMapper, MetadataStorageConnector connector, Supplier<MetadataStorageConnectorConfig> configSupplier, Supplier<MetadataStorageTablesConfig> tablesConfigSupplier) {
        this.jsonMapper = jsonMapper;
        this.connector = connector;
        this.config = (MetadataStorageConnectorConfig)configSupplier.get();
        this.tablesConfig = (MetadataStorageTablesConfig)tablesConfigSupplier.get();
    }

    public MetadataStorageConnectorConfig config() {
        return this.config;
    }

    public MetadataStorageTablesConfig tablesConfig() {
        return this.tablesConfig;
    }

    public ObjectMapper jsonMapper() {
        return this.jsonMapper;
    }

    public boolean isSql() {
        return this.connector instanceof SQLMetadataConnector;
    }

    public SQLMetadataConnector sqlConnector() {
        return (SQLMetadataConnector)this.connector;
    }
}

