/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1Endpoint;
import io.kubernetes.client.openapi.models.V1EndpointConditions;
import io.kubernetes.client.openapi.models.V1EndpointConditionsBuilder;
import io.kubernetes.client.openapi.models.V1EndpointConditionsFluentImpl;
import io.kubernetes.client.openapi.models.V1EndpointFluent;
import io.kubernetes.client.openapi.models.V1EndpointHints;
import io.kubernetes.client.openapi.models.V1EndpointHintsBuilder;
import io.kubernetes.client.openapi.models.V1EndpointHintsFluentImpl;
import io.kubernetes.client.openapi.models.V1ObjectReference;
import io.kubernetes.client.openapi.models.V1ObjectReferenceBuilder;
import io.kubernetes.client.openapi.models.V1ObjectReferenceFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class V1EndpointFluentImpl<A extends V1EndpointFluent<A>>
extends BaseFluent<A>
implements V1EndpointFluent<A> {
    private List<String> addresses;
    private V1EndpointConditionsBuilder conditions;
    private Map<String, String> deprecatedTopology;
    private V1EndpointHintsBuilder hints;
    private String hostname;
    private String nodeName;
    private V1ObjectReferenceBuilder targetRef;
    private String zone;

    public V1EndpointFluentImpl() {
    }

    public V1EndpointFluentImpl(V1Endpoint instance) {
        if (instance != null) {
            this.withAddresses(instance.getAddresses());
            this.withConditions(instance.getConditions());
            this.withDeprecatedTopology(instance.getDeprecatedTopology());
            this.withHints(instance.getHints());
            this.withHostname(instance.getHostname());
            this.withNodeName(instance.getNodeName());
            this.withTargetRef(instance.getTargetRef());
            this.withZone(instance.getZone());
        }
    }

    @Override
    public A addToAddresses(int index, String item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        this.addresses.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAddresses(int index, String item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        this.addresses.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAddresses(String ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.addresses.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAddresses(Collection<String> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.addresses.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAddresses(String ... items) {
        for (String item : items) {
            if (this.addresses == null) continue;
            this.addresses.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAddresses(Collection<String> items) {
        for (String item : items) {
            if (this.addresses == null) continue;
            this.addresses.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAddresses() {
        return this.addresses;
    }

    @Override
    public String getAddress(int index) {
        return this.addresses.get(index);
    }

    @Override
    public String getFirstAddress() {
        return this.addresses.get(0);
    }

    @Override
    public String getLastAddress() {
        return this.addresses.get(this.addresses.size() - 1);
    }

    @Override
    public String getMatchingAddress(Predicate<String> predicate) {
        for (String item : this.addresses) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAddress(Predicate<String> predicate) {
        for (String item : this.addresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAddresses(List<String> addresses) {
        if (addresses != null) {
            this.addresses = new ArrayList<String>();
            for (String item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)this;
    }

    @Override
    public A withAddresses(String ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
            this._visitables.remove("addresses");
        }
        if (addresses != null) {
            for (String item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    @Override
    @Deprecated
    public V1EndpointConditions getConditions() {
        return this.conditions != null ? this.conditions.build() : null;
    }

    @Override
    public V1EndpointConditions buildConditions() {
        return this.conditions != null ? this.conditions.build() : null;
    }

    @Override
    public A withConditions(V1EndpointConditions conditions) {
        this._visitables.get("conditions").remove(this.conditions);
        if (conditions != null) {
            this.conditions = new V1EndpointConditionsBuilder(conditions);
            this._visitables.get("conditions").add(this.conditions);
        } else {
            this.conditions = null;
            this._visitables.get("conditions").remove(this.conditions);
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null;
    }

    @Override
    public V1EndpointFluent.ConditionsNested<A> withNewConditions() {
        return new ConditionsNestedImpl();
    }

    @Override
    public V1EndpointFluent.ConditionsNested<A> withNewConditionsLike(V1EndpointConditions item) {
        return new ConditionsNestedImpl(item);
    }

    @Override
    public V1EndpointFluent.ConditionsNested<A> editConditions() {
        return this.withNewConditionsLike(this.getConditions());
    }

    @Override
    public V1EndpointFluent.ConditionsNested<A> editOrNewConditions() {
        return this.withNewConditionsLike(this.getConditions() != null ? this.getConditions() : new V1EndpointConditionsBuilder().build());
    }

    @Override
    public V1EndpointFluent.ConditionsNested<A> editOrNewConditionsLike(V1EndpointConditions item) {
        return this.withNewConditionsLike(this.getConditions() != null ? this.getConditions() : item);
    }

    @Override
    public A addToDeprecatedTopology(String key, String value) {
        if (this.deprecatedTopology == null && key != null && value != null) {
            this.deprecatedTopology = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.deprecatedTopology.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToDeprecatedTopology(Map<String, String> map) {
        if (this.deprecatedTopology == null && map != null) {
            this.deprecatedTopology = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.deprecatedTopology.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromDeprecatedTopology(String key) {
        if (this.deprecatedTopology == null) {
            return (A)this;
        }
        if (key != null && this.deprecatedTopology != null) {
            this.deprecatedTopology.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromDeprecatedTopology(Map<String, String> map) {
        if (this.deprecatedTopology == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.deprecatedTopology == null) continue;
                this.deprecatedTopology.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getDeprecatedTopology() {
        return this.deprecatedTopology;
    }

    @Override
    public <K, V> A withDeprecatedTopology(Map<String, String> deprecatedTopology) {
        this.deprecatedTopology = deprecatedTopology == null ? null : new LinkedHashMap<String, String>(deprecatedTopology);
        return (A)this;
    }

    @Override
    public Boolean hasDeprecatedTopology() {
        return this.deprecatedTopology != null;
    }

    @Override
    @Deprecated
    public V1EndpointHints getHints() {
        return this.hints != null ? this.hints.build() : null;
    }

    @Override
    public V1EndpointHints buildHints() {
        return this.hints != null ? this.hints.build() : null;
    }

    @Override
    public A withHints(V1EndpointHints hints) {
        this._visitables.get("hints").remove(this.hints);
        if (hints != null) {
            this.hints = new V1EndpointHintsBuilder(hints);
            this._visitables.get("hints").add(this.hints);
        } else {
            this.hints = null;
            this._visitables.get("hints").remove(this.hints);
        }
        return (A)this;
    }

    @Override
    public Boolean hasHints() {
        return this.hints != null;
    }

    @Override
    public V1EndpointFluent.HintsNested<A> withNewHints() {
        return new HintsNestedImpl();
    }

    @Override
    public V1EndpointFluent.HintsNested<A> withNewHintsLike(V1EndpointHints item) {
        return new HintsNestedImpl(item);
    }

    @Override
    public V1EndpointFluent.HintsNested<A> editHints() {
        return this.withNewHintsLike(this.getHints());
    }

    @Override
    public V1EndpointFluent.HintsNested<A> editOrNewHints() {
        return this.withNewHintsLike(this.getHints() != null ? this.getHints() : new V1EndpointHintsBuilder().build());
    }

    @Override
    public V1EndpointFluent.HintsNested<A> editOrNewHintsLike(V1EndpointHints item) {
        return this.withNewHintsLike(this.getHints() != null ? this.getHints() : item);
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)this;
    }

    @Override
    public Boolean hasHostname() {
        return this.hostname != null;
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public A withNodeName(String nodeName) {
        this.nodeName = nodeName;
        return (A)this;
    }

    @Override
    public Boolean hasNodeName() {
        return this.nodeName != null;
    }

    @Override
    @Deprecated
    public V1ObjectReference getTargetRef() {
        return this.targetRef != null ? this.targetRef.build() : null;
    }

    @Override
    public V1ObjectReference buildTargetRef() {
        return this.targetRef != null ? this.targetRef.build() : null;
    }

    @Override
    public A withTargetRef(V1ObjectReference targetRef) {
        this._visitables.get("targetRef").remove(this.targetRef);
        if (targetRef != null) {
            this.targetRef = new V1ObjectReferenceBuilder(targetRef);
            this._visitables.get("targetRef").add(this.targetRef);
        } else {
            this.targetRef = null;
            this._visitables.get("targetRef").remove(this.targetRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTargetRef() {
        return this.targetRef != null;
    }

    @Override
    public V1EndpointFluent.TargetRefNested<A> withNewTargetRef() {
        return new TargetRefNestedImpl();
    }

    @Override
    public V1EndpointFluent.TargetRefNested<A> withNewTargetRefLike(V1ObjectReference item) {
        return new TargetRefNestedImpl(item);
    }

    @Override
    public V1EndpointFluent.TargetRefNested<A> editTargetRef() {
        return this.withNewTargetRefLike(this.getTargetRef());
    }

    @Override
    public V1EndpointFluent.TargetRefNested<A> editOrNewTargetRef() {
        return this.withNewTargetRefLike(this.getTargetRef() != null ? this.getTargetRef() : new V1ObjectReferenceBuilder().build());
    }

    @Override
    public V1EndpointFluent.TargetRefNested<A> editOrNewTargetRefLike(V1ObjectReference item) {
        return this.withNewTargetRefLike(this.getTargetRef() != null ? this.getTargetRef() : item);
    }

    @Override
    public String getZone() {
        return this.zone;
    }

    @Override
    public A withZone(String zone) {
        this.zone = zone;
        return (A)this;
    }

    @Override
    public Boolean hasZone() {
        return this.zone != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1EndpointFluentImpl that = (V1EndpointFluentImpl)o;
        if (!Objects.equals(this.addresses, that.addresses)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.deprecatedTopology, that.deprecatedTopology)) {
            return false;
        }
        if (!Objects.equals(this.hints, that.hints)) {
            return false;
        }
        if (!Objects.equals(this.hostname, that.hostname)) {
            return false;
        }
        if (!Objects.equals(this.nodeName, that.nodeName)) {
            return false;
        }
        if (!Objects.equals(this.targetRef, that.targetRef)) {
            return false;
        }
        return Objects.equals(this.zone, that.zone);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.addresses, this.conditions, this.deprecatedTopology, this.hints, this.hostname, this.nodeName, this.targetRef, this.zone, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.addresses != null && !this.addresses.isEmpty()) {
            sb.append("addresses:");
            sb.append(this.addresses + ",");
        }
        if (this.conditions != null) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.deprecatedTopology != null && !this.deprecatedTopology.isEmpty()) {
            sb.append("deprecatedTopology:");
            sb.append(this.deprecatedTopology + ",");
        }
        if (this.hints != null) {
            sb.append("hints:");
            sb.append(this.hints + ",");
        }
        if (this.hostname != null) {
            sb.append("hostname:");
            sb.append(this.hostname + ",");
        }
        if (this.nodeName != null) {
            sb.append("nodeName:");
            sb.append(this.nodeName + ",");
        }
        if (this.targetRef != null) {
            sb.append("targetRef:");
            sb.append(this.targetRef + ",");
        }
        if (this.zone != null) {
            sb.append("zone:");
            sb.append(this.zone);
        }
        sb.append("}");
        return sb.toString();
    }

    class ConditionsNestedImpl<N>
    extends V1EndpointConditionsFluentImpl<V1EndpointFluent.ConditionsNested<N>>
    implements V1EndpointFluent.ConditionsNested<N>,
    Nested<N> {
        V1EndpointConditionsBuilder builder;

        ConditionsNestedImpl(V1EndpointConditions item) {
            this.builder = new V1EndpointConditionsBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.builder = new V1EndpointConditionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1EndpointFluentImpl.this.withConditions(this.builder.build());
        }

        @Override
        public N endConditions() {
            return this.and();
        }
    }

    class HintsNestedImpl<N>
    extends V1EndpointHintsFluentImpl<V1EndpointFluent.HintsNested<N>>
    implements V1EndpointFluent.HintsNested<N>,
    Nested<N> {
        V1EndpointHintsBuilder builder;

        HintsNestedImpl(V1EndpointHints item) {
            this.builder = new V1EndpointHintsBuilder(this, item);
        }

        HintsNestedImpl() {
            this.builder = new V1EndpointHintsBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1EndpointFluentImpl.this.withHints(this.builder.build());
        }

        @Override
        public N endHints() {
            return this.and();
        }
    }

    class TargetRefNestedImpl<N>
    extends V1ObjectReferenceFluentImpl<V1EndpointFluent.TargetRefNested<N>>
    implements V1EndpointFluent.TargetRefNested<N>,
    Nested<N> {
        V1ObjectReferenceBuilder builder;

        TargetRefNestedImpl(V1ObjectReference item) {
            this.builder = new V1ObjectReferenceBuilder(this, item);
        }

        TargetRefNestedImpl() {
            this.builder = new V1ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1EndpointFluentImpl.this.withTargetRef(this.builder.build());
        }

        @Override
        public N endTargetRef() {
            return this.and();
        }
    }
}

