/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

public class VersionUtil {
    static final int DEFAULT_GUESS = 8;

    public static int getJavaMajorVersion() {
        String javaVersionString = System.getProperty("java.version");
        System.out.println("javaVersionString=" + javaVersionString);
        return VersionUtil.getJavaMajorVersion(javaVersionString);
    }

    public static int getJavaMajorVersion(String versionString) {
        if (versionString == null) {
            return 8;
        }
        if (versionString.startsWith("1.")) {
            return versionString.charAt(2) - 48;
        }
        String firstDigits = VersionUtil.extractFirstDigits(versionString);
        try {
            return Integer.parseInt(firstDigits);
        }
        catch (NumberFormatException e) {
            return 8;
        }
    }

    private static String extractFirstDigits(String versionString) {
        StringBuffer buf = new StringBuffer();
        for (char c : versionString.toCharArray()) {
            if (!Character.isDigit(c)) break;
            buf.append(c);
        }
        return buf.toString();
    }
}

