/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.web;

import org.apache.unomi.api.services.ConfigSharingService;
import org.apache.unomi.web.WebConfig;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={WebConfig.class}, immediate=true, configurationPid={"org.apache.unomi.web"})
@Designate(ocd=Config.class)
public class WebConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)WebConfig.class.getName());
    private String contextserverDomain;
    private String contexserverProfileIdCookieName;
    private int contextserverProfileIdCookieMaxAgeInSeconds;
    private boolean contextserverProfileIdCookieHttpOnly;
    private String[] allowedProfileDownloadFormats;
    private int publicPostRequestBytesLimit;
    @Reference
    private ConfigSharingService configSharingService;

    public WebConfig() {
        LOGGER.info("WebConfig created.");
    }

    @Activate
    public void activate(Config config) {
        this.contextserverDomain = config.contextserver_domain();
        this.contexserverProfileIdCookieName = config.contexserver_profileIdCookieName();
        this.contextserverProfileIdCookieMaxAgeInSeconds = config.contextserver_profileIdCookieMaxAgeInSeconds();
        this.contextserverProfileIdCookieHttpOnly = config.contextserver_profileIdCookieHttpOnly();
        this.allowedProfileDownloadFormats = config.allowed_profile_download_formats();
        this.publicPostRequestBytesLimit = config.public_post_request_bytes_limit();
        this.configSharingService.setProperty("profileIdCookieName", (Object)this.contexserverProfileIdCookieName);
        this.configSharingService.setProperty("profileIdCookieDomain", (Object)this.contextserverDomain);
        this.configSharingService.setProperty("profileIdCookieMaxAgeInSeconds", (Object)this.contextserverProfileIdCookieMaxAgeInSeconds);
        this.configSharingService.setProperty("profileIdCookieHttpOnly", (Object)this.contextserverProfileIdCookieHttpOnly);
        this.configSharingService.setProperty("publicPostRequestBytesLimit", (Object)this.publicPostRequestBytesLimit);
        this.configSharingService.setProperty("allowedProfileDownloadFormats", (Object)this.allowedProfileDownloadFormats);
        LOGGER.info("WebConfig activated.");
    }

    public String getContextserverDomain() {
        return this.contextserverDomain;
    }

    public String getContexserverProfileIdCookieName() {
        return this.contexserverProfileIdCookieName;
    }

    public int getContextserverProfileIdCookieMaxAgeInSeconds() {
        return this.contextserverProfileIdCookieMaxAgeInSeconds;
    }

    public boolean isContextserverProfileIdCookieHttpOnly() {
        return this.contextserverProfileIdCookieHttpOnly;
    }

    public String[] getAllowedProfileDownloadFormats() {
        return this.allowedProfileDownloadFormats;
    }

    public int getPublicPostRequestBytesLimit() {
        return this.publicPostRequestBytesLimit;
    }
}

