/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.encoding;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.encoding.StreamDecoder;
import com.linecorp.armeria.client.encoding.StreamDecoderFactory;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.common.encoding.AbstractHttpDecodedResponse;
import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import com.linecorp.armeria.internal.shaded.guava.primitives.Ints;
import java.io.UnsupportedEncodingException;
import java.util.Map;

public final class DefaultHttpDecodedResponse
extends AbstractHttpDecodedResponse {
    private final Map<String, StreamDecoderFactory> availableDecoders;
    private final ClientRequestContext ctx;
    private final boolean strictContentEncoding;
    @Nullable
    private StreamDecoder decoder;
    private boolean headersReceived;

    public DefaultHttpDecodedResponse(HttpResponse delegate, Map<String, StreamDecoderFactory> availableDecoders, ClientRequestContext ctx, boolean strictContentEncoding) {
        super(delegate);
        this.availableDecoders = availableDecoders;
        this.ctx = ctx;
        this.strictContentEncoding = strictContentEncoding;
    }

    @Override
    protected HttpObject filter(HttpObject obj) {
        if (obj instanceof HttpHeaders) {
            HttpHeaders headers = (HttpHeaders)obj;
            String status = headers.get((CharSequence)HttpHeaderNames.STATUS);
            if (ArmeriaHttpUtil.isInformational(status)) {
                return obj;
            }
            if (this.headersReceived) {
                return obj;
            }
            if (status == null) {
                return obj;
            }
            this.headersReceived = true;
            String contentEncoding = headers.get((CharSequence)HttpHeaderNames.CONTENT_ENCODING);
            if (contentEncoding != null) {
                StreamDecoderFactory decoderFactory = this.availableDecoders.get(Ascii.toLowerCase(contentEncoding));
                if (decoderFactory != null) {
                    this.decoder = decoderFactory.newDecoder(this.ctx.alloc(), Ints.saturatedCast(this.ctx.maxResponseLength()));
                } else if (this.strictContentEncoding) {
                    Exceptions.throwUnsafely(new UnsupportedEncodingException("encoding: " + contentEncoding));
                }
            }
            if (this.decoder != null) {
                return headers.toBuilder().removeAndThen((CharSequence)HttpHeaderNames.CONTENT_ENCODING).removeAndThen((CharSequence)HttpHeaderNames.CONTENT_LENGTH).build();
            }
            return headers;
        }
        assert (obj instanceof HttpData);
        return this.decoder != null ? this.decoder.decode((HttpData)obj) : obj;
    }

    @Override
    @Nullable
    StreamDecoder decoder() {
        return this.decoder;
    }
}

