/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.StringMultimapGetters;
import com.linecorp.armeria.common.StringValueConverter;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.util.StringUtil;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.collect.Iterators;
import io.netty.handler.codec.DateFormatter;
import io.netty.util.AsciiString;
import io.netty.util.internal.MathUtil;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;

abstract class StringMultimap<IN_NAME extends CharSequence, NAME extends IN_NAME>
implements StringMultimapGetters<IN_NAME, NAME> {
    static final int DEFAULT_SIZE_HINT = 16;
    static final int HASH_CODE_SEED = -1028477387;
    final Entry[] entries;
    private final byte hashMask;
    private final Entry firstGroupHead;
    private Entry secondGroupHead;
    int size;

    StringMultimap(int sizeHint) {
        Entry[] newEntries = (Entry[])Array.newInstance(Entry.class, MathUtil.findNextPositivePowerOfTwo((int)Math.max(2, Math.min(sizeHint, 128))));
        this.entries = newEntries;
        this.hashMask = (byte)(this.entries.length - 1);
        this.firstGroupHead = this.secondGroupHead = new Entry();
    }

    StringMultimap(StringMultimap<IN_NAME, NAME> parent, boolean shallowCopy) {
        this.hashMask = parent.hashMask;
        if (shallowCopy) {
            this.entries = parent.entries;
            this.firstGroupHead = parent.firstGroupHead;
            this.secondGroupHead = parent.secondGroupHead;
            this.size = parent.size;
        } else {
            Entry[] newEntries = (Entry[])Array.newInstance(Entry.class, parent.entries.length);
            this.entries = newEntries;
            this.firstGroupHead = this.secondGroupHead = new Entry();
            boolean succeeded = this.addFast(parent);
            assert (succeeded);
        }
    }

    StringMultimap(StringMultimapGetters<IN_NAME, NAME> parent) {
        this(parent.size());
        assert (!(parent instanceof StringMultimap));
        super.addSlow(parent);
    }

    abstract int hashName(IN_NAME var1);

    abstract boolean nameEquals(NAME var1, IN_NAME var2);

    abstract boolean isFirstGroup(NAME var1);

    abstract NAME normalizeName(IN_NAME var1);

    abstract void validateValue(String var1);

    @Override
    @Nullable
    public final String get(IN_NAME name) {
        Objects.requireNonNull(name, "name");
        int h = this.hashName(name);
        int i = this.index(h);
        Entry e = this.entries[i];
        String value = null;
        while (e != null) {
            Object currentName;
            if (e.hash == h && (currentName = e.key) != null && this.nameEquals(currentName, name)) {
                value = e.value;
            }
            e = e.next;
        }
        return value;
    }

    @Override
    public final String get(IN_NAME name, String defaultValue) {
        Objects.requireNonNull(defaultValue, "defaultValue");
        String value = this.get(name);
        return value != null ? value : defaultValue;
    }

    @Override
    @Nullable
    public String getLast(IN_NAME name) {
        Objects.requireNonNull(name, "name");
        int h = this.hashName(name);
        int i = this.index(h);
        Entry e = this.entries[i];
        while (e != null) {
            Object currentName;
            if (e.hash == h && (currentName = e.key) != null && this.nameEquals(currentName, name)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public final String getLast(IN_NAME name, String defaultValue) {
        Objects.requireNonNull(defaultValue, "defaultValue");
        String value = this.getLast(name);
        return value != null ? value : defaultValue;
    }

    @Override
    public final List<String> getAll(IN_NAME name) {
        Objects.requireNonNull(name, "name");
        return this.getAllReversed(name).reverse();
    }

    private ImmutableList<String> getAllReversed(IN_NAME name) {
        int h = this.hashName(name);
        int i = this.index(h);
        Entry e = this.entries[i];
        if (e == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        do {
            Object currentName;
            if (e.hash != h || (currentName = e.key) == null || !this.nameEquals(currentName, name)) continue;
            builder.add(e.getValue());
        } while ((e = e.next) != null);
        return builder.build();
    }

    @Override
    @Nullable
    public Boolean getBoolean(IN_NAME name) {
        String v = this.get(name);
        if (v == null) {
            return null;
        }
        return StringUtil.toBooleanOrNull(v);
    }

    @Override
    public boolean getBoolean(IN_NAME name, boolean defaultValue) {
        Boolean v = this.getBoolean(name);
        return v != null ? v : defaultValue;
    }

    @Override
    @Nullable
    public Boolean getLastBoolean(IN_NAME name) {
        String v = this.getLast(name);
        if (v == null) {
            return null;
        }
        return StringUtil.toBooleanOrNull(v);
    }

    @Override
    public boolean getLastBoolean(IN_NAME name, boolean defaultValue) {
        Boolean v = this.getLastBoolean(name);
        return v != null ? v : defaultValue;
    }

    @Override
    @Nullable
    public final Integer getInt(IN_NAME name) {
        String v = this.get(name);
        return StringMultimap.toInteger(v);
    }

    @Override
    public final int getInt(IN_NAME name, int defaultValue) {
        Integer v = this.getInt(name);
        return v != null ? v : defaultValue;
    }

    @Override
    @Nullable
    public final Integer getLastInt(IN_NAME name) {
        String v = this.getLast(name);
        return StringMultimap.toInteger(v);
    }

    @Override
    public final int getLastInt(IN_NAME name, int defaultValue) {
        Integer v = this.getLastInt(name);
        return v != null ? v : defaultValue;
    }

    @Override
    @Nullable
    public final Long getLong(IN_NAME name) {
        String v = this.get(name);
        return StringMultimap.toLong(v);
    }

    @Override
    public final long getLong(IN_NAME name, long defaultValue) {
        Long v = this.getLong(name);
        return v != null ? v : defaultValue;
    }

    @Override
    @Nullable
    public final Long getLastLong(IN_NAME name) {
        String v = this.getLast(name);
        return StringMultimap.toLong(v);
    }

    @Override
    public final long getLastLong(IN_NAME name, long defaultValue) {
        Long v = this.getLastLong(name);
        return v != null ? v : defaultValue;
    }

    @Override
    @Nullable
    public final Float getFloat(IN_NAME name) {
        String v = this.get(name);
        return StringMultimap.toFloat(v);
    }

    @Override
    public final float getFloat(IN_NAME name, float defaultValue) {
        Float v = this.getFloat(name);
        return v != null ? v.floatValue() : defaultValue;
    }

    @Override
    @Nullable
    public final Float getLastFloat(IN_NAME name) {
        String v = this.getLast(name);
        return StringMultimap.toFloat(v);
    }

    @Override
    public final float getLastFloat(IN_NAME name, float defaultValue) {
        Float v = this.getLastFloat(name);
        return v != null ? v.floatValue() : defaultValue;
    }

    @Override
    @Nullable
    public final Double getDouble(IN_NAME name) {
        String v = this.get(name);
        return StringMultimap.toDouble(v);
    }

    @Override
    public final double getDouble(IN_NAME name, double defaultValue) {
        Double v = this.getDouble(name);
        return v != null ? v : defaultValue;
    }

    @Override
    @Nullable
    public final Double getLastDouble(IN_NAME name) {
        String v = this.getLast(name);
        return StringMultimap.toDouble(v);
    }

    @Override
    public final double getLastDouble(IN_NAME name, double defaultValue) {
        Double v = this.getLastDouble(name);
        return v != null ? v : defaultValue;
    }

    @Override
    @Nullable
    public final Long getTimeMillis(IN_NAME name) {
        String v = this.get(name);
        return StringMultimap.toTimeMillis(v);
    }

    @Override
    public final long getTimeMillis(IN_NAME name, long defaultValue) {
        Long v = this.getTimeMillis(name);
        return v != null ? v : defaultValue;
    }

    @Override
    @Nullable
    public final Long getLastTimeMillis(IN_NAME name) {
        String v = this.getLast(name);
        return StringMultimap.toTimeMillis(v);
    }

    @Override
    public final long getLastTimeMillis(IN_NAME name, long defaultValue) {
        Long v = this.getLastTimeMillis(name);
        return v != null ? v : defaultValue;
    }

    @Override
    public final boolean contains(IN_NAME name) {
        Objects.requireNonNull(name, "name");
        int h = this.hashName(name);
        int i = this.index(h);
        Entry e = this.entries[i];
        while (e != null) {
            Object currentName;
            if (e.hash == h && (currentName = e.key) != null && this.nameEquals(currentName, name)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public final boolean contains(IN_NAME name, String value) {
        return this.contains(name, (String actual) -> AsciiString.contentEquals((CharSequence)actual, (CharSequence)value));
    }

    private boolean contains(IN_NAME name, Predicate<String> containsValuePredicate) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(containsValuePredicate, "containsValuePredicate");
        int h = this.hashName(name);
        int i = this.index(h);
        Entry e = this.entries[i];
        while (e != null) {
            Object currentName;
            if (e.hash == h && (currentName = e.key) != null && this.nameEquals(currentName, name) && containsValuePredicate.test(e.value)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public final boolean containsObject(IN_NAME name, Object value) {
        Objects.requireNonNull(value, "value");
        return this.contains(name, StringMultimap.fromObject(value));
    }

    @Override
    public final boolean containsBoolean(IN_NAME name, boolean value) {
        return this.contains(name, (String actual) -> {
            Boolean maybeBoolean = StringUtil.toBooleanOrNull(actual);
            return maybeBoolean != null && maybeBoolean == value;
        });
    }

    @Override
    public final boolean containsInt(IN_NAME name, int value) {
        return this.contains(name, StringUtil.toString(value));
    }

    @Override
    public final boolean containsLong(IN_NAME name, long value) {
        return this.contains(name, StringUtil.toString(value));
    }

    @Override
    public final boolean containsFloat(IN_NAME name, float value) {
        return this.contains(name, String.valueOf(value));
    }

    @Override
    public final boolean containsDouble(IN_NAME name, double value) {
        return this.contains(name, String.valueOf(value));
    }

    @Override
    public final boolean containsTimeMillis(IN_NAME name, long value) {
        return this.contains(name, StringMultimap.fromTimeMillis(value));
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public final Set<NAME> names() {
        if (this.isEmpty()) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Entry e = this.firstGroupHead.after;
        while (e != this.firstGroupHead) {
            builder.add(e.getKey());
            e = e.after;
        }
        return builder.build();
    }

    @Override
    public final Iterator<Map.Entry<NAME, String>> iterator() {
        return new EntryIterator();
    }

    @Override
    public final Iterator<String> valueIterator(IN_NAME name) {
        return this.getAll(name).iterator();
    }

    @Override
    public final void forEach(BiConsumer<NAME, String> action) {
        Objects.requireNonNull(action, "action");
        for (Map.Entry<NAME, String> e : this) {
            action.accept((CharSequence)e.getKey(), e.getValue());
        }
    }

    @Override
    public final void forEachValue(IN_NAME name, Consumer<String> action) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(action, "action");
        Iterator<String> i = this.valueIterator(name);
        while (i.hasNext()) {
            action.accept(i.next());
        }
    }

    @Nullable
    final String getAndRemove(IN_NAME name) {
        Objects.requireNonNull(name, "name");
        int h = this.hashName(name);
        return this.removeAndNotify(h, this.index(h), name, true);
    }

    final String getAndRemove(IN_NAME name, String defaultValue) {
        Objects.requireNonNull(defaultValue, "defaultValue");
        String value = this.getAndRemove(name);
        return value != null ? value : defaultValue;
    }

    final List<String> getAllAndRemove(IN_NAME name) {
        List<String> all = this.getAll(name);
        if (!all.isEmpty()) {
            this.remove(name);
        }
        return all;
    }

    @Nullable
    final Integer getIntAndRemove(IN_NAME name) {
        String v = this.getAndRemove(name);
        return StringMultimap.toInteger(v);
    }

    final int getIntAndRemove(IN_NAME name, int defaultValue) {
        Integer v = this.getIntAndRemove(name);
        return v != null ? v : defaultValue;
    }

    @Nullable
    final Long getLongAndRemove(IN_NAME name) {
        String v = this.getAndRemove(name);
        return StringMultimap.toLong(v);
    }

    final long getLongAndRemove(IN_NAME name, long defaultValue) {
        Long v = this.getLongAndRemove(name);
        return v != null ? v : defaultValue;
    }

    @Nullable
    final Float getFloatAndRemove(IN_NAME name) {
        String v = this.getAndRemove(name);
        return StringMultimap.toFloat(v);
    }

    final float getFloatAndRemove(IN_NAME name, float defaultValue) {
        Float v = this.getFloatAndRemove(name);
        return v != null ? v.floatValue() : defaultValue;
    }

    @Nullable
    final Double getDoubleAndRemove(IN_NAME name) {
        String v = this.getAndRemove(name);
        return StringMultimap.toDouble(v);
    }

    final double getDoubleAndRemove(IN_NAME name, double defaultValue) {
        Double v = this.getDoubleAndRemove(name);
        return v != null ? v : defaultValue;
    }

    @Nullable
    final Long getTimeMillisAndRemove(IN_NAME name) {
        String v = this.getAndRemove(name);
        return StringMultimap.toTimeMillis(v);
    }

    final long getTimeMillisAndRemove(IN_NAME name, long defaultValue) {
        Long v = this.getTimeMillisAndRemove(name);
        return v != null ? v : defaultValue;
    }

    final void add(IN_NAME name, String value) {
        NAME normalizedName = this.normalizeName(name);
        Objects.requireNonNull(value, "value");
        int h = this.hashName(normalizedName);
        int i = this.index(h);
        this.addAndNotify(h, i, normalizedName, value, true);
    }

    final void add(IN_NAME name, Iterable<String> values) {
        this.addAndNotify(name, values, true);
    }

    final void add(IN_NAME name, String ... values) {
        NAME normalizedName = this.normalizeName(name);
        Objects.requireNonNull(values, "values");
        int h = this.hashName(normalizedName);
        int i = this.index(h);
        for (String v : values) {
            StringMultimap.requireNonNullElement(values, v);
            this.addAndNotify(h, i, normalizedName, v, false);
        }
        this.onChange(normalizedName);
    }

    final void add(Iterable<? extends Map.Entry<? extends IN_NAME, String>> entries) {
        if (entries == this) {
            throw new IllegalArgumentException("can't add to itself.");
        }
        if (!this.addFast(entries)) {
            this.addSlow(entries);
        }
    }

    final void addWithoutNotifying(IN_NAME name, Iterable<String> values) {
        this.addAndNotify(name, values, false);
    }

    private void addAndNotify(IN_NAME name, Iterable<String> values, boolean notifyChange) {
        NAME normalizedName = this.normalizeName(name);
        Objects.requireNonNull(values, "values");
        int h = this.hashName(normalizedName);
        int i = this.index(h);
        for (String v : values) {
            StringMultimap.requireNonNullElement(values, v);
            this.addAndNotify(h, i, normalizedName, v, false);
        }
        if (notifyChange) {
            this.onChange(normalizedName);
        }
    }

    private void addAndNotify(int h, int i, NAME name, String value, boolean notifyChange) {
        this.validateValue(value);
        this.entries[i] = new Entry(this, h, name, value, this.entries[i]);
        ++this.size;
        if (notifyChange) {
            this.onChange(name);
        }
    }

    private void addObjectAndNotify(NAME normalizedName, Object value, boolean notifyChange) {
        Objects.requireNonNull(value, "value");
        int h = this.hashName(normalizedName);
        int i = this.index(h);
        this.addAndNotify(h, i, normalizedName, StringMultimap.fromObject(value), notifyChange);
    }

    private void addObjectAndNotify(IN_NAME name, Iterable<?> values, boolean notifyChange) {
        NAME normalizedName = this.normalizeName(name);
        Objects.requireNonNull(values, "values");
        for (Object v : values) {
            StringMultimap.requireNonNullElement(values, v);
            this.addObjectAndNotify(normalizedName, v, false);
        }
        if (notifyChange) {
            this.onChange(normalizedName);
        }
    }

    final void addObjectWithoutNotifying(IN_NAME name, Iterable<?> values) {
        this.addObjectAndNotify(name, values, false);
    }

    final void addObject(IN_NAME name, Object value) {
        NAME normalizedName = this.normalizeName(name);
        Objects.requireNonNull(value, "value");
        this.addObjectAndNotify(normalizedName, value, true);
    }

    final void addObject(IN_NAME name, Iterable<?> values) {
        this.addObjectAndNotify(name, values, true);
    }

    final void addObject(IN_NAME name, Object ... values) {
        NAME normalizedName = this.normalizeName(name);
        Objects.requireNonNull(values, "values");
        for (Object v : values) {
            StringMultimap.requireNonNullElement(values, v);
            this.addObjectAndNotify(normalizedName, v, false);
        }
        this.onChange(normalizedName);
    }

    void addObject(Iterable<? extends Map.Entry<? extends IN_NAME, ?>> entries) {
        if (entries == this) {
            throw new IllegalArgumentException("can't add to itself.");
        }
        if (!this.addFast(entries)) {
            this.addObjectSlow(entries);
        }
    }

    final void addInt(IN_NAME name, int value) {
        this.add(name, StringUtil.toString(value));
    }

    final void addLong(IN_NAME name, long value) {
        this.add(name, StringUtil.toString(value));
    }

    final void addFloat(IN_NAME name, float value) {
        this.add(name, String.valueOf(value));
    }

    final void addDouble(IN_NAME name, double value) {
        this.add(name, String.valueOf(value));
    }

    final void addTimeMillis(IN_NAME name, long value) {
        this.add(name, StringMultimap.fromTimeMillis(value));
    }

    final void set(IN_NAME name, String value) {
        this.setAndNotify(name, value, true);
    }

    final void set(IN_NAME name, Iterable<String> values) {
        NAME normalizedName = this.normalizeName(name);
        Objects.requireNonNull(values, "values");
        int h = this.hashName(normalizedName);
        int i = this.index(h);
        this.removeAndNotify(h, i, normalizedName, true);
        for (String v : values) {
            StringMultimap.requireNonNullElement(values, v);
            this.addAndNotify(h, i, normalizedName, v, false);
        }
    }

    final void set(IN_NAME name, String ... values) {
        NAME normalizedName = this.normalizeName(name);
        Objects.requireNonNull(values, "values");
        int h = this.hashName(normalizedName);
        int i = this.index(h);
        this.removeAndNotify(h, i, normalizedName, true);
        for (String v : values) {
            StringMultimap.requireNonNullElement(values, v);
            this.addAndNotify(h, i, normalizedName, v, false);
        }
    }

    final void set(Iterable<? extends Map.Entry<? extends IN_NAME, String>> entries) {
        Objects.requireNonNull(entries, "entries");
        if (entries == this) {
            return;
        }
        for (Map.Entry<IN_NAME, String> e : entries) {
            this.remove((CharSequence)e.getKey());
        }
        if (!this.addFast(entries)) {
            this.addSlow(entries);
        }
    }

    final void setWithoutNotifying(IN_NAME name, String value) {
        this.setAndNotify(name, value, false);
    }

    private void setAndNotify(IN_NAME name, String value, boolean notifyChange) {
        NAME normalizedName = this.normalizeName(name);
        Objects.requireNonNull(value, "value");
        int h = this.hashName(normalizedName);
        int i = this.index(h);
        this.removeAndNotify(h, i, normalizedName, notifyChange);
        this.addAndNotify(h, i, normalizedName, value, false);
    }

    final StringMultimap<IN_NAME, NAME> setIfAbsent(Iterable<? extends Map.Entry<? extends IN_NAME, String>> entries) {
        Objects.requireNonNull(entries, "entries");
        Set<NAME> existingNames = this.names();
        if (!this.setIfAbsentFast(entries, existingNames)) {
            this.setIfAbsentSlow(entries, existingNames);
        }
        return this;
    }

    void onChange(NAME name) {
    }

    void onClear() {
    }

    private boolean setIfAbsentFast(Iterable<? extends Map.Entry<? extends IN_NAME, String>> entries, Set<NAME> existingNames) {
        if (!(entries instanceof StringMultimap)) {
            return false;
        }
        StringMultimap multimap = (StringMultimap)entries;
        Entry e = multimap.firstGroupHead.after;
        while (e != multimap.firstGroupHead) {
            Object key = e.key;
            String value = e.value;
            assert (key != null);
            assert (value != null);
            if (!existingNames.contains(key)) {
                this.addAndNotify(e.hash, this.index(e.hash), key, value, true);
            }
            e = e.after;
        }
        return true;
    }

    private void setIfAbsentSlow(Iterable<? extends Map.Entry<? extends IN_NAME, String>> entries, Set<NAME> existingNames) {
        for (Map.Entry<IN_NAME, String> e : entries) {
            NAME key = this.normalizeName((CharSequence)e.getKey());
            if (existingNames.contains(key)) continue;
            this.add((IN_NAME)key, e.getValue());
        }
    }

    final void setObject(IN_NAME name, Object value) {
        Objects.requireNonNull(value, "value");
        this.set(name, StringMultimap.fromObject(value));
    }

    final void setObject(IN_NAME name, Iterable<?> values) {
        NAME normalizedName = this.normalizeName(name);
        Objects.requireNonNull(values, "values");
        int h = this.hashName(normalizedName);
        int i = this.index(h);
        this.removeAndNotify(h, i, normalizedName, true);
        for (Object v : values) {
            StringMultimap.requireNonNullElement(values, v);
            this.addAndNotify(h, i, normalizedName, StringMultimap.fromObject(v), false);
        }
    }

    final void setObject(IN_NAME name, Object ... values) {
        NAME normalizedName = this.normalizeName(name);
        Objects.requireNonNull(values, "values");
        int h = this.hashName(normalizedName);
        int i = this.index(h);
        this.removeAndNotify(h, i, normalizedName, true);
        for (Object v : values) {
            StringMultimap.requireNonNullElement(values, v);
            this.addAndNotify(h, i, normalizedName, StringMultimap.fromObject(v), false);
        }
    }

    final void setObject(Iterable<? extends Map.Entry<? extends IN_NAME, ?>> entries) {
        Objects.requireNonNull(entries, "entries");
        if (entries == this) {
            return;
        }
        for (Map.Entry<IN_NAME, ?> e : entries) {
            this.remove((CharSequence)e.getKey());
        }
        if (!this.addFast(entries)) {
            this.addObjectSlow(entries);
        }
    }

    final void setInt(IN_NAME name, int value) {
        this.set(name, StringUtil.toString(value));
    }

    final void setLong(IN_NAME name, long value) {
        this.set(name, StringUtil.toString(value));
    }

    final void setFloat(IN_NAME name, float value) {
        this.set(name, String.valueOf(value));
    }

    final void setDouble(IN_NAME name, double value) {
        this.set(name, String.valueOf(value));
    }

    final void setTimeMillis(IN_NAME name, long value) {
        this.set(name, StringMultimap.fromTimeMillis(value));
    }

    final boolean remove(IN_NAME name) {
        Objects.requireNonNull(name, "name");
        int h = this.hashName(name);
        return this.removeAndNotify(h, this.index(h), name, true) != null;
    }

    final void clear() {
        Arrays.fill(this.entries, null);
        this.firstGroupHead.before = this.firstGroupHead.after = this.firstGroupHead;
        this.secondGroupHead = this.firstGroupHead.after;
        this.size = 0;
        this.onClear();
    }

    private static void requireNonNullElement(Object values, @Nullable Object e) {
        if (e == null) {
            throw new NullPointerException("values contains null: " + values);
        }
    }

    private int index(int hash) {
        return hash & this.hashMask;
    }

    private boolean addFast(Iterable<? extends Map.Entry<? extends IN_NAME, ?>> entries) {
        if (!(entries instanceof StringMultimap)) {
            return false;
        }
        StringMultimap multimap = (StringMultimap)entries;
        Entry e = multimap.firstGroupHead.after;
        while (e != multimap.firstGroupHead) {
            Object key = e.key;
            String value = e.value;
            assert (key != null);
            assert (value != null);
            this.addAndNotify(e.hash, this.index(e.hash), key, value, true);
            e = e.after;
        }
        return true;
    }

    private void addSlow(Iterable<? extends Map.Entry<? extends IN_NAME, String>> entries) {
        for (Map.Entry<IN_NAME, String> e : entries) {
            this.add((IN_NAME)((CharSequence)e.getKey()), e.getValue());
        }
    }

    private void addObjectSlow(Iterable<? extends Map.Entry<? extends IN_NAME, ?>> entries) {
        for (Map.Entry<IN_NAME, ?> e : entries) {
            this.addObject((IN_NAME)((CharSequence)e.getKey()), e.getValue());
        }
    }

    @Nullable
    private String removeAndNotify(int h, int i, IN_NAME name, boolean notifyChange) {
        Object currentName;
        Entry e = this.entries[i];
        if (e == null) {
            return null;
        }
        String value = null;
        Entry next = e.next;
        while (next != null) {
            if (next.hash == h) {
                currentName = next.key;
                if (currentName != null && this.nameEquals(currentName, name)) {
                    value = next.value;
                    e.next = next.next;
                    next.remove();
                    --this.size;
                    if (notifyChange) {
                        this.onChange(currentName);
                    }
                } else {
                    e = next;
                }
            } else {
                e = next;
            }
            next = e.next;
        }
        e = this.entries[i];
        if (e.hash == h && (currentName = e.key) != null && this.nameEquals(currentName, name)) {
            if (value == null) {
                value = e.value;
            }
            this.entries[i] = e.next;
            e.remove();
            --this.size;
            if (notifyChange) {
                this.onChange(currentName);
            }
        }
        return value;
    }

    @Nullable
    private static Integer toInteger(@Nullable String v) {
        try {
            return v != null ? Integer.valueOf(Integer.parseInt(v)) : null;
        }
        catch (NumberFormatException ignore) {
            return null;
        }
    }

    @Nullable
    private static Long toLong(@Nullable String v) {
        try {
            return v != null ? Long.valueOf(Long.parseLong(v)) : null;
        }
        catch (NumberFormatException ignore) {
            return null;
        }
    }

    @Nullable
    private static Float toFloat(@Nullable String v) {
        try {
            return v != null ? Float.valueOf(Float.parseFloat(v)) : null;
        }
        catch (NumberFormatException ignore) {
            return null;
        }
    }

    @Nullable
    private static Double toDouble(@Nullable String v) {
        try {
            return v != null ? Double.valueOf(Double.parseDouble(v)) : null;
        }
        catch (NumberFormatException ignore) {
            return null;
        }
    }

    @Nullable
    private static Long toTimeMillis(@Nullable String v) {
        if (v == null) {
            return null;
        }
        try {
            Date date = DateFormatter.parseHttpDate((CharSequence)v);
            return date != null ? Long.valueOf(date.getTime()) : null;
        }
        catch (Exception ignore) {
            return null;
        }
    }

    private static String fromTimeMillis(long value) {
        return StringValueConverter.INSTANCE.convertTimeMillis(value);
    }

    private static String fromObject(Object value) {
        String strVal = StringValueConverter.INSTANCE.convertObject(value);
        assert (strVal != null) : value + " converted to null.";
        return strVal;
    }

    public int hashCode() {
        int result = -1028477387;
        for (CharSequence name : this.names()) {
            result = (result * 31 + this.hashName(name)) * 31 + this.getAll(name).hashCode();
        }
        return result;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringMultimapGetters)) {
            return false;
        }
        StringMultimapGetters that = (StringMultimapGetters)o;
        if (this.size() != that.size()) {
            return false;
        }
        if (that instanceof StringMultimap) {
            return this.equalsFast((StringMultimap)that);
        }
        return this.equalsSlow(that);
    }

    private boolean equalsFast(StringMultimap<IN_NAME, NAME> that) {
        Entry e = this.firstGroupHead.after;
        while (e != this.firstGroupHead) {
            Object name = e.getKey();
            if (!this.getAllReversed(name).equals(super.getAllReversed(name))) {
                return false;
            }
            e = e.after;
        }
        return true;
    }

    private boolean equalsSlow(StringMultimapGetters<IN_NAME, NAME> that) {
        Entry e = this.firstGroupHead.after;
        while (e != this.firstGroupHead) {
            Object name = e.getKey();
            if (!Iterators.elementsEqual(this.valueIterator(name), that.valueIterator(name))) {
                return false;
            }
            e = e.after;
        }
        return true;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(7 + this.size * 20);
        sb.append('[');
        Entry e = this.firstGroupHead.after;
        while (e != this.firstGroupHead) {
            sb.append((CharSequence)e.key).append('=').append(e.value).append(", ");
            e = e.after;
        }
        int length = sb.length();
        sb.setCharAt(length - 2, ']');
        return sb.substring(0, length - 1);
    }

    private final class Entry
    implements Map.Entry<NAME, String> {
        final int hash;
        @Nullable
        final NAME key;
        @Nullable
        final String value;
        @Nullable
        Entry next;
        Entry before;
        Entry after;

        Entry() {
            this.hash = -1;
            this.key = null;
            this.value = null;
            this.before = this.after = this;
        }

        Entry(int hash, NAME key, String value, Entry next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
            if (StringMultimap.this.isFirstGroup(key)) {
                this.after = ((StringMultimap)StringMultimap.this).secondGroupHead;
                this.before = ((StringMultimap)StringMultimap.this).secondGroupHead.before;
            } else {
                this.after = ((StringMultimap)StringMultimap.this).firstGroupHead;
                this.before = ((StringMultimap)StringMultimap.this).firstGroupHead.before;
                if (((StringMultimap)StringMultimap.this).secondGroupHead == ((StringMultimap)StringMultimap.this).firstGroupHead) {
                    ((StringMultimap)StringMultimap.this).secondGroupHead = this;
                }
            }
            this.pointNeighborsToThis();
        }

        void pointNeighborsToThis() {
            this.before.after = this;
            this.after.before = this;
        }

        void remove() {
            if (this == StringMultimap.this.secondGroupHead) {
                StringMultimap.this.secondGroupHead = ((StringMultimap)StringMultimap.this).secondGroupHead.after;
            }
            this.before.after = this.after;
            this.after.before = this.before;
        }

        @Override
        public NAME getKey() {
            assert (this.key != null);
            return this.key;
        }

        @Override
        public String getValue() {
            assert (this.value != null);
            return this.value;
        }

        @Override
        public String setValue(String value) {
            throw new UnsupportedOperationException("read-only");
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : StringMultimap.this.hashName(this.key)) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)o;
            Object thisKey = this.key;
            CharSequence thatKey = (CharSequence)that.getKey();
            if (thisKey == null) {
                return thatKey == null && Objects.equals(this.value, that.getValue());
            }
            return thatKey != null && StringMultimap.this.nameEquals(thisKey, thatKey) && Objects.equals(this.value, that.getValue());
        }

        public String toString() {
            if (this.key == null) {
                return "<HEAD>";
            }
            assert (this.value != null);
            return new StringBuilder(this.key.length() + this.value.length() + 1).append((CharSequence)this.key).append('=').append(this.value).toString();
        }
    }

    private final class EntryIterator
    implements Iterator<Map.Entry<NAME, String>> {
        private Entry current;

        private EntryIterator() {
            this.current = StringMultimap.this.firstGroupHead;
        }

        @Override
        public boolean hasNext() {
            return this.current.after != StringMultimap.this.firstGroupHead;
        }

        @Override
        public Map.Entry<NAME, String> next() {
            this.current = this.current.after;
            if (this.current == StringMultimap.this.firstGroupHead) {
                throw new NoSuchElementException();
            }
            return this.current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("read-only");
        }
    }
}

