/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.retry;

import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.retry.AbstractRetryingClientBuilder;
import com.linecorp.armeria.client.retry.RetryConfig;
import com.linecorp.armeria.client.retry.RetryConfigMapping;
import com.linecorp.armeria.client.retry.RetryingClient;
import com.linecorp.armeria.common.HttpResponse;
import java.time.Duration;
import java.util.function.Function;

public final class RetryingClientBuilder
extends AbstractRetryingClientBuilder<HttpResponse> {
    private boolean useRetryAfter;

    RetryingClientBuilder(RetryConfig<HttpResponse> retryConfig) {
        super(retryConfig);
    }

    RetryingClientBuilder(RetryConfigMapping<HttpResponse> mapping) {
        super(mapping);
    }

    public RetryingClientBuilder useRetryAfter(boolean useRetryAfter) {
        this.useRetryAfter = useRetryAfter;
        return this;
    }

    public RetryingClient build(HttpClient delegate) {
        return new RetryingClient(delegate, this.mapping(), this.retryConfig(), this.useRetryAfter);
    }

    public Function<? super HttpClient, RetryingClient> newDecorator() {
        return this::build;
    }

    @Override
    public String toString() {
        return this.toStringHelper().add("useRetryAfter", this.useRetryAfter).toString();
    }

    public RetryingClientBuilder maxTotalAttempts(int maxTotalAttempts) {
        return (RetryingClientBuilder)super.maxTotalAttempts(maxTotalAttempts);
    }

    public RetryingClientBuilder responseTimeoutMillisForEachAttempt(long responseTimeoutMillisForEachAttempt) {
        return (RetryingClientBuilder)super.responseTimeoutMillisForEachAttempt(responseTimeoutMillisForEachAttempt);
    }

    public RetryingClientBuilder responseTimeoutForEachAttempt(Duration responseTimeoutForEachAttempt) {
        return (RetryingClientBuilder)super.responseTimeoutForEachAttempt(responseTimeoutForEachAttempt);
    }
}

