/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.jfr.type;

import org.apache.skywalking.oap.server.library.jfr.type.CallStack;
import org.apache.skywalking.oap.server.library.jfr.type.Frame;
import org.apache.skywalking.oap.server.library.jfr.type.FrameTree;
import org.apache.skywalking.oap.server.library.jfr.type.Index;

public class FrameTreeBuilder {
    private final Index<String> cpool = new Index<String>(String.class, "all");
    private final Frame root = new Frame(0, 3);
    private int depth;

    public void addSample(CallStack stack, long ticks) {
        Frame frame = this.root;
        int size = stack.getSize();
        for (int i = 0; i < size; ++i) {
            frame = this.addChild(frame, stack.getNames()[i], stack.getTypes()[i], ticks);
        }
        frame.total += ticks;
        frame.self += ticks;
        this.depth = Math.max(this.depth, size);
    }

    private Frame addChild(Frame frame, String title, byte type, long ticks) {
        Frame child;
        frame.total += ticks;
        int titleIndex = this.cpool.index(title);
        switch (type) {
            case 0: {
                child = frame.getChild(titleIndex, (byte)1);
                child.interpreted += ticks;
                break;
            }
            case 2: {
                child = frame.getChild(titleIndex, (byte)1);
                child.inlined += ticks;
                break;
            }
            case 6: {
                child = frame.getChild(titleIndex, (byte)1);
                child.c1 += ticks;
                break;
            }
            default: {
                child = frame.getChild(titleIndex, type);
            }
        }
        return child;
    }

    public FrameTree build() {
        String[] keys = this.cpool.keys();
        return FrameTree.buildTree(this.root, keys);
    }
}

