/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.server.grpc.AbstractServerCall;
import com.linecorp.armeria.server.ServiceRequestContext;
import io.grpc.ForwardingServerCall;
import io.grpc.ServerCall;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;

final class ServerCallUtil {
    @Nullable
    private static MethodHandle delegateMH;

    @Nullable
    static ServiceRequestContext findRequestContext(ServerCall<?, ?> serverCall) {
        AbstractServerCall<?, ?> armeriaServerCall = ServerCallUtil.findArmeriaServerCall(serverCall);
        if (armeriaServerCall != null) {
            return armeriaServerCall.ctx();
        }
        return ServiceRequestContext.currentOrNull();
    }

    @Nullable
    static <I, O> AbstractServerCall<I, O> findArmeriaServerCall(ServerCall<I, O> serverCall) {
        if (delegateMH != null) {
            while (serverCall instanceof ForwardingServerCall) {
                try {
                    serverCall = delegateMH.invoke(serverCall);
                }
                catch (Throwable e) {
                    // empty catch block
                    break;
                }
            }
        }
        if (serverCall instanceof AbstractServerCall) {
            return (AbstractServerCall)serverCall;
        }
        return null;
    }

    private ServerCallUtil() {
    }

    static {
        try {
            Method delegate = ForwardingServerCall.class.getDeclaredMethod("delegate", new Class[0]);
            delegate.setAccessible(true);
            delegateMH = MethodHandles.lookup().unreflect(delegate);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            delegateMH = null;
        }
    }
}

