/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.grpc;

import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import com.linecorp.armeria.common.grpc.GrpcJsonMarshaller;
import io.grpc.MethodDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

final class GsonGrpcJsonMarshaller
implements GrpcJsonMarshaller {
    final JsonFormat.Printer printer;
    final JsonFormat.Parser parser;

    GsonGrpcJsonMarshaller(JsonFormat.Printer printer, JsonFormat.Parser parser) {
        this.printer = printer;
        this.parser = parser;
    }

    @Override
    public <T> void serializeMessage(MethodDescriptor.Marshaller<T> marshaller, T message, OutputStream os) throws IOException {
        os.write(this.printer.print((MessageOrBuilder)message).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public <T> T deserializeMessage(MethodDescriptor.Marshaller<T> marshaller, InputStream is) throws IOException {
        MethodDescriptor.PrototypeMarshaller prototypeMarshaller = (MethodDescriptor.PrototypeMarshaller)marshaller;
        Message prototype = (Message)prototypeMarshaller.getMessagePrototype();
        assert (prototype != null);
        Message.Builder builder = prototype.newBuilderForType();
        this.parser.merge((Reader)new InputStreamReader(is, StandardCharsets.UTF_8), builder);
        Message cast = builder.build();
        return (T)cast;
    }
}

