/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.Blocking;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.graphql.GraphqlService;
import graphql.analysis.MaxQueryComplexityInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.schema.GraphQLSchema;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.skywalking.oap.query.graphql.GraphQLQueryConfig;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLQueryHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraphQLQueryHandler.class);
    private final ModuleManager moduleManager;
    private final GraphqlService graphqlService;
    private final AtomicReference<Object> queryHistogram = new AtomicReference();
    private final AtomicReference<Object> errorCount = new AtomicReference();

    public GraphQLQueryHandler(ModuleManager moduleManager, GraphQLQueryConfig config, GraphQLSchema schema) {
        int allowedComplexity = config.getMaxQueryComplexity();
        this.moduleManager = moduleManager;
        this.graphqlService = GraphqlService.builder().schema(schema).instrumentation(new Instrumentation[]{new MaxQueryComplexityInstrumentation(allowedComplexity, info -> {
            log.warn("Aborting query because it's too complex, maximum allowed is [{}] but was [{}]", (Object)allowedComplexity, (Object)info.getComplexity());
            return true;
        })}).build();
    }

    @Blocking
    @Post(value="/graphql")
    public HttpResponse graphql(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        HttpResponse httpResponse;
        block8: {
            HistogramMetrics.Timer ignored = this.getQueryHistogram().createTimer();
            try {
                httpResponse = this.graphqlService.serve(ctx, req);
                if (ignored == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.getErrorCount().inc();
                    throw e;
                }
            }
            ignored.close();
        }
        return httpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public HistogramMetrics getQueryHistogram() {
        Object value = this.queryHistogram.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.queryHistogram;
            synchronized (atomicReference) {
                value = this.queryHistogram.get();
                if (value == null) {
                    HistogramMetrics actualValue = ((MetricsCreator)this.moduleManager.find("telemetry").provider().getService(MetricsCreator.class)).createHistogramMetric("graphql_query_latency", "The processing latency of graphql query", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE, new double[0]);
                    value = actualValue == null ? this.queryHistogram : actualValue;
                    this.queryHistogram.set(value);
                }
            }
        }
        return (HistogramMetrics)(value == this.queryHistogram ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public CounterMetrics getErrorCount() {
        Object value = this.errorCount.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.errorCount;
            synchronized (atomicReference) {
                value = this.errorCount.get();
                if (value == null) {
                    CounterMetrics actualValue = ((MetricsCreator)this.moduleManager.find("telemetry").provider().getService(MetricsCreator.class)).createCounter("graphql_query_error_count", "The error count of graphql query", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
                    value = actualValue == null ? this.errorCount : actualValue;
                    this.errorCount.set(value);
                }
            }
        }
        return (CounterMetrics)(value == this.errorCount ? null : value);
    }
}

