/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client.grpc.channel;

import io.grpc.ManagedChannel;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import org.apache.skywalking.banyandb.v1.client.Options;
import org.apache.skywalking.banyandb.v1.client.grpc.channel.ChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultChannelFactory
implements ChannelFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultChannelFactory.class);
    private final URI[] targets;
    private final Options options;

    @Override
    public ManagedChannel create() throws IOException {
        boolean isCAFileExist;
        NettyChannelBuilder managedChannelBuilder = NettyChannelBuilder.forAddress((SocketAddress)this.resolveAddress()).maxInboundMessageSize(this.options.getMaxInboundMessageSize()).usePlaintext();
        File caFile = new File(this.options.getSslTrustCAPath());
        boolean bl = isCAFileExist = caFile.exists() && caFile.isFile();
        if (this.options.isForceTLS() || isCAFileExist) {
            SslContextBuilder builder = GrpcSslContexts.forClient();
            if (isCAFileExist) {
                builder.trustManager(caFile);
            }
            managedChannelBuilder.negotiationType(NegotiationType.TLS).sslContext(builder.build());
        }
        return managedChannelBuilder.build();
    }

    private SocketAddress resolveAddress() throws UnknownHostException {
        int numAddresses = this.targets.length;
        if (numAddresses < 1) {
            throw new UnknownHostException();
        }
        int offset = numAddresses == 1 ? 0 : PlatformDependent.threadLocalRandom().nextInt(numAddresses);
        return new InetSocketAddress(this.targets[offset].getHost(), this.targets[offset].getPort());
    }

    public DefaultChannelFactory(URI[] targets, Options options) {
        this.targets = targets;
        this.options = options;
    }
}

