/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider.discord;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.alarm.AlarmMessage;
import org.apache.skywalking.oap.server.core.alarm.HttpAlarmCallback;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmRulesWatcher;
import org.apache.skywalking.oap.server.core.alarm.provider.discord.DiscordSettings;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscordHookCallback
extends HttpAlarmCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DiscordHookCallback.class);
    private final AlarmRulesWatcher alarmRulesWatcher;

    public void doAlarm(List<AlarmMessage> alarmMessages) throws Exception {
        Map<String, DiscordSettings> settingsMap = this.alarmRulesWatcher.getDiscordSettings();
        if (settingsMap == null || settingsMap.isEmpty()) {
            return;
        }
        Map groupedMessages = this.groupMessagesByHook(alarmMessages);
        for (Map.Entry entry : groupedMessages.entrySet()) {
            String hookName = (String)entry.getKey();
            List messages = (List)entry.getValue();
            DiscordSettings setting = settingsMap.get(hookName);
            if (setting == null || CollectionUtils.isEmpty(setting.getWebhooks()) || CollectionUtils.isEmpty((List)messages)) continue;
            for (DiscordSettings.WebHookUrl webHookUrl : setting.getWebhooks()) {
                for (AlarmMessage alarmMessage : messages) {
                    String content = String.format(setting.getTextTemplate(), alarmMessage.getAlarmMessage());
                    this.sendAlarmMessage(webHookUrl, content);
                }
            }
        }
    }

    private void sendAlarmMessage(DiscordSettings.WebHookUrl webHookUrl, String content) throws IOException, InterruptedException {
        JsonObject body = new JsonObject();
        body.addProperty("username", webHookUrl.getUsername());
        body.addProperty("content", content);
        String requestBody = body.toString();
        this.post(URI.create(webHookUrl.getUrl()), requestBody, Map.of());
    }

    @Generated
    public DiscordHookCallback(AlarmRulesWatcher alarmRulesWatcher) {
        this.alarmRulesWatcher = alarmRulesWatcher;
    }
}

