/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul;

import com.google.common.collect.ImmutableMap;
import com.orbitz.consul.BaseClient;
import com.orbitz.consul.config.ClientConfig;
import com.orbitz.consul.model.operator.RaftConfiguration;
import com.orbitz.consul.monitoring.ClientEventCallback;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;

public class OperatorClient
extends BaseClient {
    private static String CLIENT_NAME = "operator";
    private final Api api;

    OperatorClient(Retrofit retrofit, ClientConfig config, ClientEventCallback eventCallback) {
        super(CLIENT_NAME, config, eventCallback);
        this.api = (Api)retrofit.create(Api.class);
    }

    public RaftConfiguration getRaftConfiguration() {
        return this.http.extract(this.api.getConfiguration((Map<String, String>)ImmutableMap.of()), new Integer[0]);
    }

    public RaftConfiguration getRaftConfiguration(String datacenter) {
        return this.http.extract(this.api.getConfiguration((Map<String, String>)ImmutableMap.of((Object)"dc", (Object)datacenter)), new Integer[0]);
    }

    public RaftConfiguration getStaleRaftConfiguration(String datacenter) {
        return this.http.extract(this.api.getConfiguration((Map<String, String>)ImmutableMap.of((Object)"dc", (Object)datacenter, (Object)"stale", (Object)"true")), new Integer[0]);
    }

    public RaftConfiguration getStaleRaftConfiguration() {
        return this.http.extract(this.api.getConfiguration((Map<String, String>)ImmutableMap.of((Object)"stale", (Object)"true")), new Integer[0]);
    }

    public void deletePeer(String address) {
        this.http.handle(this.api.deletePeer(address, (Map<String, String>)ImmutableMap.of()), new Integer[0]);
    }

    public void deletePeer(String address, String datacenter) {
        this.http.handle(this.api.deletePeer(address, (Map<String, String>)ImmutableMap.of((Object)"dc", (Object)datacenter)), new Integer[0]);
    }

    static interface Api {
        @GET(value="operator/raft/configuration")
        public Call<RaftConfiguration> getConfiguration(@QueryMap Map<String, String> var1);

        @DELETE(value="operator/raft/peer")
        public Call<Void> deletePeer(@Query(value="address") String var1, @QueryMap Map<String, String> var2);
    }
}

