/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.skywalking.oap.server.core.alarm.AlarmCallback;
import org.apache.skywalking.oap.server.core.alarm.AlarmMessage;
import org.apache.skywalking.oap.server.core.alarm.AlarmRecord;
import org.apache.skywalking.oap.server.core.alarm.AlarmSnapshotRecord;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.Tag;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.TagType;
import org.apache.skywalking.oap.server.core.analysis.worker.RecordStreamProcessor;
import org.apache.skywalking.oap.server.core.config.ConfigService;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.core.source.TagAutocomplete;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmStandardPersistence
implements AlarmCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlarmStandardPersistence.class);
    private final Gson gson = new Gson();
    private final ModuleManager manager;
    private SourceReceiver receiver;

    public AlarmStandardPersistence(ModuleManager manager) {
        this.manager = manager;
    }

    @Override
    public void doAlarm(List<AlarmMessage> alarmMessage) {
        alarmMessage.forEach(message -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Alarm message: {}", (Object)message.getAlarmMessage());
            }
            AlarmRecord record = new AlarmRecord();
            record.setScope(message.getScopeId());
            record.setId0(message.getId0());
            record.setId1(message.getId1());
            record.setName(message.getName());
            record.setAlarmMessage(message.getAlarmMessage());
            record.setStartTime(message.getStartTime());
            record.setTimeBucket(TimeBucket.getRecordTimeBucket(message.getStartTime()));
            record.setRuleName(message.getRuleName());
            Collection<Tag> tags = this.appendSearchableTags(message.getTags());
            this.addAutocompleteTags(tags, TimeBucket.getMinuteTimeBucket(message.getStartTime()));
            record.setTagsRawData(this.gson.toJson(message.getTags()).getBytes(Charsets.UTF_8));
            record.setTagsInString(Tag.Util.toStringList(new ArrayList<Tag>(tags)));
            AlarmSnapshotRecord snapshot = new AlarmSnapshotRecord();
            snapshot.setExpression(message.getExpression());
            snapshot.setMetrics(message.getMqeMetricsSnapshot());
            record.setSnapshot(this.gson.toJson((Object)snapshot));
            RecordStreamProcessor.getInstance().in(record);
        });
    }

    private SourceReceiver getReceiver() {
        if (this.receiver == null) {
            this.receiver = (SourceReceiver)this.manager.find("core").provider().getService(SourceReceiver.class);
        }
        return this.receiver;
    }

    private Collection<Tag> appendSearchableTags(List<Tag> tags) {
        ConfigService configService = (ConfigService)this.manager.find("core").provider().getService(ConfigService.class);
        HashSet<Tag> alarmTags = new HashSet<Tag>();
        tags.forEach(tag -> {
            if (configService.getSearchableAlarmTags().contains(tag.getKey())) {
                Tag alarmTag = new Tag(tag.getKey(), tag.getValue());
                if (tag.getValue().length() > 256 || alarmTag.toString().length() > 256) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Alarm tag : {} length > : {}, dropped", (Object)alarmTag, (Object)256);
                    }
                    return;
                }
                alarmTags.add(alarmTag);
            }
        });
        return alarmTags;
    }

    private void addAutocompleteTags(Collection<Tag> alarmTags, long minuteTimeBucket) {
        alarmTags.forEach(tag -> {
            TagAutocomplete tagAutocomplete = new TagAutocomplete();
            tagAutocomplete.setTagKey(tag.getKey());
            tagAutocomplete.setTagValue(tag.getValue());
            tagAutocomplete.setTagType(TagType.ALARM);
            tagAutocomplete.setTimeBucket(minuteTimeBucket);
            this.getReceiver().receive(tagAutocomplete);
        });
    }
}

