/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.internal.shared.ImplementationHelper;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.GeodeticException;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.referencing.operation.DefaultConversion;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.PassThroughOperation;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.util.FactoryException;

@XmlType(name="PassThroughOperationType", propOrder={"indices", "operation"})
@XmlRootElement(name="PassThroughOperation")
public class DefaultPassThroughOperation
extends AbstractCoordinateOperation
implements PassThroughOperation {
    private static final long serialVersionUID = 3516394762777350439L;
    private SingleOperation operation;
    private int[] modifiedCoordinates;

    public DefaultPassThroughOperation(Map<String, ?> properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, SingleOperation operation, int firstAffectedCoordinate, int numTrailingCoordinates) {
        this(properties, sourceCRS, targetCRS, operation, operation.getMathTransform(), firstAffectedCoordinate, numTrailingCoordinates);
    }

    private DefaultPassThroughOperation(Map<String, ?> properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, SingleOperation operation, MathTransform subTransform, int firstAffectedCoordinate, int numTrailingCoordinates) {
        super(properties, sourceCRS, targetCRS, null, MathTransforms.passThrough(firstAffectedCoordinate, subTransform, numTrailingCoordinates));
        this.operation = operation;
        this.modifiedCoordinates = ArraysExt.range((int)firstAffectedCoordinate, (int)(firstAffectedCoordinate + subTransform.getSourceDimensions()));
    }

    protected DefaultPassThroughOperation(PassThroughOperation operation) {
        super((CoordinateOperation)operation);
        this.operation = operation.getOperation();
        this.modifiedCoordinates = operation.getModifiedCoordinates();
    }

    public static DefaultPassThroughOperation castOrCopy(PassThroughOperation object) {
        return object == null || object instanceof DefaultPassThroughOperation ? (DefaultPassThroughOperation)object : new DefaultPassThroughOperation(object);
    }

    public Class<? extends PassThroughOperation> getInterface() {
        return PassThroughOperation.class;
    }

    @Override
    @Deprecated
    public OperationMethod getMethod() {
        return null;
    }

    @Override
    @Deprecated
    public ParameterValueGroup getParameterValues() {
        return null;
    }

    @XmlElement(name="coordOperation", required=true)
    public SingleOperation getOperation() {
        return this.operation;
    }

    public int[] getModifiedCoordinates() {
        return (int[])this.modifiedCoordinates.clone();
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, mode)) {
            if (mode == ComparisonMode.STRICT) {
                DefaultPassThroughOperation other = (DefaultPassThroughOperation)object;
                return Arrays.equals(this.modifiedCoordinates, other.modifiedCoordinates) && Objects.equals(this.operation, other.operation);
            }
            PassThroughOperation other = (PassThroughOperation)object;
            return Arrays.equals(this.getModifiedCoordinates(), other.getModifiedCoordinates()) && Utilities.deepEquals((Object)this.getOperation(), (Object)other.getOperation(), (ComparisonMode)mode);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)(37 * this.operation.hashCode()) + (long)Arrays.hashCode(this.modifiedCoordinates);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        formatter.append(new FormattableObject(){

            @Override
            protected String formatTo(Formatter formatter) {
                for (int i : DefaultPassThroughOperation.this.getModifiedCoordinates()) {
                    formatter.append(i);
                }
                return "ModifiedCoordinates";
            }
        });
        formatter.newLine();
        formatter.append(DefaultPassThroughOperation.castOrCopy((CoordinateOperation)this.getOperation()));
        formatter.setInvalidWKT(this, null);
        return "PassThroughOperation";
    }

    private DefaultPassThroughOperation() {
    }

    private void setOperation(SingleOperation op) {
        if (this.operation == null) {
            this.operation = op;
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultPassThroughOperation.class, (String)"setOperation", (String)"coordOperation");
        }
    }

    @XmlElement(name="modifiedCoordinate", required=true)
    private int[] getIndices() {
        int[] dimensions = this.getModifiedCoordinates();
        int i = 0;
        while (i < dimensions.length) {
            int n = i++;
            dimensions[n] = dimensions[n] + 1;
        }
        return dimensions;
    }

    private void setIndices(int[] dimensions) {
        if (this.modifiedCoordinates == null) {
            if (dimensions.length != 0) {
                dimensions = (int[])dimensions.clone();
                this.modifiedCoordinates = dimensions;
                int i = 0;
                while (i < dimensions.length) {
                    int n = i++;
                    dimensions[n] = dimensions[n] - 1;
                }
            }
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultPassThroughOperation.class, (String)"setIndices", (String)"modifiedCoordinates");
        }
    }

    @Override
    final void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        super.afterUnmarshal(unmarshaller, parent);
        int[] modifiedCoordinates = this.modifiedCoordinates;
        FactoryException cause = null;
        String missing = "modifiedCoordinate";
        if (modifiedCoordinates.length != 0) {
            missing = "sourceCRS";
            CoordinateReferenceSystem sourceCRS = this.sourceCRS;
            if (sourceCRS != null) {
                missing = "targetCRS";
                CoordinateReferenceSystem targetCRS = this.targetCRS;
                if (targetCRS != null) {
                    missing = "coordOperation";
                    if (this.operation != null) {
                        MathTransform subTransform = this.operation.getMathTransform();
                        if (this.operation instanceof Conversion) {
                            CoordinateReferenceSystem sourceSub = this.operation.getSourceCRS();
                            CoordinateReferenceSystem targetSub = this.operation.getTargetCRS();
                            if (subTransform == null || sourceSub == null || targetSub == null) {
                                try {
                                    if (sourceSub == null) {
                                        sourceSub = CRS.selectDimensions(sourceCRS, modifiedCoordinates);
                                    }
                                    if (targetSub == null) {
                                        targetSub = CRS.selectDimensions(targetCRS, modifiedCoordinates);
                                    }
                                    this.operation = DefaultConversion.castOrCopy((Conversion)this.operation).specialize(sourceSub, targetSub, null);
                                    subTransform = this.operation.getMathTransform();
                                }
                                catch (FactoryException e) {
                                    cause = e;
                                }
                            }
                        }
                        if (subTransform != null) {
                            int resultDim = sourceCRS.getCoordinateSystem().getDimension();
                            this.transform = MathTransforms.passThrough(modifiedCoordinates, subTransform, resultDim);
                            return;
                        }
                    }
                }
            }
        }
        throw new GeodeticException(Errors.format((short)106, (Object)"PassThroughOperation", (Object)missing), cause);
    }
}

