/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.apache.sis.metadata.sql.internal.shared.SQLUtilities;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.StringBuilders;
import org.apache.sis.util.resources.Errors;

public class SQLTranslator
implements UnaryOperator<String> {
    static final String TABLE_PREFIX = "epsg_";
    private static final String ENUMERATION_COLUMN = "OBJECT_TABLE_NAME";
    private String catalog;
    private String schema;
    private boolean usePrefixedTableNames;
    private boolean useMixedCaseTableNames;
    private Map<String, String> tableRewording;
    private Map<String, String> replacements;
    private final String identifierQuote;
    final String wildcardEscape;
    private String tableNameEnum;
    private boolean useBoolean;
    private boolean isSchemaFound;
    private boolean isUsageTableFound;
    private boolean sameTableNames;
    private boolean sameQueries;

    public SQLTranslator(DatabaseMetaData md, String catalog, String schema) throws SQLException {
        this.identifierQuote = md.getIdentifierQuoteString().trim();
        this.wildcardEscape = md.getSearchStringEscape();
        this.catalog = catalog;
        this.schema = schema;
        this.setup(md);
    }

    final void setup(DatabaseMetaData md) throws SQLException {
        String schemaPattern = SQLUtilities.escapeWildcards((String)this.schema, (String)this.wildcardEscape);
        int tableIndex = 0;
        block25: do {
            this.usePrefixedTableNames = false;
            this.useMixedCaseTableNames = false;
            Object table2 = "";
            switch (tableIndex++) {
                case 0: {
                    this.usePrefixedTableNames = true;
                    table2 = SQLUtilities.escapeWildcards((String)TABLE_PREFIX, (String)this.wildcardEscape);
                }
                case 2: {
                    table2 = (String)table2 + "coordoperation";
                    if (!md.storesUpperCaseIdentifiers()) break;
                    table2 = ((String)table2).toUpperCase(Locale.US);
                    break;
                }
                case 1: {
                    this.useMixedCaseTableNames = true;
                    table2 = "Coordinate_Operation";
                    break;
                }
                default: {
                    return;
                }
            }
            try (ResultSet result = md.getTables(this.catalog, schemaPattern, (String)table2, null);){
                while (result.next()) {
                    this.isSchemaFound = true;
                    this.catalog = result.getString("TABLE_CAT");
                    this.schema = result.getString("TABLE_SCHEM");
                    if (result.wasNull()) {
                        this.schema = "";
                    }
                    if (!"EPSG".equalsIgnoreCase(this.schema)) continue;
                    continue block25;
                }
            }
        } while (!this.isSchemaFound);
        UnaryOperator toNativeCase = UnaryOperator.identity();
        schemaPattern = SQLUtilities.escapeWildcards((String)this.schema, (String)this.wildcardEscape);
        this.tableRewording = new HashMap<String, String>();
        this.replacements = new HashMap<String, String>();
        if (!this.useMixedCaseTableNames) {
            this.tableRewording.put("Coordinate_Operation", "coordoperation");
            this.tableRewording.put("Parameter", "param");
            if (md.storesLowerCaseIdentifiers()) {
                toNativeCase = table -> table.toLowerCase(Locale.US);
            } else if (md.storesUpperCaseIdentifiers()) {
                toNativeCase = table -> table.toUpperCase(Locale.US);
            }
        }
        HashMap<String, String> missingColumns = new HashMap<String, String>();
        HashMap<String, String> mayRenameColumns = new HashMap<String, String>();
        HashSet brokenTargetCols = new HashSet();
        tableIndex = 0;
        block27: while (true) {
            String table3;
            boolean isUsage = false;
            boolean isArea = false;
            boolean mayReuse = false;
            switch (tableIndex++) {
                case 0: {
                    table3 = "Coordinate Axis";
                    mayRenameColumns.put("COORD_AXIS_ORDER", "ORDER");
                    break;
                }
                case 1: {
                    table3 = "Coordinate_Operation";
                    missingColumns.put("AREA_OF_USE_CODE", "INTEGER");
                    missingColumns.put("COORD_OP_SCOPE", "CHAR(1)");
                    break;
                }
                case 2: {
                    table3 = "Coordinate Reference System";
                    mayRenameColumns.put("BASE_CRS_CODE", "SOURCE_GEOGCRS_CODE");
                    missingColumns.put("AREA_OF_USE_CODE", "INTEGER");
                    missingColumns.put("CRS_SCOPE", "CHAR(1)");
                    break;
                }
                case 3: {
                    table3 = "Datum";
                    mayRenameColumns.put("PUBLICATION_DATE", "REALIZATION_EPOCH");
                    missingColumns.put("ANCHOR_EPOCH", "DOUBLE PRECISION");
                    missingColumns.put("FRAME_REFERENCE_EPOCH", "DOUBLE PRECISION");
                    missingColumns.put("REALIZATION_METHOD_CODE", "INTEGER");
                    missingColumns.put("CONVENTIONAL_RS_CODE", "INTEGER");
                    missingColumns.put("AREA_OF_USE_CODE", "INTEGER");
                    missingColumns.put("DATUM_SCOPE", "CHAR(1)");
                    break;
                }
                case 4: {
                    table3 = "Extent";
                    mayRenameColumns.put("EXTENT_CODE", "AREA_CODE");
                    mayRenameColumns.put("EXTENT_NAME", "AREA_NAME");
                    mayRenameColumns.put("EXTENT_DESCRIPTION", "AREA_OF_USE");
                    mayRenameColumns.put("BBOX_SOUTH_BOUND_LAT", "AREA_SOUTH_BOUND_LAT");
                    mayRenameColumns.put("BBOX_NORTH_BOUND_LAT", "AREA_NORTH_BOUND_LAT");
                    mayRenameColumns.put("BBOX_WEST_BOUND_LON", "AREA_WEST_BOUND_LON");
                    mayRenameColumns.put("BBOX_EAST_BOUND_LON", "AREA_EAST_BOUND_LON");
                    missingColumns.put("VERTICAL_EXTENT_MIN", "DOUBLE PRECISION");
                    missingColumns.put("VERTICAL_EXTENT_MAX", "DOUBLE PRECISION");
                    missingColumns.put("VERTICAL_EXTENT_CRS_CODE", "INTEGER");
                    missingColumns.put("TEMPORAL_EXTENT_BEGIN", "CHAR(1)");
                    missingColumns.put("TEMPORAL_EXTENT_END", "CHAR(1)");
                    mayReuse = true;
                    break;
                }
                case 5: {
                    if (mayRenameColumns.isEmpty()) continue block27;
                    isArea = true;
                    table3 = "Area";
                    break;
                }
                case 6: {
                    isUsage = true;
                    table3 = "Usage";
                    break;
                }
                case 7: {
                    if (this.isUsageTableFound) break block27;
                    table3 = "Alias";
                    break;
                }
                default: {
                    break block27;
                }
            }
            boolean isTableFound = false;
            brokenTargetCols.addAll(mayRenameColumns.values());
            table3 = (String)toNativeCase.apply(this.toActualTableName(table3));
            try (ResultSet result = md.getColumns(this.catalog, schemaPattern, SQLUtilities.escapeWildcards((String)table3, (String)this.wildcardEscape), "%");){
                while (result.next()) {
                    Object type2;
                    isTableFound = true;
                    String column2 = result.getString("COLUMN_NAME").toUpperCase(Locale.US);
                    missingColumns.remove(column2);
                    if (mayRenameColumns.remove(column2) == null) {
                        brokenTargetCols.remove(column2);
                    }
                    if ("DEPRECATED".equals(column2)) {
                        int type3 = result.getInt("DATA_TYPE");
                        this.useBoolean |= type3 == 16 || type3 == -7;
                    }
                    if (!ENUMERATION_COLUMN.equals(column2) || CharSequences.startsWith((CharSequence)(type2 = result.getString("TYPE_NAME")), (CharSequence)"VARCHAR", (boolean)true) || CharSequences.startsWith((CharSequence)type2, (CharSequence)"CHARACTER", (boolean)true)) continue;
                    if (!((String)type2).contains(this.identifierQuote)) {
                        type2 = this.identifierQuote + (String)type2 + this.identifierQuote;
                    }
                    this.tableNameEnum = type2;
                }
            }
            if (isTableFound) {
                this.isUsageTableFound |= isUsage;
                if (isArea) {
                    this.tableRewording.put("Extent", "Area");
                }
                missingColumns.forEach((column, type) -> this.replacements.put((String)column, "CAST(NULL AS " + type + ") AS " + column));
                mayRenameColumns.values().removeAll(brokenTargetCols);
                this.replacements.putAll(mayRenameColumns);
                mayReuse = false;
            }
            if (mayReuse) continue;
            mayRenameColumns.clear();
            brokenTargetCols.clear();
            missingColumns.clear();
        }
        if (!this.useBoolean) {
            this.replacements.put("=FALSE", "=0");
            this.replacements.put("=TRUE", "<>0");
        }
        this.replacements = Map.copyOf(this.replacements);
        this.tableRewording = Map.copyOf(this.tableRewording);
        this.sameTableNames = this.useMixedCaseTableNames && "\"".equals(this.identifierQuote) && this.tableRewording.isEmpty();
        this.sameQueries = this.sameTableNames && this.useBoolean && this.tableNameEnum == null && this.replacements.isEmpty();
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    final boolean isSchemaFound() {
        return this.isSchemaFound;
    }

    final boolean isUsageTableFound() {
        return this.isUsageTableFound;
    }

    static String tableNotFound(DatabaseMetaData md, Locale locale) throws SQLException {
        String db = md.getURL();
        if (db == null) {
            db = "?";
        } else {
            int s = db.indexOf(63);
            if (s >= 0 || (s = db.indexOf(35)) >= 0) {
                db = db.substring(9, s);
            }
        }
        return Resources.forLocale(locale).getString((short)107, "EPSG", db, "Coordinate_Operation");
    }

    final boolean useBoolean() {
        return this.useBoolean;
    }

    public final String toActualTableName(String name) {
        if (this.useMixedCaseTableNames) {
            return name;
        }
        StringBuilder buffer = new StringBuilder(name.length() + 5);
        this.toActualTableName(name, buffer);
        return buffer.toString().toLowerCase(Locale.US);
    }

    private void toActualTableName(String name, StringBuilder buffer) {
        if (this.useMixedCaseTableNames) {
            buffer.append(this.identifierQuote).append(this.tableRewording.getOrDefault(name, name)).append(this.identifierQuote);
        } else {
            if (this.usePrefixedTableNames) {
                buffer.append(TABLE_PREFIX);
            }
            for (String word : name.split("\\s")) {
                buffer.append(this.tableRewording.getOrDefault(word, word));
            }
        }
    }

    @Override
    public String apply(String sql) {
        int w;
        if (this.sameQueries) {
            return sql;
        }
        StringBuilder buffer = new StringBuilder(sql.length() + 16);
        int end = 0;
        if (!this.sameTableNames) {
            int start;
            while ((start = sql.indexOf(34, end)) >= 0) {
                buffer.append(sql, end, start);
                end = sql.indexOf(34, ++start);
                if (end < 0) {
                    throw new IllegalArgumentException(Errors.format((short)105, (Object)sql.substring(start), (Object)Character.valueOf('\"')));
                }
                this.toActualTableName(sql.substring(start, end++), buffer);
            }
        }
        buffer.append(sql, end, sql.length());
        this.replacements.forEach((toSearch, replaceBy) -> StringBuilders.replace((StringBuilder)buffer, (String)toSearch, (String)replaceBy));
        if (this.tableNameEnum != null && (w = buffer.lastIndexOf("OBJECT_TABLE_NAME=?")) >= 0) {
            buffer.replace(w += ENUMERATION_COLUMN.length() + 1, w + 1, "CAST(? AS " + this.tableNameEnum + ")");
        }
        return buffer.toString();
    }
}

