/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.registry.zookeeper;

import java.io.Closeable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.CuratorCache;
import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.CloseableUtils;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.registry.zookeeper.ZookeeperConfig;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperClient {
    private static final Logger LOG = LoggerFactory.getLogger(ZookeeperClient.class);
    private final CuratorFramework client;
    private final Map<String, CuratorCache> caches = new ConcurrentHashMap<String, CuratorCache>();

    public ZookeeperClient(ZookeeperConfig zookeeperConfig) {
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(zookeeperConfig.getBaseSleepTimeMilliseconds(), zookeeperConfig.getMaxRetries(), zookeeperConfig.getMaxSleepTimeMilliseconds());
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(zookeeperConfig.getServerLists()).retryPolicy((RetryPolicy)retryPolicy).connectionTimeoutMs(zookeeperConfig.getConnectionTimeoutMilliseconds()).sessionTimeoutMs(zookeeperConfig.getSessionTimeoutMilliseconds()).namespace(zookeeperConfig.getNamespace());
        if (!StringUtils.isEmpty((CharSequence)zookeeperConfig.getDigest())) {
            builder.authorization("digest", zookeeperConfig.getDigest().getBytes(StandardCharsets.UTF_8));
        }
        this.client = builder.build();
    }

    public void start() {
        this.client.start();
        try {
            this.client.blockUntilConnected();
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted during zookeeper client starting.");
            Thread.currentThread().interrupt();
        }
    }

    public void close() {
        for (Map.Entry<String, CuratorCache> cache : this.caches.entrySet()) {
            CloseableUtils.closeQuietly((Closeable)((Closeable)cache.getValue()));
        }
        CloseableUtils.closeQuietly((Closeable)this.client);
    }

    public CuratorFramework getClient() {
        return this.client;
    }

    public boolean isExist(String key) {
        try {
            return Objects.nonNull(this.client.checkExists().forPath(key));
        }
        catch (Exception e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    public String getDirectly(String key) {
        try {
            byte[] ret = (byte[])this.client.getData().forPath(key);
            return Objects.isNull(ret) ? null : new String(ret, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    public String get(String key) {
        CuratorCache cache = this.findFromCache(key);
        if (Objects.isNull(cache)) {
            return this.getDirectly(key);
        }
        ChildData data = cache.get(key).orElse(null);
        if (Objects.isNull(data)) {
            return this.getDirectly(key);
        }
        return Objects.isNull(data.getData()) ? null : new String(data.getData(), StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createOrUpdate(String key, String value, CreateMode mode) {
        String val = StringUtils.isEmpty((CharSequence)value) ? "" : value;
        try {
            Class<ZookeeperClient> clazz = ZookeeperClient.class;
            synchronized (ZookeeperClient.class) {
                if (Objects.nonNull(this.client.checkExists()) && Objects.nonNull(this.client.checkExists().forPath(key))) {
                    LOG.debug("path exists, update zookeeper key={} with value={}", (Object)key, (Object)val);
                    this.client.setData().forPath(key, val.getBytes(StandardCharsets.UTF_8));
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return;
                }
                LOG.debug("path not exists, set zookeeper key={} with value={}", (Object)key, (Object)val);
                ((ACLBackgroundPathAndBytesable)this.client.create().orSetData().creatingParentsIfNeeded().withMode(mode)).forPath(key, val.getBytes(StandardCharsets.UTF_8));
                // ** MonitorExit[var5_5] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            LOG.error("create or update key with value error, key:{} value:{}", new Object[]{key, value, e});
            throw new ShenyuException((Throwable)e);
        }
        {
            return;
        }
    }

    public void createOrUpdate(String key, Object value, CreateMode mode) {
        if (Objects.nonNull(value)) {
            String val = GsonUtils.getInstance().toJson(value);
            this.createOrUpdate(key, val, mode);
        } else {
            this.createOrUpdate(key, "", mode);
        }
    }

    public void delete(String key) {
        try {
            ((ChildrenDeletable)this.client.delete().guaranteed()).deletingChildrenIfNeeded().forPath(key);
        }
        catch (Exception e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    public List<String> getChildren(String key) {
        try {
            return (List)this.client.getChildren().forPath(key);
        }
        catch (Exception e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    public CuratorCache getCache(String path) {
        return this.caches.get(path);
    }

    public CuratorCache addCache(String path, CuratorCacheListener ... listeners) {
        CuratorCache cache = CuratorCache.build((CuratorFramework)this.client, (String)path, (CuratorCache.Options[])new CuratorCache.Options[0]);
        this.caches.put(path, cache);
        if (ArrayUtils.isNotEmpty((Object[])listeners)) {
            for (CuratorCacheListener listener : listeners) {
                cache.listenable().addListener((Object)listener);
            }
        }
        try {
            cache.start();
        }
        catch (Exception e) {
            throw new ShenyuException("failed to add curator cache.", (Throwable)e);
        }
        return cache;
    }

    public List<String> subscribeChildrenChanges(String key, CuratorWatcher curatorWatcher) {
        try {
            return (List)((BackgroundPathable)this.client.getChildren().usingWatcher(curatorWatcher)).forPath(key);
        }
        catch (Exception e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    private CuratorCache findFromCache(String key) {
        for (Map.Entry<String, CuratorCache> cache : this.caches.entrySet()) {
            if (!key.startsWith(cache.getKey())) continue;
            return cache.getValue();
        }
        return null;
    }
}

