/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.mcp.generator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.List;
import java.util.Objects;
import org.apache.shenyu.client.mcp.common.annotation.ShenyuMcpTool;

public class McpOpenApiGenerator {
    public static JsonObject generateOpenApiJson(ShenyuMcpTool classMcpClient, org.apache.shenyu.client.mcp.common.dto.ShenyuMcpTool shenyuMcpTool, String url) {
        JsonObject root = new JsonObject();
        root.addProperty("openapi", "3.0.0");
        JsonObject info = new JsonObject();
        OpenAPIDefinition definition = classMcpClient.definition();
        info.addProperty("title", definition.info().title());
        info.addProperty("description", definition.info().description());
        info.addProperty("version", "");
        root.add("info", (JsonElement)info);
        JsonObject server = new JsonObject();
        root.add("server", (JsonElement)server);
        server.addProperty("url", definition.servers()[0].url());
        JsonObject paths = new JsonObject();
        root.add("paths", (JsonElement)paths);
        String pathKey = url;
        JsonObject pathMap = new JsonObject();
        paths.add(pathKey, (JsonElement)pathMap);
        String methodType = shenyuMcpTool.getMethod();
        JsonObject methodMap = new JsonObject();
        pathMap.add(methodType, (JsonElement)methodMap);
        methodMap.addProperty("summary", "");
        methodMap.addProperty("description", "");
        methodMap.addProperty("operationId", "");
        methodMap.add("tag", (JsonElement)new JsonArray());
        JsonArray parameters = new JsonArray();
        methodMap.add("parameters", (JsonElement)parameters);
        List parameterList = shenyuMcpTool.getOperation().getParameters();
        if (!parameterList.isEmpty()) {
            for (Parameter parameter : parameterList) {
                JsonObject parameterObj = new JsonObject();
                parameterObj.addProperty("name", parameter.getName());
                parameterObj.addProperty("in", parameter.getIn());
                parameterObj.addProperty("description", parameter.getDescription());
                parameterObj.addProperty("required", parameter.getRequired());
                if (Objects.nonNull(parameter.getSchema())) {
                    JsonObject schemaMap = new JsonObject();
                    schemaMap.addProperty("type", parameter.getSchema().getType());
                    parameterObj.add("schema", (JsonElement)schemaMap);
                }
                parameters.add((JsonElement)parameterObj);
            }
        }
        return root;
    }
}

