/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.publish;

import java.util.Collection;
import org.apache.shenyu.admin.model.entity.PluginDO;
import org.apache.shenyu.admin.model.enums.EventTypeEnum;
import org.apache.shenyu.admin.model.event.AdminDataModelChangedEvent;
import org.apache.shenyu.admin.model.event.plugin.BatchPluginChangedEvent;
import org.apache.shenyu.admin.model.event.plugin.BatchPluginDeletedEvent;
import org.apache.shenyu.admin.model.event.plugin.PluginChangedEvent;
import org.apache.shenyu.admin.model.event.plugin.PluginCreatedEvent;
import org.apache.shenyu.admin.service.publish.AdminDataModelChangedEventPublisher;
import org.apache.shenyu.admin.utils.SessionUtil;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class PluginEventPublisher
implements AdminDataModelChangedEventPublisher<PluginDO> {
    private final ApplicationEventPublisher publisher;

    public PluginEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @Override
    public void onCreated(PluginDO plugin) {
        this.publish(new PluginCreatedEvent(plugin, SessionUtil.visitorName()));
    }

    @Override
    public void onUpdated(PluginDO plugin, PluginDO before) {
        this.publish(new PluginChangedEvent(plugin, before, EventTypeEnum.PLUGIN_UPDATE, SessionUtil.visitorName()));
    }

    @Override
    public void onDeleted(PluginDO plugin) {
        this.publish(new PluginChangedEvent(plugin, null, EventTypeEnum.PLUGIN_DELETE, SessionUtil.visitorName()));
    }

    @Override
    public void onDeleted(Collection<PluginDO> plugins) {
        this.publish(new BatchPluginDeletedEvent(plugins, SessionUtil.visitorName()));
    }

    public void onEnabled(Collection<PluginDO> plugins) {
        this.publish(new BatchPluginChangedEvent(plugins, null, EventTypeEnum.PLUGIN_UPDATE, SessionUtil.visitorName()));
    }

    @Override
    public void publish(AdminDataModelChangedEvent event) {
        this.publisher.publishEvent((ApplicationEvent)event);
    }
}

