/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.mapper.AiProxyApiKeyMapper;
import org.apache.shenyu.admin.model.dto.ProxyApiKeyDTO;
import org.apache.shenyu.admin.model.entity.ProxyApiKeyDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageParameter;
import org.apache.shenyu.admin.model.query.ProxyApiKeyQuery;
import org.apache.shenyu.admin.model.vo.ProxyApiKeyVO;
import org.apache.shenyu.admin.service.AiProxyApiKeyService;
import org.apache.shenyu.admin.service.support.AiProxyRealKeyResolver;
import org.apache.shenyu.admin.transfer.ProxyApiKeyTransfer;
import org.apache.shenyu.common.dto.ProxyApiKeyData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.SignUtils;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AiProxyApiKeyServiceImpl
implements AiProxyApiKeyService {
    private static final Logger LOG = LoggerFactory.getLogger(AiProxyApiKeyServiceImpl.class);
    private final AiProxyApiKeyMapper mapper;
    private final ApplicationEventPublisher eventPublisher;
    private final AiProxyRealKeyResolver realKeyResolver;

    @Autowired
    public AiProxyApiKeyServiceImpl(AiProxyApiKeyMapper mapper, ApplicationEventPublisher eventPublisher, AiProxyRealKeyResolver realKeyResolver) {
        this.mapper = mapper;
        this.eventPublisher = eventPublisher;
        this.realKeyResolver = realKeyResolver;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int create(ProxyApiKeyDTO dto, String selectorId) {
        ProxyApiKeyDO entity = ProxyApiKeyTransfer.INSTANCE.mapToEntity(dto);
        if (StringUtils.isBlank((CharSequence)entity.getId())) {
            entity.setId(UUIDUtils.getInstance().generateShortUuid());
        }
        if (StringUtils.isBlank((CharSequence)entity.getProxyApiKey())) {
            entity.setProxyApiKey(SignUtils.generateKey());
        }
        if (StringUtils.isBlank((CharSequence)entity.getNamespaceId())) {
            throw new ShenyuException("parameter error");
        }
        if (StringUtils.isBlank((CharSequence)selectorId)) {
            throw new ShenyuException("parameter error");
        }
        entity.setSelectorId(selectorId);
        if (StringUtils.isNotBlank((CharSequence)entity.getProxyApiKey()) && Boolean.TRUE.equals(this.mapper.proxyApiKeyExisted(selectorId, entity.getProxyApiKey()))) {
            throw new ShenyuException("unique index conflict, please enter again");
        }
        if (Objects.isNull(entity.getEnabled())) {
            entity.setEnabled(Boolean.TRUE);
        }
        dto.setId(entity.getId());
        dto.setProxyApiKey(entity.getProxyApiKey());
        dto.setEnabled(entity.getEnabled());
        int rows = this.mapper.insert(entity);
        this.publishChange(DataEventTypeEnum.CREATE, entity);
        return rows;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int update(ProxyApiKeyDTO dto) {
        ProxyApiKeyDO entity = ProxyApiKeyTransfer.INSTANCE.mapToEntity(dto);
        if (Objects.isNull(entity) || StringUtils.isBlank((CharSequence)entity.getId())) {
            return 0;
        }
        int rows = this.mapper.updateSelective(entity);
        this.publishChange(DataEventTypeEnum.UPDATE, entity);
        return rows;
    }

    @Override
    public ProxyApiKeyVO findById(String id) {
        ProxyApiKeyVO vo = ProxyApiKeyTransfer.INSTANCE.mapToVO(this.mapper.selectById(id));
        if (Objects.nonNull(vo)) {
            String real = this.realKeyResolver.resolveRealKey(vo.getSelectorId()).orElse(null);
            vo.setRealApiKey(real);
        }
        return vo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int delete(List<String> ids) {
        List<ProxyApiKeyDO> toDelete = this.mapper.selectByIds(ids);
        int rows = this.mapper.deleteByIds(ids);
        if (rows > 0 && CollectionUtils.isNotEmpty(toDelete)) {
            this.publishChangeList(DataEventTypeEnum.DELETE, toDelete);
        }
        return rows;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String enabled(List<String> ids, Boolean enabled) {
        if (CollectionUtils.isEmpty(ids) || Objects.isNull(enabled)) {
            return "parameter error";
        }
        int rows = this.mapper.updateEnableBatch(ids, enabled);
        if (rows > 0) {
            List<ProxyApiKeyDO> updated = this.mapper.selectByIds(ids);
            if (Objects.nonNull(updated) && !updated.isEmpty()) {
                for (ProxyApiKeyDO e : updated) {
                    e.setEnabled(enabled);
                }
                this.publishChangeList(DataEventTypeEnum.UPDATE, updated);
            }
            return "";
        }
        return "ID NOT EXIST!";
    }

    @Override
    public CommonPager<ProxyApiKeyVO> listByPage(ProxyApiKeyQuery query) {
        int current = query.getPageParameter().getCurrentPage();
        int size = query.getPageParameter().getPageSize();
        PageHelper.startPage((int)current, (int)size);
        List<ProxyApiKeyVO> list = this.mapper.selectByCondition(query);
        PageInfo pageInfo = new PageInfo(list);
        return new CommonPager<ProxyApiKeyVO>(new PageParameter(current, size, (int)pageInfo.getTotal()), list);
    }

    @Override
    public List<ProxyApiKeyVO> searchByCondition(ProxyApiKeyQuery condition) {
        return this.mapper.selectByCondition(condition);
    }

    @Override
    public List<ProxyApiKeyData> listAll() {
        List<ProxyApiKeyData> list = this.mapper.selectAll().stream().map(this::convert).collect(Collectors.toList());
        LOG.info("[AiProxySync] listAll size:{}", (Object)list.size());
        return list;
    }

    @Override
    public void syncData() {
        List<ProxyApiKeyDO> all = this.mapper.selectAll();
        if (CollectionUtils.isEmpty(all)) {
            return;
        }
        LOG.info("[AiProxySync] syncData triggered, total records:{}", (Object)all.size());
        all.stream().collect(Collectors.groupingBy(ProxyApiKeyDO::getNamespaceId)).values().forEach(list -> this.publishRefresh((List<ProxyApiKeyDO>)list));
    }

    @Override
    public void syncDataByNamespaceId(String namespaceId) {
        String target = this.normalizeNamespace(namespaceId);
        List<ProxyApiKeyDO> all = this.mapper.selectAll();
        List<ProxyApiKeyDO> list = Objects.isNull(all) ? Collections.emptyList() : all.stream().filter(e -> StringUtils.equals((CharSequence)this.normalizeNamespace(e.getNamespaceId()), (CharSequence)target)).collect(Collectors.toList());
        LOG.info("[AiProxySync] syncDataByNamespaceId {}, normalized:{}, matched:{} of total:{}", new Object[]{namespaceId, target, list.size(), Objects.isNull(all) ? 0 : all.size()});
        if (list.isEmpty()) {
            return;
        }
        this.publishRefresh(list);
    }

    private void publishChange(DataEventTypeEnum type, ProxyApiKeyDO entity) {
        if (Objects.isNull(this.eventPublisher) || Objects.isNull(entity)) {
            return;
        }
        ProxyApiKeyData data = this.convert(entity);
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.AI_PROXY_API_KEY, type, Collections.singletonList(data)));
        String ns = data.getNamespaceId();
        LOG.info("[AiProxySync] publish {}, size=1, namespaceId={}", (Object)type, (Object)ns);
        if (LOG.isDebugEnabled()) {
            String masked = Objects.isNull(entity.getProxyApiKey()) ? null : entity.getProxyApiKey().substring(0, Math.min(6, entity.getProxyApiKey().length()));
            LOG.debug("[AiProxySync] published {}, proxyKeyMask={}..., ns={}", new Object[]{type, masked, ns});
        }
    }

    private void publishChangeList(DataEventTypeEnum type, List<ProxyApiKeyDO> entities) {
        if (Objects.isNull(this.eventPublisher) || Objects.isNull(entities) || entities.isEmpty()) {
            return;
        }
        List dataList = entities.stream().map(this::convert).collect(Collectors.toList());
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.AI_PROXY_API_KEY, type, dataList));
        Set nsSet = dataList.stream().map(ProxyApiKeyData::getNamespaceId).filter(Objects::nonNull).collect(Collectors.toSet());
        String nsSummary = nsSet.isEmpty() ? "unknown" : (nsSet.size() == 1 ? (String)nsSet.iterator().next() : "multi");
        LOG.info("[AiProxySync] publish {}, size={}, namespace={} ", new Object[]{type, dataList.size(), nsSummary});
        if (LOG.isDebugEnabled()) {
            dataList.stream().map(ProxyApiKeyData::getProxyApiKey).filter(Objects::nonNull).forEach(k -> {
                String masked = k.substring(0, Math.min(6, k.length()));
                LOG.debug("[AiProxySync] published {}, proxyKeyMask={}...", (Object)type, (Object)masked);
            });
        }
    }

    private void publishRefresh(List<ProxyApiKeyDO> entities) {
        List dataList = entities.stream().map(this::convert).collect(Collectors.toList());
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.AI_PROXY_API_KEY, DataEventTypeEnum.REFRESH, dataList));
    }

    private ProxyApiKeyData convert(ProxyApiKeyDO entity) {
        String normalizedNs = this.normalizeNamespace(entity.getNamespaceId());
        if (!StringUtils.equals((CharSequence)entity.getNamespaceId(), (CharSequence)normalizedNs)) {
            LOG.info("[AiProxySync] normalize namespace from {} to {} for proxyKey={}", new Object[]{entity.getNamespaceId(), normalizedNs, entity.getProxyApiKey()});
        }
        String resolvedRealKey = this.realKeyResolver.resolveRealKey(entity.getSelectorId()).orElse(null);
        return ProxyApiKeyData.builder().proxyApiKey(entity.getProxyApiKey()).realApiKey(resolvedRealKey).description(entity.getDescription()).enabled(entity.getEnabled()).namespaceId(normalizedNs).selectorId(entity.getSelectorId()).build();
    }

    private String normalizeNamespace(String namespaceId) {
        if (StringUtils.isBlank((CharSequence)namespaceId) || StringUtils.equalsIgnoreCase((CharSequence)namespaceId, (CharSequence)"default")) {
            return "649330b6-c2d7-4edc-be8e-8a54df9eb385";
        }
        return namespaceId;
    }
}

