/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.entity;

import java.sql.Timestamp;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.PermissionDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.common.utils.UUIDUtils;

public final class PermissionDO
extends BaseDO {
    private static final long serialVersionUID = 8371869040638596986L;
    private String objectId;
    private String resourceId;

    public PermissionDO() {
    }

    public PermissionDO(String objectId, String resourceId) {
        this.objectId = objectId;
        this.resourceId = resourceId;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public static PermissionDOBuilder builder() {
        return new PermissionDOBuilder();
    }

    public static PermissionDO buildPermissionDO(PermissionDTO permissionDTO) {
        return Optional.ofNullable(permissionDTO).map(item -> {
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            PermissionDO permissionDO = PermissionDO.builder().objectId(item.getObjectId()).resourceId(item.getResourceId()).build();
            if (StringUtils.isEmpty((CharSequence)item.getId())) {
                permissionDO.setId(UUIDUtils.getInstance().generateShortUuid());
                permissionDO.setDateCreated(currentTime);
            } else {
                permissionDO.setId(item.getId());
            }
            return permissionDO;
        }).orElse(null);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (Objects.isNull(o) || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PermissionDO that = (PermissionDO)o;
        return Objects.equals(this.objectId, that.objectId) && Objects.equals(this.resourceId, that.resourceId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.objectId, this.resourceId);
    }

    public static final class PermissionDOBuilder {
        private String id;
        private Timestamp dateCreated;
        private Timestamp dateUpdated;
        private String objectId;
        private String resourceId;

        private PermissionDOBuilder() {
        }

        public PermissionDOBuilder id(String id) {
            this.id = id;
            return this;
        }

        public PermissionDOBuilder dateCreated(Timestamp dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public PermissionDOBuilder dateUpdated(Timestamp dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public PermissionDOBuilder objectId(String objectId) {
            this.objectId = objectId;
            return this;
        }

        public PermissionDOBuilder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public PermissionDO build() {
            PermissionDO permissionDO = new PermissionDO();
            permissionDO.setId(this.id);
            permissionDO.setDateCreated(this.dateCreated);
            permissionDO.setDateUpdated(this.dateUpdated);
            permissionDO.setObjectId(this.objectId);
            permissionDO.setResourceId(this.resourceId);
            return permissionDO;
        }
    }
}

