/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.kernel.executor;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.api.ElasticJob;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.kernel.executor.error.handler.JobErrorHandlerReloader;
import org.apache.shardingsphere.elasticjob.kernel.executor.facade.JobFacade;
import org.apache.shardingsphere.elasticjob.kernel.executor.item.JobItemExecutorFactory;
import org.apache.shardingsphere.elasticjob.kernel.executor.threadpool.ExecutorServiceReloader;
import org.apache.shardingsphere.elasticjob.kernel.infra.env.IpUtils;
import org.apache.shardingsphere.elasticjob.kernel.infra.exception.ExceptionUtils;
import org.apache.shardingsphere.elasticjob.kernel.infra.exception.JobExecutionEnvironmentException;
import org.apache.shardingsphere.elasticjob.spi.executor.error.handler.JobErrorHandler;
import org.apache.shardingsphere.elasticjob.spi.executor.item.JobItemExecutor;
import org.apache.shardingsphere.elasticjob.spi.executor.item.type.TypedJobItemExecutor;
import org.apache.shardingsphere.elasticjob.spi.listener.param.ShardingContexts;
import org.apache.shardingsphere.elasticjob.spi.tracing.event.JobExecutionEvent;
import org.apache.shardingsphere.elasticjob.spi.tracing.event.JobStatusTraceEvent;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ElasticJobExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ElasticJobExecutor.class);
    private final ElasticJob elasticJob;
    private final JobFacade jobFacade;
    private final JobItemExecutor jobItemExecutor;
    private final ExecutorServiceReloader executorServiceReloader;
    private final JobErrorHandlerReloader jobErrorHandlerReloader;
    private final Map<Integer, String> itemErrorMessages;

    public ElasticJobExecutor(ElasticJob elasticJob, JobConfiguration jobConfig, JobFacade jobFacade) {
        this(elasticJob, jobConfig, jobFacade, JobItemExecutorFactory.getExecutor(elasticJob.getClass()));
    }

    public ElasticJobExecutor(String type, JobConfiguration jobConfig, JobFacade jobFacade) {
        this(null, jobConfig, jobFacade, (JobItemExecutor)TypedSPILoader.getService(TypedJobItemExecutor.class, (Object)type));
    }

    private ElasticJobExecutor(ElasticJob elasticJob, JobConfiguration jobConfig, JobFacade jobFacade, JobItemExecutor jobItemExecutor) {
        this.elasticJob = elasticJob;
        this.jobFacade = jobFacade;
        this.jobItemExecutor = jobItemExecutor;
        JobConfiguration loadedJobConfig = jobFacade.loadJobConfiguration(true);
        this.executorServiceReloader = new ExecutorServiceReloader(loadedJobConfig);
        this.jobErrorHandlerReloader = new JobErrorHandlerReloader(loadedJobConfig);
        this.itemErrorMessages = new ConcurrentHashMap<Integer, String>(jobConfig.getShardingTotalCount(), 1.0f);
    }

    public void execute() {
        JobConfiguration jobConfig = this.jobFacade.loadJobConfiguration(true);
        this.executorServiceReloader.reloadIfNecessary(jobConfig);
        this.jobErrorHandlerReloader.reloadIfNecessary(jobConfig);
        JobErrorHandler jobErrorHandler = this.jobErrorHandlerReloader.getJobErrorHandler();
        try {
            this.jobFacade.checkJobExecutionEnvironment();
        }
        catch (JobExecutionEnvironmentException cause) {
            jobErrorHandler.handleException(jobConfig.getJobName(), (Throwable)cause);
        }
        ShardingContexts shardingContexts = this.jobFacade.getShardingContexts();
        this.jobFacade.postJobStatusTraceEvent(shardingContexts.getTaskId(), JobStatusTraceEvent.State.TASK_STAGING, String.format("Job '%s' execute begin.", jobConfig.getJobName()));
        if (this.jobFacade.misfireIfRunning(shardingContexts.getShardingItemParameters().keySet())) {
            this.jobFacade.postJobStatusTraceEvent(shardingContexts.getTaskId(), JobStatusTraceEvent.State.TASK_FINISHED, String.format("Previous job '%s' - shardingItems '%s' is still running, misfired job will start after previous job completed.", jobConfig.getJobName(), shardingContexts.getShardingItemParameters().keySet()));
            return;
        }
        try {
            this.jobFacade.beforeJobExecuted(shardingContexts);
        }
        catch (Throwable cause) {
            jobErrorHandler.handleException(jobConfig.getJobName(), cause);
        }
        this.execute(jobConfig, shardingContexts, JobExecutionEvent.ExecutionSource.NORMAL_TRIGGER);
        while (this.jobFacade.isExecuteMisfired(shardingContexts.getShardingItemParameters().keySet())) {
            this.jobFacade.clearMisfire(shardingContexts.getShardingItemParameters().keySet());
            this.execute(jobConfig, shardingContexts, JobExecutionEvent.ExecutionSource.MISFIRE);
        }
        this.jobFacade.failoverIfNecessary();
        try {
            this.jobFacade.afterJobExecuted(shardingContexts);
        }
        catch (Throwable cause) {
            jobErrorHandler.handleException(jobConfig.getJobName(), cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(JobConfiguration jobConfig, ShardingContexts shardingContexts, JobExecutionEvent.ExecutionSource executionSource) {
        if (shardingContexts.getShardingItemParameters().isEmpty()) {
            this.jobFacade.postJobStatusTraceEvent(shardingContexts.getTaskId(), JobStatusTraceEvent.State.TASK_FINISHED, String.format("Sharding item for job '%s' is empty.", jobConfig.getJobName()));
            return;
        }
        this.jobFacade.registerJobBegin(shardingContexts);
        String taskId = shardingContexts.getTaskId();
        this.jobFacade.postJobStatusTraceEvent(taskId, JobStatusTraceEvent.State.TASK_RUNNING, "");
        try {
            this.process(jobConfig, shardingContexts, executionSource);
        }
        finally {
            this.jobFacade.registerJobCompleted(shardingContexts);
            if (this.itemErrorMessages.isEmpty()) {
                this.jobFacade.postJobStatusTraceEvent(taskId, JobStatusTraceEvent.State.TASK_FINISHED, "");
            } else {
                this.jobFacade.postJobStatusTraceEvent(taskId, JobStatusTraceEvent.State.TASK_ERROR, this.itemErrorMessages.toString());
                this.itemErrorMessages.clear();
            }
        }
    }

    private void process(JobConfiguration jobConfig, ShardingContexts shardingContexts, JobExecutionEvent.ExecutionSource executionSource) {
        Set items = shardingContexts.getShardingItemParameters().keySet();
        if (1 == items.size()) {
            int item = (Integer)shardingContexts.getShardingItemParameters().keySet().iterator().next();
            JobExecutionEvent jobExecutionEvent = new JobExecutionEvent(IpUtils.getHostName(), IpUtils.getIp(), shardingContexts.getTaskId(), jobConfig.getJobName(), executionSource, item);
            this.process(jobConfig, shardingContexts, item, jobExecutionEvent);
            return;
        }
        CountDownLatch latch = new CountDownLatch(items.size());
        Iterator jobExecutionEvent = items.iterator();
        while (jobExecutionEvent.hasNext()) {
            int each = (Integer)jobExecutionEvent.next();
            JobExecutionEvent jobExecutionEvent2 = new JobExecutionEvent(IpUtils.getHostName(), IpUtils.getIp(), shardingContexts.getTaskId(), jobConfig.getJobName(), executionSource, each);
            ExecutorService executorService = this.executorServiceReloader.getExecutorService();
            if (executorService.isShutdown()) {
                return;
            }
            executorService.submit(() -> {
                try {
                    this.process(jobConfig, shardingContexts, each, jobExecutionEvent2);
                }
                finally {
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    private void process(JobConfiguration jobConfig, ShardingContexts shardingContexts, int item, JobExecutionEvent startEvent) {
        this.jobFacade.postJobExecutionEvent(startEvent);
        log.trace("Job '{}' executing, item is: '{}'.", (Object)jobConfig.getJobName(), (Object)item);
        try {
            this.jobItemExecutor.process(this.elasticJob, jobConfig, this.jobFacade.getJobRuntimeService(), shardingContexts.createShardingContext(item));
            JobExecutionEvent completeEvent = startEvent.executionSuccess();
            log.trace("Job '{}' executed, item is: '{}'.", (Object)jobConfig.getJobName(), (Object)item);
            this.jobFacade.postJobExecutionEvent(completeEvent);
        }
        catch (Throwable cause) {
            JobExecutionEvent completeEvent = startEvent.executionFailure(ExceptionUtils.transform(cause));
            this.jobFacade.postJobExecutionEvent(completeEvent);
            this.itemErrorMessages.put(item, ExceptionUtils.transform(cause));
            JobErrorHandler jobErrorHandler = this.jobErrorHandlerReloader.getJobErrorHandler();
            jobErrorHandler.handleException(jobConfig.getJobName(), cause);
        }
    }

    public void shutdown() {
        this.executorServiceReloader.close();
        this.jobErrorHandlerReloader.close();
    }
}

