/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.tracing.rdb.storage.sql;

import java.io.InputStream;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.tracing.rdb.storage.type.TracingStorageDatabaseType;

public final class SQLPropertiesFactory {
    public static Properties getProperties(TracingStorageDatabaseType type) {
        return SQLPropertiesFactory.loadProps(String.format("%s.properties", type.getType()));
    }

    private static Properties loadProps(String sqlPropertiesFileName) {
        Properties result = new Properties();
        result.load(SQLPropertiesFactory.getPropertiesInputStream(sqlPropertiesFileName));
        return result;
    }

    private static InputStream getPropertiesInputStream(String sqlPropertiesFileName) {
        InputStream sqlPropertiesFile = SQLPropertiesFactory.class.getClassLoader().getResourceAsStream(String.format("META-INF/sql/%s", sqlPropertiesFileName));
        return null == sqlPropertiesFile ? SQLPropertiesFactory.class.getClassLoader().getResourceAsStream("META-INF/sql/SQL92.properties") : sqlPropertiesFile;
    }

    @Generated
    private SQLPropertiesFactory() {
    }
}

