/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.auth.authentication.builder;

import com.google.protobuf.GeneratedMessageV3;
import io.grpc.Metadata;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.acl.common.AclUtils;
import org.apache.rocketmq.auth.authentication.builder.AuthenticationContextBuilder;
import org.apache.rocketmq.auth.authentication.context.DefaultAuthenticationContext;
import org.apache.rocketmq.auth.authentication.exception.AuthenticationException;
import org.apache.rocketmq.common.MQVersion;
import org.apache.rocketmq.common.constant.GrpcConstants;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class DefaultAuthenticationContextBuilder
implements AuthenticationContextBuilder<DefaultAuthenticationContext> {
    private static final String CREDENTIAL = "Credential";
    private static final String SIGNATURE = "Signature";

    @Override
    public DefaultAuthenticationContext build(Metadata metadata, GeneratedMessageV3 request) {
        try {
            String[] keyValues;
            DefaultAuthenticationContext context = new DefaultAuthenticationContext();
            context.setChannelId((String)metadata.get(GrpcConstants.CHANNEL_ID));
            context.setRpcCode(request.getDescriptorForType().getFullName());
            String authorization = (String)metadata.get(GrpcConstants.AUTHORIZATION);
            if (StringUtils.isEmpty((CharSequence)authorization)) {
                return context;
            }
            String datetime = (String)metadata.get(GrpcConstants.DATE_TIME);
            if (StringUtils.isEmpty((CharSequence)datetime)) {
                throw new AuthenticationException("datetime is null.");
            }
            String[] result = authorization.split(" ", 2);
            if (result.length != 2) {
                throw new AuthenticationException("authentication header is incorrect.");
            }
            for (String keyValue : keyValues = result[1].split(",")) {
                String[] kv = keyValue.trim().split("=", 2);
                int kvLength = kv.length;
                if (kv.length != 2) {
                    throw new AuthenticationException("authentication keyValues length is incorrect, actual length={}.", kvLength);
                }
                String authItem = kv[0];
                if (CREDENTIAL.equals(authItem)) {
                    String[] credential = kv[1].split("/");
                    int credentialActualLength = credential.length;
                    if (credentialActualLength == 0) {
                        throw new AuthenticationException("authentication credential length is incorrect, actual length={}.", credentialActualLength);
                    }
                    context.setUsername(credential[0]);
                    continue;
                }
                if (!SIGNATURE.equals(authItem)) continue;
                context.setSignature(this.hexToBase64(kv[1]));
            }
            context.setContent(datetime.getBytes(StandardCharsets.UTF_8));
            return context;
        }
        catch (AuthenticationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new AuthenticationException("create authentication context error.", e);
        }
    }

    @Override
    public DefaultAuthenticationContext build(ChannelHandlerContext context, RemotingCommand request) {
        HashMap fields = request.getExtFields();
        DefaultAuthenticationContext result = new DefaultAuthenticationContext();
        result.setChannelId(context.channel().id().asLongText());
        result.setRpcCode(String.valueOf(request.getCode()));
        if (MapUtils.isEmpty((Map)fields)) {
            return result;
        }
        if (!fields.containsKey("AccessKey")) {
            return result;
        }
        result.setUsername((String)fields.get("AccessKey"));
        result.setSignature((String)fields.get(SIGNATURE));
        TreeMap map = new TreeMap();
        for (Map.Entry entry : fields.entrySet()) {
            if (request.getVersion() <= MQVersion.Version.V4_9_3.ordinal() && "_UNIQUE_KEY_QUERY".equals(entry.getKey()) || SIGNATURE.equals(entry.getKey())) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        result.setContent(AclUtils.combineRequestContent((RemotingCommand)request, map));
        return result;
    }

    public String hexToBase64(String input) throws DecoderException {
        byte[] bytes = Hex.decodeHex((String)input);
        return Base64.encodeBase64String((byte[])bytes);
    }
}

